/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.subject;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;

public class SubjectMappingEdit
extends AbstractBasePlugIn
implements BeforeFilterF7SelectListener {
    private static List<String> filterFieldKeys;
    private static final String OP_OK = "ok";
    private static List<String> FOREX_BILLS;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterControl();
        String mapping = (String)this.getView().getFormShowParameter().getCustomParam("mapping");
        if (EmptyUtil.isNotEmpty((CharSequence)mapping)) {
            this.initCondition(mapping);
        }
    }

    private void initCondition(String mapping) {
        FilterCondition filterCondition;
        if (EmptyUtil.isNoEmpty((String)mapping) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mapping, FilterCondition.class)) != null) {
            FilterGrid filterControl = (FilterGrid)this.getView().getControl("filtergrid");
            filterControl.SetValue(filterCondition);
        }
    }

    private void initFilterControl() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.setEntityNumber(this.getEntityNumber());
        filterGrid.SetValue(new FilterCondition());
        filterGrid.setFilterFieldKeys(filterFieldKeys);
        this.getView().updateView("filtergrid");
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        if (e.getFieldName().contains("billtype")) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getParentView().getControl("subjecttreeentry");
            int[] selectRows = treeEntryGrid.getSelectRows();
            int selectRow = selectRows[0];
            DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("subjecttreeentry");
            ArrayList billTypes = new ArrayList(RateBillTypeEnum.values().length);
            for (int i = 0; i < entryEntity.size(); ++i) {
                String mappingTag;
                if (selectRow == i || EmptyUtil.isEmpty((String)(mappingTag = ((DynamicObject)entryEntity.get(i)).getString("mapping_tag")))) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mappingTag, FilterCondition.class);
                List filterRow = filterCondition.getFilterRow();
                for (SimpleFilterRow simpleFilterRow : filterRow) {
                    List value = simpleFilterRow.getBaseDataIds();
                    List collect = value.stream().map(a -> (String)a.getValue()).collect(Collectors.toList());
                    billTypes.addAll(collect);
                }
            }
            billTypes.removeAll(FOREX_BILLS);
            List<String> alltypes = this.getBillTypeListByRiskType(this.getRiskType());
            e.addCustomQFilter(new QFilter("number", "in", (Object)alltypes.toArray(new String[0])).and("number", "not in", billTypes));
        }
    }

    private String getRiskType() {
        return (String)this.getView().getFormShowParameter().getCustomParam("risktype");
    }

    private List<String> getBillTypeListByRiskType(String risktype) {
        ArrayList<String> types = new ArrayList<String>(10);
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        qf.and("type", "=", (Object)risktype);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mrm_draft_datasource", (String)"sourcebill.number", (QFilter[])qf.toArray());
        for (DynamicObject ob : col) {
            types.add(ob.getString("sourcebill.number"));
        }
        return types;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if (OP_OK.equals(key)) {
            Set<String> dupBillTypes;
            TreeEntryGrid treeEntryGrid;
            int[] selectRows;
            int selectRow;
            DynamicObjectCollection entryEntity;
            String selectedRowCashFlowDir;
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            List filterRow = filterCondition.getFilterRow();
            ArrayList<String> fieldNames = new ArrayList<String>(10);
            ArrayList<String> billTypes = new ArrayList<String>(10);
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                if (fieldNames.contains(fieldName)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u91cd\u590d,\u8bf7\u5220\u9664\u91cd\u590d\u5b57\u6bb5\u3002", (String)"SubjectMappingEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                fieldNames.add(fieldName);
                List value = simpleFilterRow.getBaseDataIds();
                List collect = value.stream().map(a -> (String)a.getValue()).collect(Collectors.toList());
                billTypes.addAll(collect);
            }
            billTypes.retainAll(FOREX_BILLS);
            if (billTypes.size() > 0 && !EmptyUtil.isEmpty((String)(selectedRowCashFlowDir = ((DynamicObject)(entryEntity = this.getView().getParentView().getModel().getEntryEntity("subjecttreeentry")).get(selectRow = (selectRows = (treeEntryGrid = (TreeEntryGrid)this.getView().getParentView().getControl("subjecttreeentry")).getSelectRows())[0])).getString("direct"))) && (dupBillTypes = this.checkFxDuplicate(entryEntity, selectRow, billTypes)) != null && !dupBillTypes.isEmpty()) {
                DynamicObject[] billNames = TmcDataServiceHelper.load((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "in", dupBillTypes)});
                ArrayList<String> nameList = new ArrayList<String>(billNames.length);
                for (DynamicObject nameDO : billNames) {
                    nameList.add(nameDO.getLocaleString("name").getLocaleValue());
                }
                String dirDisplay = ResManager.loadKDString((String)"\u6d41\u5165", (String)"SubjectMappingEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
                if ("out".equals(selectedRowCashFlowDir)) {
                    dirDisplay = ResManager.loadKDString((String)"\u6d41\u51fa", (String)"SubjectMappingEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u6709%2$s\u65b9\u5411\u7684\u79d1\u76ee\u6620\u5c04\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SubjectMappingEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", nameList), dirDisplay));
                args.setCancel(true);
            }
        }
    }

    private Set<String> checkFxDuplicate(DynamicObjectCollection entryEntity, int selectRow, List<String> billTypeMaping) {
        String selectedRowCashFlowDir = ((DynamicObject)entryEntity.get(selectRow)).getString("direct");
        if (EmptyUtil.isEmpty((String)selectedRowCashFlowDir)) {
            return null;
        }
        HashSet<String> dupBillTypes = new HashSet<String>(10);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String mappingTag;
            if (selectRow == i || !selectedRowCashFlowDir.equals(((DynamicObject)entryEntity.get(i)).getString("direct")) || EmptyUtil.isEmpty((String)(mappingTag = ((DynamicObject)entryEntity.get(i)).getString("mapping_tag")))) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mappingTag, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            ArrayList billTypes = new ArrayList(10);
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                List value = simpleFilterRow.getBaseDataIds();
                List collect = value.stream().map(a -> (String)a.getValue()).collect(Collectors.toList());
                billTypes.addAll(collect);
            }
            billTypes.retainAll(billTypeMaping);
            dupBillTypes.addAll(billTypes);
        }
        return dupBillTypes;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if (OP_OK.equals(key)) {
            String filterConditionStr = this.getFilterConditionStr();
            this.getView().returnDataToParent((Object)filterConditionStr);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private String getFilterConditionStr() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
    }

    private String getEntityNumber() {
        String risktype = (String)this.getView().getFormShowParameter().getCustomParam("risktype");
        if ("rate".equals(risktype)) {
            return "mrm_rate_draft_data";
        }
        if ("exrate".equals(risktype)) {
            return "mrm_exrate_draft_data";
        }
        return null;
    }

    static {
        FOREX_BILLS = new ArrayList<String>(4);
        filterFieldKeys = new ArrayList<String>();
        filterFieldKeys.add("billtype.name");
        FOREX_BILLS.add("tm_forex");
        FOREX_BILLS.add("tm_forex_forward");
        FOREX_BILLS.add("tm_forex_options");
        FOREX_BILLS.add("tm_forex_swaps");
    }
}

