/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.subject;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubjectSystemEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        String s;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter && OperationStatus.EDIT == formShowParameter.getStatus() && (s = this.validateReference(((BaseShowParameter)formShowParameter).getPkId())) != null) {
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("tipStr", (Object)s);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"map"});
        BasedataEdit subject = (BasedataEdit)this.getControl("subject");
        subject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        subject.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String ctrlName = source.getKey();
        if ("map".equals(ctrlName)) {
            String risktype = (String)this.getModel().getValue("risktype");
            if (EmptyUtil.isEmpty((String)risktype)) {
                IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty("risktype");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"SubjectSystemEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[]{prop.getDisplayName().getLocaleValue()}));
                return;
            }
            EntryGrid treeentryentity = (EntryGrid)this.getControl("subjecttreeentry");
            int[] selectRows = treeentryentity.getSelectRows();
            Boolean isleaf = (Boolean)this.getModel().getValue("isleaf", selectRows[0]);
            if (!isleaf.booleanValue()) {
                return;
            }
            String mapping = (String)this.getModel().getValue("mapping_tag", selectRows[0]);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mrm_subject_map");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "map"));
            if (EmptyUtil.isNotEmpty((CharSequence)mapping)) {
                showParameter.setCustomParam("mapping", (Object)mapping);
            }
            showParameter.setCustomParam("risktype", (Object)risktype);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("status", (Object)BillStatusEnum.SAVE);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryEntities;
        String s;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus() && (s = (String)formShowParameter.getCustomParam("tipStr")) != null) {
            this.getView().showTipNotification(s);
        }
        if (!(entryEntities = this.getModel().getEntryEntity("subjecttreeentry")).isEmpty()) {
            TreeEntryGrid subjectTree = (TreeEntryGrid)this.getControl("subjecttreeentry");
            List collect = entryEntities.stream().filter(a -> a.getLong("pid") == 0L).collect(Collectors.toList());
            int[] rows = new int[collect.size()];
            for (int i = 0; i < collect.size(); ++i) {
                rows[i] = ((DynamicObject)collect.get(i)).getInt("seq") - 1;
            }
            subjectTree.expand(rows);
        }
        this.setFields();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String map;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("map".equals(name) && EmptyUtil.isEmpty((String)(map = (String)this.getModel().getValue("map")))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"mapping_tag", null, (int)rowIndex);
        }
        if ("risktype".equals(name)) {
            this.getModel().deleteEntryData("subjecttreeentry");
        }
    }

    private void setFields() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("subjecttreeentry");
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(i);
            String mappingTag = entryEntity.getString("mapping_tag");
            if (!EmptyUtil.isNotEmpty((CharSequence)mappingTag)) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mappingTag, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                List baseDataIds = simpleFilterRow.getBaseDataIds();
                List objectTypeNumber = baseDataIds.stream().map(e -> (String)e.getValue()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("number", "in", objectTypeNumber);
                DynamicObject[] objectType = TmcDataServiceHelper.load((String)"bos_objecttype", (String)"name", (QFilter[])new QFilter[]{qFilter});
                String name = Arrays.stream(objectType).map(e -> e.getString("name")).collect(Collectors.joining(","));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"map", (Object)name, (int)i);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "delentry": {
                this.getView().invokeOperation("delentry");
                this.refreshTree();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        switch (operateKey = event.getOperateKey()) {
            case "newentry": 
            case "insertentry": {
                this.refreshTree();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("map".equals(actionId)) {
            String returnData = (String)event.getReturnData();
            if (EmptyUtil.isEmpty((String)returnData)) {
                return;
            }
            EntryGrid treeentryentity = (EntryGrid)this.getControl("subjecttreeentry");
            int[] selectRows = treeentryentity.getSelectRows();
            int selectRow = selectRows[0];
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)returnData, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            if (filterRow.size() > 0) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"mapping_tag", (Object)returnData, (int)selectRow);
                for (SimpleFilterRow simpleFilterRow : filterRow) {
                    List value = simpleFilterRow.getValue();
                    String collect = value.stream().map(e -> (String)e.getValue()).collect(Collectors.joining(","));
                    this.getModel().setValue("map", (Object)collect, selectRow);
                }
            } else {
                this.getModel().setValue("map", null, selectRow);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"mapping_tag", null, (int)selectRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObjectCollection entryEntity;
        String name = event.getProperty().getName();
        if ("subject".equals(name) && !(entryEntity = this.getModel().getEntryEntity("subjecttreeentry")).isEmpty()) {
            Object[] ids = entryEntity.stream().filter(e -> e.getDynamicObject("subject") != null).map(e -> e.getDynamicObject("subject").getPkValue()).toArray();
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", "not in", (Object)ids));
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String actionId = ((BasedataEdit)afterF7SelectEvent.getSource()).getKey();
        if ("subject".equals(actionId)) {
            this.refreshTree();
        }
    }

    private void refreshTree() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subjecttreeentry");
        if (entryEntity != null) {
            List firstLevels = entryEntity.stream().filter(e -> e.getLong("pid") == 0L).collect(Collectors.toList());
            int firstLevelSeq = 1;
            for (int i = 0; i < firstLevels.size(); ++i) {
                int seq = ((DynamicObject)firstLevels.get(i)).getInt("seq") - 1;
                int end = i != firstLevels.size() - 1 ? ((DynamicObject)firstLevels.get(i + 1)).getInt("seq") - 1 : entryEntity.size();
                block1: for (int j = seq; j <= end - 1; ++j) {
                    DynamicObject currEntry = (DynamicObject)entryEntity.get(j);
                    boolean isGroupNode = entryEntity.stream().anyMatch(e -> e.getLong("pid") == currEntry.getLong("id"));
                    this.getModel().setValue("isleaf", (Object)(!isGroupNode ? 1 : 0), j);
                    if (j == seq) {
                        String ordernum = String.valueOf(firstLevelSeq);
                        this.getModel().setValue("ordernum", (Object)ordernum, j);
                        this.getModel().setValue("level", (Object)ordernum.split("\\.").length, j);
                        continue;
                    }
                    DynamicObject leftEntry = (DynamicObject)entryEntity.get(j - 1);
                    long pid = currEntry.getLong("pid");
                    String leftOrderNum = leftEntry.getString("ordernum");
                    if (pid == leftEntry.getLong("id")) {
                        String ordernum = leftOrderNum + ".1";
                        this.getModel().setValue("ordernum", (Object)ordernum, j);
                        this.getModel().setValue("level", (Object)ordernum.split("\\.").length, j);
                        continue;
                    }
                    if (pid == leftEntry.getLong("pid")) {
                        String[] split = leftOrderNum.split("\\.");
                        String lastIndex = split[split.length - 1];
                        int newLastIndex = Integer.parseInt(lastIndex) + 1;
                        this.getModel().setValue("ordernum", (Object)(leftOrderNum.substring(0, leftOrderNum.lastIndexOf(".")) + "." + newLastIndex), j);
                        this.getModel().setValue("level", (Object)split.length, j);
                        continue;
                    }
                    for (int k = j - 1; k > 0; --k) {
                        DynamicObject leftEntryk = (DynamicObject)entryEntity.get(k - 1);
                        String leftOrderNum1 = leftEntryk.getString("ordernum");
                        if (pid == leftEntryk.getLong("id")) {
                            String ordernum = leftOrderNum + ".1";
                            this.getModel().setValue("ordernum", (Object)ordernum, j);
                            this.getModel().setValue("level", (Object)ordernum.split("\\.").length, j);
                            continue block1;
                        }
                        if (pid != leftEntryk.getLong("pid")) continue;
                        String[] split = leftOrderNum1.split("\\.");
                        String lastIndex = split[split.length - 1];
                        int newLastIndex = Integer.parseInt(lastIndex) + 1;
                        this.getModel().setValue("ordernum", (Object)(leftOrderNum1.substring(0, leftOrderNum1.lastIndexOf(".")) + "." + newLastIndex), j);
                        this.getModel().setValue("level", (Object)split.length, j);
                        continue block1;
                    }
                }
                ++firstLevelSeq;
            }
        }
    }

    private String validateReference(Object id) {
        List list;
        if (EmptyUtil.isNoEmpty((Object)id) && !(list = BaseDataRefrenceHelper.getAllRefs((String)"mrm_subject_system", (Object)id)).isEmpty()) {
            Set refEntitySet = list.stream().map(o -> o.getRefEntityKey()).collect(Collectors.toSet());
            Set<String> bills = new HashSet<String>(3);
            if (refEntitySet.contains("mrm_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_sensitivity").getDisplayName().getLocaleValue());
            }
            if (!bills.isEmpty()) {
                bills = bills.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toSet());
                return ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u5206\u6790\u79d1\u76ee\u4f53\u7cfb\u5df2\u88ab%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SubjectSystemSaveValidator_11", (String)"tmc-mrm-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", bills)});
            }
        }
        return null;
    }
}

