/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.business.opservice.enable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.enums.SettleEnableStatusEnum;

public class SettleEnableBatchSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("periodtype");
        selector.add("entryentity");
        selector.add("entryentity.enableid");
        selector.add("entryentity.org");
        selector.add("entryentity.cfmcurrentperiod");
        selector.add("entryentity.cfmstartperiod");
        selector.add("entryentity.lccurrentperiod");
        selector.add("entryentity.lcstartperiod");
        selector.add("entryentity.cimcurrentperiod");
        selector.add("entryentity.cimstartperiod");
        selector.add("entryentity.bdimcurrentperiod");
        selector.add("entryentity.bdimstartperiod");
        selector.add("entryentity.cdmcurrentperiod");
        selector.add("entryentity.cdmstartperiod");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject periodType = dataEntity.getDynamicObject("periodtype");
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject org = entry.getDynamicObject("org");
                DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"pec_settle_enable");
                newDynamicObject.set("org", (Object)org);
                newDynamicObject.set("number", (Object)org.getString("number"));
                newDynamicObject.set("name", (Object)org.getString("name"));
                newDynamicObject.set("periodtype", (Object)periodType);
                newDynamicObject.set("cfmcurrentperiod", (Object)entry.getDynamicObject("cfmcurrentperiod"));
                newDynamicObject.set("cfmstartperiod", (Object)entry.getDynamicObject("cfmstartperiod"));
                newDynamicObject.set("lccurrentperiod", (Object)entry.getDynamicObject("lccurrentperiod"));
                newDynamicObject.set("lcstartperiod", (Object)entry.getDynamicObject("lcstartperiod"));
                newDynamicObject.set("cimcurrentperiod", (Object)entry.getDynamicObject("cimcurrentperiod"));
                newDynamicObject.set("cimstartperiod", (Object)entry.getDynamicObject("cimstartperiod"));
                newDynamicObject.set("bdimcurrentperiod", (Object)entry.getDynamicObject("bdimcurrentperiod"));
                newDynamicObject.set("bdimstartperiod", (Object)entry.getDynamicObject("bdimstartperiod"));
                newDynamicObject.set("cdmcurrentperiod", (Object)entry.getDynamicObject("cdmcurrentperiod"));
                newDynamicObject.set("cdmstartperiod", (Object)entry.getDynamicObject("cdmstartperiod"));
                this.setEnable(entry, newDynamicObject);
                saveList.add(newDynamicObject);
            }
            List authedOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"pec", (String)"pec_settle_enable", (String)"47150e89000000ac");
            DeleteServiceHelper.delete((String)"pec_settle_enable", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authedOrgIds)});
            if (!EmptyUtil.isNoEmpty(saveList)) continue;
            TmcDataServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private void setEnable(DynamicObject entry, DynamicObject newDynamicObject) {
        this.setEnableStatus(entry, newDynamicObject, "cfmcurrentperiod", "cfmstartperiod", "cfmstatus");
        this.setEnableStatus(entry, newDynamicObject, "lccurrentperiod", "lcstartperiod", "lcstatus");
        this.setEnableStatus(entry, newDynamicObject, "cimcurrentperiod", "cimstartperiod", "cimstatus");
        this.setEnableStatus(entry, newDynamicObject, "bdimcurrentperiod", "bdimstartperiod", "bdimstatus");
        this.setEnableStatus(entry, newDynamicObject, "cdmcurrentperiod", "cdmstartperiod", "cdmstatus");
    }

    private void setEnableStatus(DynamicObject entry, DynamicObject newDynamicObject, String currentPeriod, String startPeriod, String status) {
        Date startBeginDate;
        Date curBeginDate;
        newDynamicObject.set(status, (Object)SettleEnableStatusEnum.NOT_ENABLED.getValue());
        DynamicObject cfmCurrentPeriod = entry.getDynamicObject(currentPeriod);
        DynamicObject cfmStartPeriod = entry.getDynamicObject(startPeriod);
        if (EmptyUtil.isNoEmpty((DynamicObject)cfmCurrentPeriod) && EmptyUtil.isNoEmpty((DynamicObject)cfmStartPeriod) && (curBeginDate = DateUtils.getDataFormat((Date)cfmCurrentPeriod.getDate("begindate"), (boolean)true)).compareTo(startBeginDate = DateUtils.getDataFormat((Date)cfmStartPeriod.getDate("begindate"), (boolean)true)) >= 0) {
            newDynamicObject.set(status, (Object)SettleEnableStatusEnum.ENABLED.getValue());
        }
    }
}

