/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.business.opservice.settleacct;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.enums.SettleAcctTypeEnum;

public class SettleAccountRevertService
extends AbstractTmcBizOppService {
    private List<DynamicObject> logDynList = new ArrayList<DynamicObject>();

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map opMap = this.getOperationVariable();
        List pairList = (List)SerializationUtils.fromJsonString((String)((String)opMap.get("orgAppPair")), List.class);
        for (String pair : pairList) {
            String[] pairArr = pair.split(",");
            long orgId = Long.parseLong(pairArr[0]);
            String bizApp = pairArr[1];
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            DynamicObject bizBookAcct = TmcDataServiceHelper.loadSingleFromCache((String)"pec_settle_enable", (String)"id", (QFilter[])new QFilter[]{qFilter});
            OperateOption option = OperateOption.create();
            option.setVariableValue("bizapp", bizApp);
            option.setVariableValue("currentPeriod", (String)opMap.get("currentPeriod"));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"anticloseperiod", (String)"pec_settle_enable", (Object[])new Object[]{bizBookAcct.getLong("id")}, (OperateOption)option);
            DynamicObject logDyn = TmcDataServiceHelper.newDynamicObject((String)"pec_financialcloselog");
            logDyn.set("org", (Object)orgId);
            DynamicObject appDyn = TmcDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizApp)});
            logDyn.set("bizappid", (Object)appDyn);
            logDyn.set("curperiod", opMap.get("currentPeriod"));
            logDyn.set("closestate", (Object)(operationResult.isSuccess() ? "1" : "2"));
            logDyn.set("closeuser", (Object)RequestContext.get().getCurrUserId());
            logDyn.set("closedate", (Object)DateUtils.getCurrentDate());
            logDyn.set("createdate", (Object)new Date());
            logDyn.set("logtype", (Object)SettleAcctTypeEnum.ANTICLOSEPERIOD.getValue());
            if (!operationResult.isSuccess()) {
                StringBuilder sb = new StringBuilder();
                ValidateResultCollection validateResult = operationResult.getValidateResult();
                if (EmptyUtil.isNoEmpty((Object)validateResult) && EmptyUtil.isNoEmpty((Object)validateResult.getValidateErrors())) {
                    List validateErrors = validateResult.getValidateErrors();
                    for (ValidateResult vali : validateErrors) {
                        List errMsgList = vali.getAllErrorInfo().stream().map(r -> r.getMessage()).collect(Collectors.toList());
                        sb.append(String.join((CharSequence)",", errMsgList));
                    }
                }
                if (EmptyUtil.isEmpty((String)sb.toString())) {
                    sb.append(validateResult.getMessage());
                }
                logDyn.set("faildetails", (Object)sb.toString());
            }
            this.logDynList.add(logDyn);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isEmpty(this.logDynList)) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])this.logDynList.toArray(new DynamicObject[0]));
        }
    }
}

