/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.business.opservice.settlectlrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SettleCtlRuleUnRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizbill");
        selector.add("checkop");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            String entityNumber = dataEntity.getDynamicObject("bizbill").getString("number");
            QFilter filter = new QFilter("bizbill.number", "=", (Object)entityNumber);
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "!=", dataEntity.getPkValue());
            DynamicObjectCollection strategySets = QueryServiceHelper.query((String)"pec_settlectlrule", (String)"id,checkop", (QFilter[])new QFilter[]{filter});
            HashSet otherOpSet = new HashSet(16);
            for (DynamicObject strategySet : strategySets) {
                otherOpSet.addAll(Arrays.stream(strategySet.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"service_settlectlrule");
                    if (!EmptyUtil.isNoEmpty(otherOpSet)) continue;
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)"service_settlectlrule", new ArrayList(otherOpSet));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

