/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class ReconciliationCenterDataPlugin
extends AbstractTmcListDataPlugin {
    private static final String[] appArr = new String[]{"cfm", "lc", "cim", "bdim", "cdm", "ifm"};

    public DataSet query(ReportQueryParam reportQueryParam) {
        Map paraMap = this.transQueryParam(reportQueryParam);
        DataSet baseDs = this.buildBaseDs(paraMap);
        DataSet frmTaskDs = this.queryFrmTaskData(paraMap);
        DataSet joinedDs = baseDs.leftJoin(frmTaskDs).on("accountingorg", "org").on("bizapp", "bizapp").on("accbooktype", "booktype").on("recperiod", "period").select(baseDs.getRowMeta().getFieldNames(), new String[]{"reconresult", "createtime"}).finish();
        DataSet resultDs = this.dealJoinDs(paraMap, joinedDs);
        return resultDs;
    }

    private DataSet dealJoinDs(Map<String, Object> paraMap, DataSet joinedDs) {
        String statusStr = (String)paraMap.get("filter_recstatus");
        List statusList = Arrays.stream(statusStr.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        DataSet filteredDs = joinedDs.select("accountingorg,bankrollorg,accbooktype,recperiod,bizapp,createtime,case when reconresult is null then '3' else reconresult end reconresult").filter("reconresult in ('" + String.join((CharSequence)"','", statusList) + "')");
        DataSet resultDs = filteredDs.executeSql("select accountingorg,bankrollorg,accbooktype,recperiod,sum(case when bizapp = 'cfm' then cast(reconresult as Integer) else 0 end) as cfmrecstatus,max(case when bizapp = 'cfm' then createtime end) as cfmrectime,sum(case when bizapp = 'cim' then cast(reconresult as Integer) else 0 end) as cimrecstatus,max(case when bizapp = 'cim' then createtime end) as cimrectime,sum(case when bizapp = 'ifm' then cast(reconresult as Integer) else 0 end) as ifmrecstatus,max(case when bizapp = 'ifm' then createtime end) as ifmrectime,sum(case when bizapp = 'cdm' then cast(reconresult as Integer) else 0 end) as cdmrecstatus,max(case when bizapp = 'cdm' then createtime end) as cdmrectime,sum(case when bizapp = 'bdim' then cast(reconresult as Integer) else 0 end) as bdimrecstatus,max(case when bizapp = 'bdim' then createtime end) as bdimrectime,sum(case when bizapp = 'lc' then cast(reconresult as Integer) else 0 end) as lcrecstatus,max(case when bizapp = 'lc' then createtime end) as lcrectime group by accountingorg,bankrollorg,accbooktype,recperiod");
        return resultDs;
    }

    private DataSet buildBaseDs(Map<String, Object> paraMap) {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("accountingorg", (DataType)DataType.LongType));
        field.add(new Field("bankrollorg", (DataType)DataType.LongType));
        field.add(new Field("accbooktype", (DataType)DataType.LongType));
        field.add(new Field("recperiod", (DataType)DataType.LongType));
        field.add(new Field("bizapp", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"SettleAcctCenterDataPlugin_BaseDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        Map orgPair = (Map)paraMap.get("orgpair");
        long bookType = ((DynamicObject)paraMap.get("filter_accbooktype")).getLong("id");
        long period = ((DynamicObject)paraMap.get("filter_recperiod")).getLong("id");
        String bizApps = (String)paraMap.get("filter_recbizapp");
        List appList = Arrays.stream(bizApps.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        for (Map.Entry entry : orgPair.entrySet()) {
            for (String app : appList) {
                Object[] obj = new Object[]{entry.getKey(), entry.getValue(), bookType, period, app};
                dsBuilder.append(obj);
            }
        }
        return dsBuilder.build();
    }

    private DataSet queryFrmTaskData(Map<String, Object> paraMap) {
        Map orgPair = (Map)paraMap.get("orgpair");
        QFilter qFilter = new QFilter("org", "in", orgPair.keySet());
        long bookType = ((DynamicObject)paraMap.get("filter_accbooktype")).getLong("id");
        qFilter.and("booktype", "=", (Object)bookType);
        long period = ((DynamicObject)paraMap.get("filter_recperiod")).getLong("id");
        qFilter.and("period", "=", (Object)period);
        Map bizAppMap = TmcDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)appArr)});
        qFilter.and("bizapp", "in", bizAppMap.keySet());
        DataSet taskDs = QueryServiceHelper.queryDataSet((String)"SettleAcctCenterDataPlugin_queryFrmTask", (String)"frm_task", (String)"id, org, bizapp.number bizapp, reconresult, createtime, booktype, period", (QFilter[])qFilter.toArray(), null).select("id,org, bizapp, case when ('1' = reconresult or '2' = reconresult) then reconresult else '4' end as reconresult, createtime, booktype, period").orderBy(new String[]{"org", "bizapp", "booktype", "period", "createtime desc"});
        HashSet<String> groupKeySet = new HashSet<String>(16);
        HashSet<String> groupValueSet = new HashSet<String>(16);
        for (Row row : taskDs.copy()) {
            String groupKey = "" + row.get("org") + row.get("bizapp") + row.get("booktype") + row.get("period");
            if (!groupKeySet.add(groupKey)) continue;
            groupValueSet.add(row.getLong("id") + "");
        }
        if (EmptyUtil.isNoEmpty(groupValueSet)) {
            taskDs = taskDs.filter("id in (" + String.join((CharSequence)",", groupValueSet) + ")");
        }
        return taskDs;
    }
}

