/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.pec.common.enums.SettleAcctTypeEnum;

public class SettleAcctCenterDataPlugin
extends AbstractTmcListDataPlugin {
    private static final String[] appArr = new String[]{"cfm", "lc", "cim", "bdim", "cdm"};

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        Map paraMap = this.transQueryParam(queryParam);
        DataSet baseDs = this.buildBaseDs(paraMap);
        DataSet settEnableDs = this.buildSettleEnableDs(paraMap);
        DataSet tmpDs = baseDs.join(settEnableDs).on("org", "org").on("bizapp", "bizapp").select(new String[]{"org", "period", "periodname", "bizapp"}, new String[]{"status"}).finish();
        DataSet logDs = this.buildSettleLogDs(paraMap);
        DataSet finalDsTmp = tmpDs.leftJoin(logDs).on("org", "org").on("bizapp", "bizapp").select(tmpDs.getRowMeta().getFieldNames(), new String[]{"logid", "faildetails", "detailslink"}).finish();
        finalDsTmp = finalDsTmp.select("org,bizapp,period,periodname,faildetails,detailslink,case when status!='99' then status else (case when logid is null then '3' else '2' end) end as status");
        finalDsTmp = finalDsTmp.select("org,bizapp,period,case when status='2' then faildetails else '' end faildetails,status,case when status='1' then periodname+'" + this.getSuccessTip() + "' when status='2' then periodname+'" + this.getFailTip() + "' else '' end as dealres, case when status='2' then '" + this.getDetailInfo() + "' else null end as detailslink");
        String statusStr = (String)paraMap.get("filter_status");
        List statusList = Arrays.stream(statusStr.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        DataSet finalDs = finalDsTmp.filter(String.format("status in ('%s')", String.join((CharSequence)"','", statusList)));
        return finalDs;
    }

    private DataSet buildBaseDs(Map<String, Object> paraMap) {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("org", (DataType)DataType.LongType));
        field.add(new Field("period", (DataType)DataType.LongType));
        field.add(new Field("periodname", (DataType)DataType.StringType));
        field.add(new Field("bizapp", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"SettleAcctCenterDataPlugin_BaseDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        List orgList = (List)paraMap.get("org");
        Long period = Optional.ofNullable((DynamicObject)paraMap.get("filter_period")).map(r -> r.getLong("id")).orElse(0L);
        String periodName = (String)paraMap.get("periodname");
        String apps = (String)paraMap.get("filter_bizapp");
        List appList = Arrays.stream(apps.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        for (Long org : orgList) {
            for (String app : appList) {
                Object[] obj = new Object[]{org, period, periodName, app};
                dsBuilder.append(obj);
            }
        }
        return dsBuilder.build();
    }

    private DataSet buildSettleEnableDs(Map<String, Object> paraMap) {
        List orgList = (List)paraMap.get("org");
        QFilter qFilter = new QFilter("org", "in", (Object)orgList);
        Long periodType = Optional.ofNullable((DynamicObject)paraMap.get("filter_periodtype")).map(r -> r.getLong("id")).orElse(0L);
        qFilter.and(new QFilter("periodtype", "=", (Object)periodType));
        Object[] settCols = TmcDataServiceHelper.load((String)"pec_settle_enable", (String)"org,cfmstartperiod,cfmcurrentperiod,lcstartperiod,lccurrentperiod,cimstartperiod,cimcurrentperiod,bdimstartperiod,bdimcurrentperiod,cdmstartperiod,cdmcurrentperiod", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])settCols)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u4e0e\u671f\u95f4\u7c7b\u578b\u5728\u7ed3\u8d26\u542f\u7528\u8bbe\u7f6e\u4e2d\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5", (String)"SettleAcctCenterDataPlugin_1", (String)"tmc-pec-report", (Object[])new Object[0]));
        }
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("org", (DataType)DataType.LongType));
        field.add(new Field("bizapp", (DataType)DataType.StringType));
        field.add(new Field("status", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"SettleAcctCenterDataPlugin_SettleEnable");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        DynamicObject periodRpt = (DynamicObject)paraMap.get("filter_period");
        for (Object dyn : settCols) {
            long orgId = dyn.getDynamicObject("org").getLong("id");
            for (String app : appArr) {
                this.fillDsData(dsBuilder, orgId, app, (DynamicObject)dyn, periodRpt);
            }
        }
        return dsBuilder.build();
    }

    private void fillDsData(DataSetBuilder dsBuilder, long orgId, String app, DynamicObject dyn, DynamicObject periodRpt) {
        int currentCompare;
        int startCompare;
        String status = "";
        DynamicObject cfmStartPeriod = dyn.getDynamicObject(app + "startperiod");
        status = EmptyUtil.isEmpty((DynamicObject)cfmStartPeriod) ? "4" : ((startCompare = this.compareTwoPeriod(periodRpt, cfmStartPeriod)) < 0 ? "1" : ((currentCompare = this.compareTwoPeriod(periodRpt, dyn.getDynamicObject(app + "currentperiod"))) >= 0 ? "99" : "1"));
        Object[] obj = new Object[]{orgId, app, status};
        dsBuilder.append(obj);
    }

    private int compareTwoPeriod(DynamicObject prePeriod, DynamicObject afterPeriod) {
        if (EmptyUtil.isEmpty((DynamicObject)afterPeriod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u8d26\u542f\u7528\u8be6\u60c5\u4e2d\u5b58\u5728\u542f\u7528\u671f\u95f4\u4e0d\u4e3a\u7a7a\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\u7684\u5e94\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SettleAcctCenterDataPlugin_5", (String)"tmc-pec-report", (Object[])new Object[0]));
        }
        return prePeriod.getDate("begindate").compareTo(afterPeriod.getDate("begindate"));
    }

    private DataSet buildSettleLogDs(Map<String, Object> paraMap) {
        List orgList = (List)paraMap.get("org");
        QFilter qFilter = new QFilter("org", "in", (Object)orgList);
        Long period = Optional.ofNullable((DynamicObject)paraMap.get("filter_period")).map(r -> r.getLong("id")).orElse(0L);
        qFilter.and(new QFilter("curperiod", "=", (Object)period));
        DynamicObjectCollection logCols = QueryServiceHelper.query((String)"pec_financialcloselog", (String)"id,org,bizappid,curperiod", (QFilter[])new QFilter[]{qFilter}, (String)"org,bizappid,curperiod,createdate desc", (int)-1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)logCols)) {
            return this.createEmptyDS();
        }
        HashSet<String> groupSet = new HashSet<String>();
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject log : logCols) {
            String group = "" + log.getLong("org") + log.getString("bizappid") + log.getString("curperiod");
            if (!groupSet.add(group)) continue;
            idSet.add(log.getLong("id"));
        }
        QFilter distinctFilter = new QFilter("id", "in", idSet);
        distinctFilter.and("logtype", "=", (Object)SettleAcctTypeEnum.CLOSEPERIOD.getValue());
        DataSet logDs = QueryServiceHelper.queryDataSet((String)"buildSettleLogDs", (String)"pec_financialcloselog", (String)"id logid,org,bizappid.number bizapp,curperiod,faildetails,detailslink", (QFilter[])new QFilter[]{distinctFilter}, (String)"", (int)-1);
        return logDs;
    }

    private DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"org", "bizapp", "logid", "faildetails", "detailslink"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    private String getSuccessTip() {
        return ResManager.loadKDString((String)"\u7ed3\u8d26\u6210\u529f", (String)"SettleAcctCenterDataPlugin_2", (String)"tmc-pec-report", (Object[])new Object[0]);
    }

    private String getFailTip() {
        return ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25", (String)"SettleAcctCenterDataPlugin_3", (String)"tmc-pec-report", (Object[])new Object[0]);
    }

    private String getDetailInfo() {
        return ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"SettleAcctCenterDataPlugin_4", (String)"tmc-pec-report", (Object[])new Object[0]);
    }
}

