/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.model.ReconciliationParamModel;

public class ReconciliationCenterFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String MODEL = "model";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bankrollOrg = (BasedataEdit)this.getControl("filter_org");
        bankrollOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recPeriodEdit = (BasedataEdit)this.getControl("filter_recperiod");
        recPeriodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        switch (propName) {
            case "filter_recperiod": {
                this.setPeriodFilter(event, qFilters);
                break;
            }
            case "filter_org": {
                List comList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                formShowParameter.setCustomParam("range", (Object)comList);
                qFilters.add(new QFilter("fisaccounting", "=", (Object)Boolean.TRUE));
                break;
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        boolean isDisplayTime = (Boolean)this.getModel().getValue("filter_displaytime");
        String bizAppStr = (String)this.getModel().getValue("filter_recbizapp");
        Set bizAppSet = Arrays.stream(bizAppStr.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toSet());
        List columns = event.getColumns();
        for (int i = columns.size() - 1; i >= 0; --i) {
            if (!(columns.get(i) instanceof ReportColumnGroup)) continue;
            ReportColumnGroup columnGroup = (ReportColumnGroup)columns.get(i);
            if (!isDisplayTime) {
                List children = columnGroup.getChildren();
                children.remove(1);
            }
            String fieldKey = columnGroup.getFieldKey();
            if (bizAppSet.contains(fieldKey = fieldKey.replace("groupap", ""))) continue;
            columns.remove(i);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isNeed = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_accbooktype", "filter_recperiod", "filter_recbizapp", "filter_recstatus"});
        if (!isNeed) {
            return false;
        }
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        List<Object> orgIds = new ArrayList(8);
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReconciliationCenterFormPlugin_2", (String)"tmc-pec-report", (Object[])new Object[0]));
                return false;
            }
            orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        } else if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isEmpty((DynamicObject)orgView)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReconciliationCenterFormPlugin_3", (String)"tmc-pec-report", (Object[])new Object[0]));
                return false;
            }
            orgIds = TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObjectCollection orgCols = QueryServiceHelper.query((String)"bos_org", (String)"id, number, name,fisaccounting", (QFilter[])qFilter.toArray());
        List notAcctOrgCols = orgCols.stream().filter(r -> !r.getBoolean("fisaccounting")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(notAcctOrgCols)) {
            List orgNames = notAcctOrgCols.stream().map(r -> r.getString("name")).collect(Collectors.toList());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u4e2d\u5b58\u5728\u975e\u6838\u7b97\u7ec4\u7ec7\u7684\u8d44\u91d1\u7ec4\u7ec7\u3010%s\u3011\uff0c\u65e0\u6cd5\u4f7f\u7528", (String)"ReconciliationCenterFormPlugin_0", (String)"tmc-pec-report", (Object[])new Object[]{String.join((CharSequence)",", orgNames)}));
            return false;
        }
        queryParam.getFilter().addFilterItem("org", orgIds);
        Long bookType = ((DynamicObject)this.getModel().getValue("filter_accbooktype")).getLong("id");
        QFilter bookFilter = new QFilter("bookstype", "=", (Object)bookType);
        bookFilter.and(new QFilter("o_entry.o_relateorg.fbasedataid", "in", orgIds));
        bookFilter.and(new QFilter("o_entry.o_app.number", "=", (Object)"cas"));
        DynamicObjectCollection acctBookCols = QueryServiceHelper.query((String)"gl_accountbook", (String)"id, accountingsys, org, o_entry.o_relateorg.fbasedataid casorg", (QFilter[])new QFilter[]{bookFilter});
        HashMap<Long, List> accOrgsMap = new HashMap<Long, List>(8);
        for (DynamicObject row : acctBookCols) {
            List mapList = accOrgsMap.computeIfAbsent(row.getLong("casorg"), k -> new ArrayList());
            mapList.add(row.getLong("org"));
        }
        for (DynamicObject org2 : orgCols) {
            List acctOrgIds = (List)accOrgsMap.get(org2.getLong("id"));
            if (EmptyUtil.isEmpty((Collection)acctOrgIds)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff1a%s \u6ca1\u6709\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5bf9\u8d26", (String)"ReconciliationCenterDataPlugin_0", (String)"tmc-pec-report", (Object[])new Object[0]), org2.getString("name")));
                return false;
            }
            if (acctOrgIds.size() <= 1) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff1a%s \u5bf9\u5e94\u591a\u4e2a\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5bf9\u8d26", (String)"ReconciliationCenterDataPlugin_1", (String)"tmc-pec-report", (Object[])new Object[0]), org2.getString("name")));
            return false;
        }
        HashMap pair = new HashMap(accOrgsMap.size());
        accOrgsMap.entrySet().stream().forEach(r -> {
            Long cfr_ignored_0 = (Long)pair.put(((List)r.getValue()).get(0), r.getKey());
        });
        queryParam.getFilter().addFilterItem("orgpair", pair);
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isNeed;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchrec".equals(operateKey) && !(isNeed = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_accbooktype", "filter_recperiod", "filter_recbizapp", "filter_recstatus"}))) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("batchrec".equals(opKey)) {
            this.showReconciliationReport();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (MODEL.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showReconciliationReport() {
        ReportList rpList = (ReportList)this.getControl("reportlistap");
        int[] selectedRows = rpList.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReconciliationCenterFormPlugin_8", (String)"tmc-pec-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection rowData = rpList.getReportModel().getRowData(selectedRows[0] - 1, selectedRows.length, true);
        ReconciliationParamModel model = new ReconciliationParamModel();
        Set orgIds = model.getOrgIds();
        Set appIds = model.getAppIds();
        model.setBookTypeId(Long.valueOf(((DynamicObject)this.getModel().getValue("filter_accbooktype")).getLong("id")));
        model.setPeriodId(Long.valueOf(((DynamicObject)this.getModel().getValue("filter_recperiod")).getLong("id")));
        for (DynamicObject row : rowData) {
            orgIds.add(row.getDynamicObject("accountingorg").getLong("id"));
        }
        String recBizAppStr = (String)this.getModel().getValue("filter_recbizapp");
        ArrayList<String> bizApps = new ArrayList<String>(6);
        if (EmptyUtil.isNoEmpty((String)recBizAppStr)) {
            String[] splits = recBizAppStr.split(",");
            for (String split : splits) {
                if (!EmptyUtil.isNoEmpty((String)split)) continue;
                bizApps.add(split);
            }
        }
        DynamicObjectCollection bizAppIdsQuery = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", bizApps)});
        for (DynamicObject bizApp : bizAppIdsQuery) {
            String id = bizApp.getString("id");
            appIds.add(id);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_reconciliation_rst_new");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabap");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put(MODEL, SerializationUtils.toJsonString((Object)model));
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODEL));
        this.getView().showForm(showParameter);
    }

    private void setPeriodFilter(BeforeF7SelectEvent event, List<QFilter> qFilters) {
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_org")) {
            event.setCancel(true);
            return;
        }
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay) && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_orgview")) {
            event.setCancel(true);
            return;
        }
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_accbooktype")) {
            event.setCancel(true);
            return;
        }
        DynamicObject accBookType = (DynamicObject)this.getModel().getValue("filter_accbooktype");
        DynamicObjectCollection queryOrg = this.getQueryOrg();
        Set<Long> accOrgIds = this.queryAccOrgByBankOrg(queryOrg, (Long)accBookType.getPkValue());
        if (accOrgIds.size() == 0) {
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection acctBooks = this.getAccBook(new QFilter("bookstype", "=", accBookType.getPkValue()).and("org", "in", accOrgIds));
        long minPeriodId = 0L;
        long periodTypeId = 0L;
        for (DynamicObject acctBook : acctBooks) {
            long startPeriodId = acctBook.getLong("startperiod.id");
            periodTypeId = acctBook.getLong("periodtype.id");
            if (startPeriodId <= 0L || minPeriodId != 0L && startPeriodId >= minPeriodId) continue;
            minPeriodId = startPeriodId;
        }
        if (minPeriodId != 0L) {
            qFilters.add(new QFilter("id", ">=", (Object)minPeriodId));
        }
        if (periodTypeId != 0L) {
            qFilters.add(new QFilter("periodtype", "=", (Object)periodTypeId));
        }
        qFilters.add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
    }

    private Set<Long> queryAccOrgByBankOrg(DynamicObjectCollection orgs, Long bookType) {
        QFilter qFilter = new QFilter("bookstype", "=", (Object)bookType);
        HashSet<Long> accOrgIds = new HashSet<Long>();
        for (DynamicObject org : orgs) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_accountbook", (String)"id, accountingsys, org, o_entry.o_relateorg.fbasedataid", (QFilter[])new QFilter[]{qFilter, new QFilter("o_entry.o_relateorg.fbasedataid", "=", (Object)org.getLong("id"))});
            if (query.size() == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff1a%s \u6ca1\u6709\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5bf9\u8d26", (String)"ReconciliationCenterDataPlugin_0", (String)"tmc-pec-report", (Object[])new Object[0]), org.getString("name")));
                continue;
            }
            if (query.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff1a%s \u5bf9\u5e94\u591a\u4e2a\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5bf9\u8d26", (String)"ReconciliationCenterDataPlugin_1", (String)"tmc-pec-report", (Object[])new Object[0]), org.getString("name")));
                continue;
            }
            accOrgIds.add(org.getLong("id"));
        }
        return accOrgIds;
    }

    public DynamicObjectCollection getQueryOrg() {
        List<Object> orgIds = new ArrayList();
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id"));
            }
        } else {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
                Long userId = RequestContext.get().getCurrUserId();
                ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
                String formId = parameter.getFormId();
                String appId = FormMetadataCache.getFormConfig((String)formId).getAppId();
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            } else {
                orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            }
        }
        QFilter qFilter = new QFilter("id", "in", orgIds);
        qFilter.and("fisaccounting", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_org", (String)"id, number, name", (QFilter[])qFilter.toArray());
        if (query.size() != orgIds.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u4e2d\u5b58\u5728\u975e\u6838\u7b97\u7ec4\u7ec7\u7684\u8d44\u91d1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u4f7f\u7528", (String)"ReconciliationCenterFormPlugin_1", (String)"tmc-pec-report", (Object[])new Object[0]));
        }
        return query;
    }

    private DynamicObjectCollection getAccBook(QFilter filter) {
        QFilter[] filters = filter == null ? null : filter.toArray();
        String acctorgSelectFields = "curperiod, startperiod.id, periodtype.id";
        return QueryServiceHelper.query((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])filters);
    }
}

