/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.helper.ClosePeriodHelper;

public class SettleAcctCenterFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit period = (BasedataEdit)this.getControl("filter_period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "filter_period": {
                DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
                if (EmptyUtil.isEmpty((DynamicObject)periodType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"SettleAcctCenterFormPlugin_1", (String)"tmc-pec-report", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("periodtype", "=", periodType.getPkValue()));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "filter_periodtype": {
                this.getModel().setValue("filter_period", null);
                break;
            }
            case "filter_org": {
                this.setPeriodType();
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isNeed;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReconciliationCenterFormPlugin_2", (String)"tmc-pec-report", (Object[])new Object[0]));
                return false;
            }
        } else if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay) && EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_orgview"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReconciliationCenterFormPlugin_3", (String)"tmc-pec-report", (Object[])new Object[0]));
            return false;
        }
        if (!(isNeed = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_queryway", "filter_periodtype", "filter_period", "filter_bizapp", "filter_status"}))) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "settleacct": 
            case "revertsettleacct": {
                ReportList reportList = (ReportList)this.getControl("reportlistap");
                int[] selectedRows = reportList.getEntryState().getSelectedRows();
                if (selectedRows.length < 1) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"SettleAcctCenterFormPlugin_2", (String)"tmc-pec-report", (Object[])new Object[0]));
                    return;
                }
                if (operateKey.equals("settleacct")) {
                    this.doSettleAccount(selectedRows, reportList, args);
                    break;
                }
                this.revertSettleAccount(selectedRows, reportList, args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "settleacct": 
            case "revertsettleacct": {
                this.autoSearch();
                break;
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.addOrgFilterItem(queryParam);
        DynamicObject period = (DynamicObject)this.getModel().getValue("filter_period");
        queryParam.getFilter().addFilterItem("periodname", (Object)period.getString("name"));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "detailslink": {
                this.showFailDetail(evt);
                break;
            }
        }
    }

    private void setPeriodType() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_org"))) {
            this.getModel().setValue("filter_periodtype", null);
            return;
        }
        DynamicObjectCollection orgDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgDynamicObjectCollection)) {
            return;
        }
        Object[] orgList = orgDynamicObjectCollection.stream().map(v -> v.getDynamicObject("fbasedataid")).map(v -> v.getLong("id")).toArray();
        QFilter qFilter = new QFilter("org", "in", (Object)orgList);
        DynamicObject sett = TmcDataServiceHelper.loadSingle((String)"pec_settle_enable", (String)"periodtype", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)sett)) {
            return;
        }
        DynamicObject periodType = sett.getDynamicObject("periodtype");
        this.getModel().setValue("filter_periodtype", (Object)periodType);
    }

    public void addOrgFilterItem(ReportQueryParam queryParam) {
        List orgIds;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            orgIds = TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id"));
        } else {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            orgIds = orgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        queryParam.getFilter().addFilterItem("org", orgIds);
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void doSettleAccount(int[] selectedRows, ReportList reportList, BeforeDoOperationEventArgs args) {
        ArrayList<String> pairList = new ArrayList<String>(selectedRows.length);
        boolean isAllNotSett = false;
        boolean isAllCurrPeriod = true;
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue("filter_period");
        for (int index : selectedRows) {
            DynamicObject row = reportList.getReportModel().getRowData(index);
            if ("1".equals(row.getString("status"))) {
                isAllNotSett = true;
                break;
            }
            DynamicObject orgDyn = row.getDynamicObject("org");
            Object orgId = orgDyn.getPkValue();
            QFilter qFilter = new QFilter("org", "=", orgId);
            String bizApp = row.getString("bizapp");
            periodDyn = row.getDynamicObject("period");
            Object periodId = periodDyn.getPkValue();
            qFilter.and(new QFilter(bizApp + "currentperiod", "=", periodId));
            if (!QueryServiceHelper.exists((String)"pec_settle_enable", (QFilter[])new QFilter[]{qFilter})) {
                isAllCurrPeriod = false;
                break;
            }
            String pair = orgId + "," + bizApp;
            pairList.add(pair);
        }
        if (isAllNotSett) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u671f\u95f4\u9700\u8981\u7ed3\u8d26\u7684\u6570\u636e", (String)"SettleAcctCenterFormPlugin_3", (String)"tmc-pec-report", (Object[])new Object[0]));
            return;
        }
        if (!isAllCurrPeriod) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u671f\u95f4\u7684\u4e0a\u4e00\u671f\u95f4\u4e3a\u5df2\u7ed3\u8d26\u7684\u6570\u636e", (String)"SettleAcctCenterFormPlugin_4", (String)"tmc-pec-report", (Object[])new Object[0]));
            return;
        }
        OperateOption option = ((FormOperate)args.getSource()).getOption();
        option.setVariableValue("orgAppPair", SerializationUtils.toJsonString(pairList));
        Long periodId = Optional.ofNullable(periodDyn).map(r -> r.getLong("id")).orElse(0L);
        option.setVariableValue("currentPeriod", periodId.toString());
    }

    private void revertSettleAccount(int[] selectedRows, ReportList reportList, BeforeDoOperationEventArgs args) {
        ArrayList<String> pairList = new ArrayList<String>(selectedRows.length);
        boolean isAllSett = true;
        boolean isAllFutureFail = true;
        boolean isAllLargerThanStart = true;
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue("filter_period");
        for (int index : selectedRows) {
            String bizApp;
            DynamicObject settEnableDyn;
            DynamicObject row = reportList.getReportModel().getRowData(index);
            if (!"1".equals(row.getString("status"))) {
                isAllSett = false;
                break;
            }
            periodDyn = row.getDynamicObject("period");
            Object currPeriodId = periodDyn.getPkValue();
            long nextPeriodId = ClosePeriodHelper.getNextPeriod((Object)currPeriodId, (boolean)false);
            Object orgId = row.getDynamicObject("org").getPkValue();
            QFilter qFilter = new QFilter("org", "=", orgId);
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)periodType)) {
                qFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
            }
            if (nextPeriodId != (settEnableDyn = TmcDataServiceHelper.loadSingle((String)"pec_settle_enable", (String)"org,periodtype,cfmcurrentperiod,cfmstartperiod,cfmstatus,lccurrentperiod,lcstartperiod,lcstatus,cimcurrentperiod,cimstartperiod,cimstatus,bdimcurrentperiod,bdimstartperiod,bdimstatus,cdmcurrentperiod,cdmstartperiod,cdmstatus", (QFilter[])new QFilter[]{qFilter})).getLong((bizApp = row.getString("bizapp")) + "currentperiod_id")) {
                isAllFutureFail = false;
                break;
            }
            if (ClosePeriodHelper.compareTwoPeriod((DynamicObject)periodDyn, (DynamicObject)settEnableDyn.getDynamicObject(bizApp + "startperiod")) < 0) {
                isAllLargerThanStart = false;
                break;
            }
            String pair = orgId + "," + bizApp;
            pairList.add(pair);
        }
        if (!isAllSett) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u671f\u95f4\u4e3a\u5df2\u7ed3\u8d26\u7684\u6570\u636e", (String)"SettleAcctCenterFormPlugin_5", (String)"tmc-pec-report", (Object[])new Object[0]));
            return;
        }
        if (!isAllFutureFail) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u7ed3\u8d26\u6700\u65b0\u7684\u4e00\u6761\u6570\u636e", (String)"SettleAcctCenterFormPlugin_6", (String)"tmc-pec-report", (Object[])new Object[0]));
            return;
        }
        if (!isAllLargerThanStart) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u67e5\u8be2\u671f\u95f4\u5927\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u671f\u95f4\u7684\u6570\u636e", (String)"SettleAcctCenterFormPlugin_7", (String)"tmc-pec-report", (Object[])new Object[0]));
            return;
        }
        OperateOption option = ((FormOperate)args.getSource()).getOption();
        option.setVariableValue("orgAppPair", SerializationUtils.toJsonString(pairList));
        Long periodId = Optional.ofNullable(periodDyn).map(r -> r.getLong("id")).orElse(0L);
        option.setVariableValue("currentPeriod", periodId.toString());
    }

    private void showFailDetail(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        DynamicObject rowData = reportList.getReportModel().getRowData(rowIndex);
        long orgId = rowData.getDynamicObject("org").getLong("id");
        long period = rowData.getDynamicObject("period").getLong("id");
        String partKey = ClosePeriodHelper.genCacheKey((long)orgId, (String)rowData.getString("bizapp"), (Object)period);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("fcm_checklog");
        showParameter.setFormId("bos_list");
        List detaiIds = QueryServiceHelper.queryPrimaryKeys((String)"fcm_checklog", (QFilter[])new QFilter[]{new QFilter("operationid", "=", (Object)partKey)}, (String)"createtime desc", (int)1);
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)detaiIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

