/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.common.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.enums.SettleStatusEnum;

public class IndexHelper {
    private static final String[] APPIDS = new String[]{"pec_cfm", "pec_bdim", "pec_cim", "pec_lc", "pec_cdm"};

    public static DataSet getFinancialcloseState(String appId) {
        RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet ndataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        DynamicObject period = IndexHelper.getCurrentPeriod();
        if (null == period) {
            return ndataSet;
        }
        Date begindate = period.getDate("begindate");
        String begindateStr = DateUtils.formatString((Date)begindate, (String)"yyyy-MM-dd");
        String field = "org, cfmcurrentperiod.enddate cfmstamp,lccurrentperiod.enddate lcstamp,cimcurrentperiod.enddate cimstamp,bdimcurrentperiod.enddate bdimstamp,cdmcurrentperiod.enddate cdmstamp";
        List<Long> orgList = IndexHelper.getOrgList(appId);
        if (orgList == null) {
            return ndataSet;
        }
        QFilter orgFilter = new QFilter("org", "in", (Object)orgList.toArray());
        DataSet orgDbCollect = QueryServiceHelper.queryDataSet((String)"IndexHelper", (String)"pec_settle_enable", (String)field, (QFilter[])new QFilter[]{orgFilter}, null);
        if (orgDbCollect.isEmpty()) {
            return orgDbCollect;
        }
        orgDbCollect = orgDbCollect.addFields(new String[]{SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue()}, new String[]{"cfmstatue", "lcstatue", "cimstatue", "bdimstatue", "cdmstatue"});
        String updateTemp = "case when %1$s is null then 2 when  %2$s<to_date('" + begindateStr + "', 'yy-MM-dd') then 0 else 1 end";
        orgDbCollect = orgDbCollect.updateField("cfmstatue", String.format(updateTemp, "cfmstamp", "cfmstamp")).updateField("lcstatue", String.format(updateTemp, "lcstamp", "lcstamp")).updateField("cimstatue", String.format(updateTemp, "cimstamp", "cimstamp")).updateField("bdimstatue", String.format(updateTemp, "bdimstamp", "bdimstamp")).updateField("cdmstatue", String.format(updateTemp, "cdmstamp", "cdmstamp")).select(new String[]{"org", "cfmstatue", "lcstatue", "cimstatue", "bdimstatue", "cdmstatue"});
        HashSet<Long> orgIds = new HashSet<Long>(orgDbCollect.copy().count("org", false));
        for (Row row : orgDbCollect.copy()) {
            orgIds.add(row.getLong("org"));
        }
        DataSet logDs = IndexHelper.buildSettleLogDs(orgIds, period);
        if (logDs.isEmpty()) {
            return orgDbCollect;
        }
        DataSet nlogDs = IndexHelper.ChangeRowToColDataSet(logDs);
        orgDbCollect = orgDbCollect.join(nlogDs, JoinType.LEFT).on("org", "logorg").select(orgDbCollect.getRowMeta().getFieldNames(), nlogDs.getRowMeta().getFieldNames()).finish();
        String updateLog = "case when %1$s != 3 then %2$s else %3$s end";
        orgDbCollect = orgDbCollect.updateField("cfmstatue", String.format(updateLog, "cfmrecstatus", "cfmstatue", "cfmrecstatus")).updateField("lcstatue", String.format(updateLog, "lcrecstatus", "lcstatue", "lcrecstatus")).updateField("cimstatue", String.format(updateLog, "cimrecstatus", "cimstatue", "cimrecstatus")).updateField("bdimstatue", String.format(updateLog, "bdimrecstatus", "bdimstatue", "bdimrecstatus")).updateField("cdmstatue", String.format(updateLog, "cdmrecstatus", "cdmstatue", "cdmrecstatus")).select(new String[]{"org", "cfmstatue", "lcstatue", "cimstatue", "bdimstatue", "cdmstatue"});
        return orgDbCollect;
    }

    public static List<Long> getOrgList(String appId) {
        List orgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"pec", (String)"pec_settle_enable", (String)"47150e89000000ac");
        if (orgList == null || orgList.size() < 1) {
            return null;
        }
        return orgList;
    }

    public static DynamicObject getCurrentPeriod() {
        DynamicObject orgDbCollect = QueryServiceHelper.queryOne((String)"pec_settle_enable", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        if (EmptyUtil.isNoEmpty((DynamicObject)orgDbCollect)) {
            QFilter qFilter = new QFilter("periodtype", "=", (Object)orgDbCollect.getLong("periodtype"));
            qFilter.and(new QFilter("begindate", ">=", (Object)DateUtils.getCurrentDate()).and("enddate", ">=", (Object)DateUtils.getCurrentDate()));
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodnumber,periodyear,begindate,enddate", (QFilter[])new QFilter[]{qFilter});
            return period;
        }
        return null;
    }

    private static DataSet buildSettleLogDs(Set orgs, DynamicObject period) {
        QFilter qFilter = new QFilter("org", "in", (Object)orgs);
        qFilter.and(new QFilter("curperiod", "=", period.get("id")));
        DynamicObjectCollection logCols = QueryServiceHelper.query((String)"pec_financialcloselog", (String)"id,org,bizappid,curperiod", (QFilter[])new QFilter[]{qFilter}, (String)"org,bizappid,curperiod,createdate desc", (int)-1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)logCols)) {
            RowMeta rowMeta = new RowMeta(new String[]{"org", "bizapp", "logid", "faildetails", "detailslink"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType});
            DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
            return emptyDataSet;
        }
        HashSet<String> groupSet = new HashSet<String>();
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject log : logCols) {
            String group = "" + log.getLong("org") + log.getString("bizappid") + log.getString("curperiod");
            if (!groupSet.add(group)) continue;
            idSet.add(log.getLong("id"));
        }
        DataSet logDs = QueryServiceHelper.queryDataSet((String)"buildSettleLogDs", (String)"pec_financialcloselog", (String)"org logorg,bizappid.number bizapp,closestate", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, (String)"", (int)-1);
        return logDs;
    }

    public static DataSet ChangeRowToColDataSet(DataSet ds) {
        DataSet logs = ds.executeSql("select logorg,min(case when bizapp = 'cfm' then cast(closestate as Integer) else 3 end) as cfmrecstatus,min(case when bizapp = 'cim' then cast(closestate as Integer) else 3 end) as cimrecstatus,min(case when bizapp = 'cdm' then cast(closestate as Integer) else 3 end) as cdmrecstatus,min(case when bizapp = 'bdim' then cast(closestate as Integer) else 3 end) as bdimrecstatus,min(case when bizapp = 'lc' then cast(closestate as Integer) else 3 end) as lcrecstatus group by logorg");
        return logs.updateField("cfmrecstatus", "case when cfmrecstatus = 2 then 3 else 2 end").updateField("cimrecstatus", "case when cimrecstatus = 2 then 3 else 2 end").updateField("cdmrecstatus", "case when cdmrecstatus = 2 then 3 else 2 end").updateField("bdimrecstatus", "case when bdimrecstatus = 2 then 3 else 2 end").updateField("lcrecstatus", "case when lcrecstatus = 2 then 3 else 2 end");
    }
}

