/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.helper;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ClosePeriodHelper {
    public static final String LOAD_SET = "org,periodtype,cfmcurrentperiod,cfmstartperiod,cfmstatus,lccurrentperiod,lcstartperiod,lcstatus,cimcurrentperiod,cimstartperiod,cimstatus,bdimcurrentperiod,bdimstartperiod,bdimstatus,cdmcurrentperiod,cdmstartperiod,cdmstatus";

    public static DynamicObject judgePeriod(Date bizDate) {
        DynamicObject orgDbCollect = QueryServiceHelper.queryOne((String)"pec_settle_enable", (String)"periodtype.id", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        Long ptId = orgDbCollect.getLong("periodtype.id");
        QFilter qfBeginDate = new QFilter("beginDate", "<=", (Object)bizDate);
        QFilter qfEndDate = new QFilter("enddate", ">=", (Object)bizDate);
        QFilter qfType = new QFilter("periodtype", "=", (Object)ptId);
        DynamicObject periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])new QFilter[]{qfBeginDate, qfEndDate, qfType});
        return periodObj;
    }

    public static DynamicObject[] getCurrentPeriod(List<Long> orgid, Long periodTypeId) {
        DynamicObject orgDbCollect = QueryServiceHelper.queryOne((String)"pec_settle_enable", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        if (EmptyUtil.isEmpty((DynamicObject)orgDbCollect)) {
            return null;
        }
        Long ptId = orgDbCollect.getLong("periodtype");
        if (periodTypeId.compareTo(ptId) > 0) {
            return null;
        }
        QFilter qforg = new QFilter("org", "in", orgid);
        QFilter qfperiodtype = new QFilter("periodtype", "=", (Object)ptId);
        return BusinessDataServiceHelper.load((String)"pec_settle_enable", (String)LOAD_SET, (QFilter[])new QFilter[]{qforg, qfperiodtype});
    }

    public static long getNextPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = QueryServiceHelper.queryOne((String)entityName, (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", curPeriodId)});
            Long periodtypeid = currPeriod.getLong("periodtype");
            QFilter filterDate = new QFilter("id", ">", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", (Object)periodtypeid);
            DynamicObjectCollection coll = null;
            if (isAdjustPeriod) {
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)1);
            } else {
                QFilter filterAdjustPeriod = new QFilter("isadjustperiod", "=", (Object)isAdjustPeriod);
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)1);
            }
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return Optional.ofNullable(nextPeriod).map(r -> r.getLong("id")).orElse(0L);
    }

    public static String genCacheKey(long orgId, String appNumber, Object periodId) {
        return "CLOSE_PERIOD._" + orgId + "_" + appNumber + "_" + periodId;
    }

    public static int compareTwoPeriod(DynamicObject firstPeriod, DynamicObject secondPeriod) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{firstPeriod, secondPeriod})) {
            return 0;
        }
        return firstPeriod.getDate("begindate").compareTo(secondPeriod.getDate("begindate"));
    }
}

