/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.formplugin.enable;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.helper.SettleEnableHelper;

public class SettleEnableBatchEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String START_PERIOD = "startperiod";
    private static final String CURRENT_PERIOD = "currentperiod";
    private static final String LOAD_SET = "id, org, periodtype, cfmcurrentperiod, cfmstartperiod, cfmstatus,lccurrentperiod, lcstartperiod, lcstatus,cimcurrentperiod, cimstartperiod, cimstatus,bdimcurrentperiod, bdimstartperiod, bdimstatus,cdmcurrentperiod, cdmstartperiod, cdmstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener("org", "cfmstartperiod", "cdmstartperiod", "cimstartperiod", "bdimstartperiod", "lcstartperiod");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isEnable = "0";
        List authedOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"pec_settle_enable", (String)"47150e89000000ac");
        Object[] orgDbCollect = TmcDataServiceHelper.load((String)"pec_settle_enable", (String)LOAD_SET, (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authedOrgIds)});
        this.getModel().deleteEntryData("entryentity");
        if (EmptyUtil.isNoEmpty((Object[])orgDbCollect)) {
            this.getModel().setValue("periodtype", (Object)orgDbCollect[0].getDynamicObject("periodtype"));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (Object orgDb : orgDbCollect) {
                DynamicObject entry = entryEntity.addNew();
                entry.set("org", (Object)orgDb.getDynamicObject("org"));
                entry.set("cfmcurrentperiod", (Object)orgDb.getDynamicObject("cfmcurrentperiod"));
                entry.set("cfmstartperiod", (Object)orgDb.getDynamicObject("cfmstartperiod"));
                entry.set("cfmstatus", (Object)orgDb.getString("cfmstatus"));
                entry.set("lccurrentperiod", (Object)orgDb.getDynamicObject("lccurrentperiod"));
                entry.set("lcstartperiod", (Object)orgDb.getDynamicObject("lcstartperiod"));
                entry.set("lcstatus", (Object)orgDb.getString("lcstatus"));
                entry.set("cimcurrentperiod", (Object)orgDb.getDynamicObject("cimcurrentperiod"));
                entry.set("cimstartperiod", (Object)orgDb.getDynamicObject("cimstartperiod"));
                entry.set("cimstatus", (Object)orgDb.getString("cimstatus"));
                entry.set("bdimcurrentperiod", (Object)orgDb.getDynamicObject("bdimcurrentperiod"));
                entry.set("bdimstartperiod", (Object)orgDb.getDynamicObject("bdimstartperiod"));
                entry.set("bdimstatus", (Object)orgDb.getString("bdimstatus"));
                entry.set("cdmcurrentperiod", (Object)orgDb.getDynamicObject("cdmcurrentperiod"));
                entry.set("cdmstartperiod", (Object)orgDb.getDynamicObject("cdmstartperiod"));
                entry.set("cdmstatus", (Object)orgDb.getString("cdmstatus"));
                if (!SettleEnableHelper.isEnable((DynamicObject)entry)) continue;
                isEnable = "1";
            }
        }
        this.getPageCache().put("isEnable", isEnable);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String isEnable = this.getPageCache().get("isEnable");
        this.getView().setEnable(Boolean.valueOf("0".equals(isEnable)), new String[]{"periodtype"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        if ("deleteentry".equals(opKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (SettleEnableHelper.isEnable((DynamicObject)entry)) {
                String orgName = entry.getDynamicObject("org").getString("name");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u5df2\u542f\u7528\u7684\u5e94\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"SettleEnableBatchEdit_0", (String)"tmc-pec-formplugin", (Object[])new Object[0]), orgName));
                args.setCancel(true);
            }
        } else if ("save".equals(opKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = entryEntity.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (!EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("org")) && !SettleEnableHelper.isEntryEmpty((DynamicObject)entry)) continue;
                this.getModel().deleteEntryRow("entryentity", i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        String opKey = args.getOperateKey();
        if ("save".equals(opKey)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.contains(START_PERIOD)) {
            key = key.replace(START_PERIOD, "");
            this.changePeriod(key);
        }
    }

    private void changePeriod(String bizApp) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject startPeriod = (DynamicObject)this.getModel().getValue(bizApp + START_PERIOD, i);
            if (!EmptyUtil.isNoEmpty((DynamicObject)startPeriod)) continue;
            this.getModel().setValue(bizApp + CURRENT_PERIOD, (Object)startPeriod, i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        if ("org".equals(propName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<Long> ids = new ArrayList<Long>(entryEntity.size());
            for (DynamicObject entity : entryEntity) {
                DynamicObject org = entity.getDynamicObject("org");
                if (!EmptyUtil.isNoEmpty((DynamicObject)org)) continue;
                ids.add((Long)org.getPkValue());
            }
            qFilters.add(new QFilter("id", "not in", ids));
            List authedOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"pec_settle_enable", (String)"47150e89000000ac");
            qFilters.add(new QFilter("id", "in", (Object)authedOrgIds));
        } else if (propName.contains(START_PERIOD)) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"periodtype")) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("periodtype");
            qFilters.add(new QFilter("periodtype", "=", periodType.getPkValue()));
        }
    }

    private void addF7Listener(String ... fieldArr) {
        for (String fieldName : fieldArr) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(fieldName);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

