/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.formplugin.index;

import java.util.Calendar;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LeaseChouttimePlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_set"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getLeaseDaies();
    }

    private void getLeaseDaies() {
        long orgRootId = RequestContext.get().getOrgId();
        int day = Calendar.getInstance().get(5);
        DynamicObject bill = this.getLeaseChouttime(orgRootId);
        int setDay = 28;
        if (bill != null) {
            setDay = bill.getInt("selltetime");
        }
        Label periodnumber = (Label)this.getView().getControl("remaintime");
        periodnumber.setText(String.valueOf(setDay - day > 0 ? setDay - day : 0));
        Label tips = (Label)this.getView().getControl("tips");
        tips.setText(String.format(ResManager.loadKDString((String)"%s\u65e5", (String)"LeaseChouttimePlugin_0", (String)"tmc-pec-formplugin", (Object[])new Object[0]), setDay));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btn_set": {
                this.openSetForm();
                break;
            }
        }
    }

    private void openSetForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pec_settle_chouttime");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchset"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("batchset".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private DynamicObject getLeaseChouttime(long orgRootId) {
        long tempOrgId = orgRootId;
        while (true) {
            QFilter qFilter;
            DynamicObject bill;
            if (EmptyUtil.isNoEmpty((DynamicObject)(bill = QueryServiceHelper.queryOne((String)"pec_selltetime", (String)"selltetime", (QFilter[])new QFilter[]{qFilter = new QFilter("org", "=", (Object)tempOrgId)})))) {
                return bill;
            }
            DynamicObject superiorOrg = TmcOrgDataHelper.getSuperiorOrgs((long)tempOrgId, (String)"01");
            if (superiorOrg == null || superiorOrg.getLong("id") == tempOrgId) break;
            tempOrgId = superiorOrg.getLong("id");
        }
        return null;
    }
}

