/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.formplugin.index;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.pec.common.enums.SettleStatusEnum;
import kd.tmc.pec.common.helper.IndexHelper;

public class ProgressAnalysisPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPecInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "settleapp": {
                this.getPecInfo();
                break;
            }
        }
    }

    private void getPecInfo() {
        String appId = this.getModel().getValue("settleapp").toString();
        DataSet financialcloseStates = IndexHelper.getFinancialcloseState((String)appId);
        List orgList = IndexHelper.getOrgList((String)appId);
        int orgcount = 0;
        int notsettlecount = 0;
        int settledcount = 0;
        int nouse = 0;
        if (orgList != null) {
            orgcount = orgList.size();
            nouse = orgList.size() - financialcloseStates.copy().count("org", false);
        }
        String field = appId + "statue";
        if (!financialcloseStates.isEmpty()) {
            Iterator iterator = financialcloseStates.iterator();
            while (iterator.hasNext()) {
                String closestate = ((Row)iterator.next()).getString(field);
                if (SettleStatusEnum.isNotEnabled((String)closestate)) {
                    ++nouse;
                    continue;
                }
                if (SettleStatusEnum.isSettlecount((String)closestate)) {
                    ++settledcount;
                    continue;
                }
                if (!SettleStatusEnum.isNotsettlecount((String)closestate)) continue;
                ++notsettlecount;
            }
        }
        Label notsettlecountLabel = (Label)this.getView().getControl("notsettlecount");
        notsettlecountLabel.setText(String.format(ResManager.loadKDString((String)"%s\u5bb6", (String)"ProgressAnalysisPlugin_0", (String)"tmc-pec-formplugin", (Object[])new Object[0]), notsettlecount));
        Label settledcountLabel = (Label)this.getView().getControl("settledcount");
        settledcountLabel.setText(String.format(ResManager.loadKDString((String)"%s\u5bb6", (String)"ProgressAnalysisPlugin_0", (String)"tmc-pec-formplugin", (Object[])new Object[0]), settledcount));
        this.drawProgressBar(orgcount, settledcount);
    }

    private void drawProgressBar(int total, int settledcount) {
        ProgressBar bar = (ProgressBar)this.getControl("companyautomationratepro");
        if (total == 0) {
            bar.setPercent(0);
        } else {
            bar.setPercent(settledcount / total);
        }
    }
}

