/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.formplugin.index;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.enums.SettleStatusEnum;
import kd.tmc.pec.common.helper.IndexHelper;

public class UnsettledAccountsPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillData();
    }

    private void fillData() {
        DataSet financialcloseStates = IndexHelper.getFinancialcloseState(null);
        List orgList = IndexHelper.getOrgList((String)"pec");
        QFilter qFilter = new QFilter("id", "in", (Object)orgList);
        DataSet orgCols = QueryServiceHelper.queryDataSet((String)"pec", (String)"bos_org", (String)"id, number", (QFilter[])qFilter.toArray(), null);
        orgCols = orgCols.addFields(new String[]{SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue(), SettleStatusEnum.NOT_ENABLED.getValue()}, new String[]{"pec_cfm", "pec_bdim", "pec_cim", "pec_lc", "pec_cdm", "pec_ifm"});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        if (!orgCols.isEmpty()) {
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int notsettlecount = this.buildData(orgCols, financialcloseStates, vs);
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            Label totalLabel = (Label)this.getView().getControl("notsettlecount");
            totalLabel.setText(ResManager.loadKDString((String)"%s\u5bb6", (String)"UnsettledAccountsPlugin_1", (String)"tmc-pec-formplugin", (Object[])new Object[]{notsettlecount}));
        }
    }

    private int buildData(DataSet orgCols, DataSet financialcloseStates, TableValueSetter vs) {
        vs.addField("org", new Object[0]);
        vs.addField("cfm", new Object[0]);
        vs.addField("bdim", new Object[0]);
        vs.addField("cim", new Object[0]);
        vs.addField("creditm", new Object[0]);
        vs.addField("cdm", new Object[0]);
        if (!financialcloseStates.isEmpty()) {
            orgCols = orgCols.leftJoin(financialcloseStates).on("id", "org").select(orgCols.getRowMeta().getFieldNames(), financialcloseStates.getRowMeta().getFieldNames()).finish();
        }
        List fields = Arrays.stream(orgCols.getRowMeta().getFieldNames()).collect(Collectors.toList());
        int notsettlecount = 0;
        for (Row row : orgCols) {
            String ifmStatue;
            String cfmStatue = fields.contains("cfmstatue") && EmptyUtil.isNoEmpty((String)row.getString("cfmstatue")) ? row.getString("cfmstatue") : row.getString("pec_cfm");
            String bdimStatue = fields.contains("bdimstatue") && EmptyUtil.isNoEmpty((String)row.getString("bdimstatue")) ? row.getString("bdimstatue") : row.getString("pec_bdim");
            String cimStatue = fields.contains("cimstatue") && EmptyUtil.isNoEmpty((String)row.getString("cimstatue")) ? row.getString("cimstatue") : row.getString("pec_cim");
            String lcStatue = fields.contains("lcstatue") && EmptyUtil.isNoEmpty((String)row.getString("lcstatue")) ? row.getString("lcstatue") : row.getString("pec_lc");
            String cdmStatue = fields.contains("cdmstatue") && EmptyUtil.isNoEmpty((String)row.getString("cdmstatue")) ? row.getString("cdmstatue") : row.getString("pec_cdm");
            String string = ifmStatue = fields.contains("ifmstatue") && EmptyUtil.isNoEmpty((String)row.getString("ifmstatue")) ? row.getString("ifmstatue") : row.getString("pec_ifm");
            if (this.isNotsettlecount(cfmStatue) || this.isNotsettlecount(bdimStatue) || this.isNotsettlecount(cimStatue) || this.isNotsettlecount(lcStatue) || this.isNotsettlecount(cdmStatue)) {
                ++notsettlecount;
            }
            vs.addRow(new Object[]{row.get("id"), cfmStatue, bdimStatue, cimStatue, lcStatue, cdmStatue});
        }
        return notsettlecount;
    }

    private boolean isNotsettlecount(String statue) {
        return EmptyUtil.isNoEmpty((String)statue) && SettleStatusEnum.isNotsettlecount((String)statue);
    }
}

