/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.formplugin.settlectlrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.helper.BillOperationHelper;

public class SettleCtlRuleEdit
extends AbstractBasePlugIn {
    private static final String FILTERGRID = "filtergrid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit destLkPkField = (TextEdit)this.getControl("orgfield");
        destLkPkField.addButtonClickListener((ClickListener)this);
        TextEdit inneracctprop = (TextEdit)this.getControl("bizdatefield");
        inneracctprop.addButtonClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.initFilterGrid();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("bizbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)destEntity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), new ArrayList(), (String[])new String[]{"checkop"});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("orgfield".equals(key) || "bizdatefield".equals(key)) {
            DynamicObject bizbillEntity = (DynamicObject)this.getModel().getValue("bizbill");
            if (EmptyUtil.isEmpty((DynamicObject)bizbillEntity)) {
                TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizbill");
            } else {
                this.showSelectField(key, bizbillEntity);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "bizbill": {
                this.initFilterGrid();
                if (!EmptyUtil.isNoEmpty((Object)newValue)) break;
                BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)((DynamicObject)newValue).getString("number"), new ArrayList(), (String[])new String[]{"checkop"});
                break;
            }
            case "checkop": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    List<String> checkOp = Arrays.asList(((String)newValue).replaceFirst(",", "").split(","));
                    this.getModel().setValue("checkopname", (Object)BillOperationHelper.getOpNameBykey((IFormView)this.getView(), checkOp, (String)key));
                    break;
                }
                this.getModel().setValue("checkopname", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("checkbizrule".equals(operateKey) && opResult.isSuccess()) {
            String opKeyStr = (String)this.getModel().getValue("checkop");
            DynamicObject bizbill = (DynamicObject)this.getModel().getValue("bizbill");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{operateKey, bizbill})) {
                return;
            }
            Set opkeys = Arrays.stream(opKeyStr.replaceFirst(",", "").split(",")).collect(Collectors.toSet());
            QFilter ruleQfilter = new QFilter("opbizrule", "=", (Object)"service_settlectlrule").and("objecttype", "=", bizbill.getPkValue()).and("entryentity.operationkey", "in", opkeys);
            Object[] targetBills = TmcDataServiceHelper.load((String)"bos_opbizruleset", (String)"id", (QFilter[])ruleQfilter.toArray());
            if (EmptyUtil.isEmpty((Object[])targetBills)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u4fdd\u5b58\u6ce8\u518c", (String)"SettleCtlRuleEdit_0", (String)"tmc-pec-formplugin", (Object[])new Object[0]));
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("bos_opbizruleset");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            HashSet<Object> pks = new HashSet<Object>(targetBills.length);
            for (Object targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            String filterStr = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
            this.getModel().setValue("filter_tag", (Object)filterStr);
            Object bizBill = this.getModel().getValue("bizbill");
            if (EmptyUtil.isNoEmpty((Object)bizBill)) {
                this.getModel().setValue("name", (Object)((DynamicObject)bizBill).getString("name"));
                this.getModel().setValue("number", (Object)((DynamicObject)bizBill).getString("number"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        String returnData = (String)e.getReturnData();
        switch (actionId = e.getActionId()) {
            case "orgfield": 
            case "bizdatefield": {
                if (returnData == null) break;
                this.getModel().setValue(actionId, (Object)returnData.replace(',', '/'));
            }
        }
    }

    private void showSelectField(String key, DynamicObject bizbillEntity) {
        String billEntity = bizbillEntity.getString("number");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        if ("orgfield".equals(key)) {
            PropTreeBuildOption option = new PropTreeBuildOption(null, OrgProp.class);
            option.setCurrentEntity(billEntity);
            option.setIncludeChildEntity(true);
            option.setIncludeBDPropPK(false);
            option.setOnlyPhysicsField(true);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(treeNode, key);
        } else {
            PropTreeBuildOption option = new PropTreeBuildOption(null, DateProp.class);
            option.setCurrentEntity(billEntity);
            option.setIncludeChildEntity(true);
            option.setIncludeBDPropPK(false);
            option.setOnlyPhysicsField(true);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(treeNode, key);
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tmc_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void initFilterGrid() {
        DynamicObject bizBill = (DynamicObject)this.getModel().getValue("bizbill");
        if (bizBill != null) {
            String entityName = bizBill.getString("number");
            this.initFilterByDataSource(entityName);
        } else {
            this.initFilterByDataSource(null);
        }
    }

    private void initFilterByDataSource(String entityName) {
        FilterCondition filterCondition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
        filterGrid.setEntityNumber(entityName);
        filterGrid.SetValue(new FilterCondition());
        this.getView().updateView(FILTERGRID);
        String filter = (String)this.getModel().getValue("filter_tag");
        if (EmptyUtil.isNoEmpty((String)filter) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class)) != null) {
            FilterGrid filterControl = (FilterGrid)this.getView().getControl(FILTERGRID);
            filterControl.SetValue(filterCondition);
        }
    }
}

