/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.pec.mservice.settlectlrule;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.pec.common.enums.SettleEnableStatusEnum;
import kd.tmc.pec.helper.ClosePeriodHelper;

public class SettleCtlRuleService {
    private static Log logger = LogFactory.getLog(SettleCtlRuleService.class);

    public Map<Long, String> validatePeriodIsSettle(DynamicObject[] bizBills, String operateKey) {
        HashMap<Long, String> results = new HashMap<Long, String>(16);
        for (DynamicObject info : bizBills) {
            Date bizDateInfo;
            DynamicObject orgInfo;
            String bizdateFieldProp;
            String orgFieldProp;
            String entityName = info.getDynamicObjectType().getName();
            QFilter filter = new QFilter("bizbill.number", "=", (Object)entityName).and("checkop", "like", (Object)("%" + operateKey + "%")).and("enable", "=", (Object)Character.valueOf('1'));
            Object[] settlectlRules = BusinessDataServiceHelper.load((String)"pec_settlectlrule", (String)"id,bizbill,orgfield,bizdatefield,filter_tag", (QFilter[])filter.toArray());
            if (EmptyUtil.isEmpty((Object[])settlectlRules)) {
                logger.info("SettleCtlRuleService not find settlectlrule");
                continue;
            }
            Object settlectlRule = settlectlRules[0];
            String ctrlentity = settlectlRule.getDynamicObject("bizbill").getString("number");
            QFilter ctrlEntityFilter = this.getCtrlEntityFilter((DynamicObject)settlectlRule);
            if (ctrlEntityFilter != null && !TmcDataServiceHelper.exists((String)ctrlentity, (QFilter[])ctrlEntityFilter.toArray())) {
                logger.info("SettleCtlRuleService  settlectlrule filter not match :{}", (Object)SerializationUtils.toJsonString((Object)ctrlEntityFilter));
                continue;
            }
            String orgField = (String)settlectlRule.get("orgfield");
            String bizdateField = (String)settlectlRule.get("bizdatefield");
            try {
                orgFieldProp = orgField.split("/")[0];
                bizdateFieldProp = bizdateField.split("/")[0];
            }
            catch (Exception e) {
                logger.error("SettleCtlRuleService field format error");
                throw new KDBizException(ResManager.loadKDString((String)"[\u7ed3\u8d26\u63a7\u5236]\u7684[\u7ed3\u8d26\u7ec4\u7ec7\u5b57\u6bb5(\u6807\u8bc6/\u540d\u79f0)]\u6216\u8005[\u4e1a\u52a1\u65e5\u671f\u5b57\u6bb5(\u6807\u8bc6/\u540d\u79f0)]\u914d\u7f6e\u683c\u5f0f\u5f02\u5e38,\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"SettleCtlRuleService_2", (String)"tmc-pec-mservice", (Object[])new Object[0]));
            }
            try {
                orgInfo = info.getDynamicObject(orgFieldProp);
                bizDateInfo = info.getDate(bizdateFieldProp);
            }
            catch (Exception e) {
                logger.error("SettleCtlRuleService field not find in bizbill error");
                throw new KDBizException(ResManager.loadKDString((String)"[\u7ed3\u8d26\u63a7\u5236]\u5b57\u6bb5\u914d\u7f6e\u5728\u4e1a\u52a1\u5355\u636e\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"SettleCtlRuleService_3", (String)"tmc-pec-mservice", (Object[])new Object[0]));
            }
            DynamicObject period = ClosePeriodHelper.judgePeriod((Date)bizDateInfo);
            String bizappnum = settlectlRule.getDynamicObject("bizbill").getString("bizappid.number");
            Object[] currentPeriodSet = ClosePeriodHelper.getCurrentPeriod(Collections.singletonList(orgInfo.getLong("id")), (Long)0L);
            String appStatueStr = bizappnum.toLowerCase() + "status";
            String appStartPeriodStr = bizappnum.toLowerCase() + "startperiod";
            String appCurrentPeriodStr = bizappnum.toLowerCase() + "currentperiod";
            DynamicObject currentPeriod = null;
            if (EmptyUtil.isNoEmpty((Object[])currentPeriodSet) && !currentPeriodSet[0].getString(appStatueStr).equals(SettleEnableStatusEnum.NOT_ENABLED.getValue())) {
                currentPeriod = currentPeriodSet[0].getDynamicObject(appCurrentPeriodStr);
            }
            if (currentPeriod == null || !period.getDate("enddate").before(currentPeriod.getDate("begindate"))) continue;
            results.put(info.getLong("id"), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5c5e\u4e8e\u5df2\u7ed3\u8d26\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c[%s]", (String)"SettleCtlRuleService_01", (String)"tmc-pec-mservice", (Object[])new Object[0]), this.getOpName(operateKey, info.getDynamicObjectType().getName())));
        }
        return results;
    }

    private QFilter getCtrlEntityFilter(DynamicObject settlectlRule) {
        String filter_tag = settlectlRule.getString("filter_tag");
        if (EmptyUtil.isEmpty((String)filter_tag)) {
            return null;
        }
        FilterCondition filter = (FilterCondition)SerializationUtils.fromJsonString((String)filter_tag, FilterCondition.class);
        String ctrlentity = settlectlRule.getDynamicObject("bizbill").getString("number");
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)ctrlentity);
        FilterBuilder fb = new FilterBuilder(dataType, filter, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    private String getOpName(String operateKey, String entityName) {
        String opName = "";
        try {
            List operateList = EntityMetadataCache.getDataEntityOperate((String)entityName);
            for (Map operate : operateList) {
                if (!EmptyUtil.isNoEmpty((String)operateKey) || !operateKey.equals(operate.get("type"))) continue;
                return (String)((LinkedHashMap)operate.get("name")).get("zh_CN");
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u64cd\u4f5c\u6807\u8bc6\u5931\u8d25", (Throwable)e);
        }
        return opName;
    }
}

