/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PaySchBillChangeDateAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PaySchBillChangeDateAuditService.class);

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List pkValueList = Stream.of(dataEntities).map(i -> i.getPkValue()).collect(Collectors.toList());
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])pkValueList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_changedatebill"));
        logger.info(String.format("\u6392\u7a0b\u5355-\u6539\u671f-\u5ba1\u6838\uff0c\u6539\u671f\u8bb0\u5f55ids\uff1a{%s}", LoggerPrintHelper.printCollectionLogger(pkValueList)));
        List schBillIdList = Stream.of(dbDataArr).map(i -> i.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(i -> i.get("schbillid")).collect(Collectors.toList());
        List ids = schBillIdList.stream().map(i -> Long.valueOf(i.toString())).collect(Collectors.toList());
        DynamicObject[] schBillDataArr = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        for (DynamicObject data : dbDataArr) {
            DynamicObjectCollection entryDataColl = data.getDynamicObjectCollection("entryentity");
            List currSchBillIdList = entryDataColl.stream().map(i -> i.getLong("schbillid")).collect(Collectors.toList());
            logger.info(String.format("\u6392\u7a0b\u5355-\u6539\u671f-\u5ba1\u6838\uff0c\u5f53\u524d\u6539\u671f\u5355\u4e2d\u6392\u7a0b\u5355ids\uff1a{%s}", LoggerPrintHelper.printCollectionLogger(currSchBillIdList)));
            List<DynamicObject> currDbSchBillData = Arrays.stream(schBillDataArr).filter(i -> currSchBillIdList.contains(i.getPkValue())).collect(Collectors.toList());
            currDbSchBillData.forEach(i -> {
                DynamicObject entryData = entryDataColl.stream().filter(j -> i.getPkValue().equals(j.getLong("schbillid"))).findFirst().get();
                if (StringUtils.isNotEmpty((CharSequence)entryData.getString("schedulstatus").trim())) {
                    i.set("schedulstatus", entryData.get("schedulstatus"));
                }
                i.set("expectdate", entryData.get("newdate"));
            });
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])schBillDataArr, (OperateOption)OperateOption.create());
    }
}

