/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.errorcode.PayScheBillErrorCode;
import kd.tmc.psd.common.exception.PsdException;
import org.apache.commons.lang3.tuple.Pair;

public class PaySchBillChangeDateSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entryentity");
        selector.add("entryentity.schbillid");
        selector.add("entryentity.schedulstatus");
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List existDataPkList = Stream.of(dynamicObjects).filter(i -> !i.getPkValue().equals(0L)).map(i -> i.getPkValue()).collect(Collectors.toList());
        Map<Object, DynamicObject> existDataMap = null;
        if (existDataPkList.size() > 0) {
            DynamicObject[] dbData = TmcDataServiceHelper.load((Object[])existDataPkList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_changedatebill"));
            existDataMap = Arrays.stream(dbData).collect(Collectors.toMap(i -> i.getPkValue(), Function.identity()));
        }
        List schBillIdList = Stream.of(dynamicObjects).map(i -> i.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(i -> i.get("schbillid")).collect(Collectors.toList());
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        List pkStrList = schBillIdList.stream().map(i -> i.toString()).collect(Collectors.toList());
        Map lockResultMap = MutexServiceHelper.batchRequest(pkStrList, (String)"psd_schedulebill", (String)"changedateop");
        try {
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                PayScheBillErrorCode payScheBillErrorCode = new PayScheBillErrorCode();
                throw new PsdException(payScheBillErrorCode.CHANGE_DATE_MUTEX());
            }
            List ids = schBillIdList.stream().map(i -> Long.valueOf(i.toString())).collect(Collectors.toList());
            DynamicObject[] schBillDataArr = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
            for (DynamicObject data : dynamicObjects) {
                DynamicObjectCollection entryDataColl = data.getDynamicObjectCollection("entryentity");
                List currSchBillIdList = entryDataColl.stream().map(i -> i.getLong("schbillid")).collect(Collectors.toList());
                List currDbSchBillData = Arrays.stream(schBillDataArr).filter(i -> currSchBillIdList.contains(i.getPkValue())).collect(Collectors.toList());
                entryDataColl.forEach(i -> {
                    DynamicObject schBillData = currDbSchBillData.stream().filter(j -> j.getPkValue().equals(i.getLong("schbillid"))).findFirst().get();
                    if (i.get("schedulstatus") == null || "".equals(i.getString("schedulstatus").trim())) {
                        i.set("schedulstatus", schBillData.get("schedulstatus"));
                    }
                });
            }
            this.paySchBillHandle(dynamicObjects, schBillDataArr, existDataMap);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"psd_schedulebill", (String)"changedateop");
        }
    }

    public void paySchBillHandle(DynamicObject[] dataEntities, DynamicObject[] schBillDataArr, Map<Object, DynamicObject> existDataMap) {
        ArrayList<Pair> needReductionData = new ArrayList<Pair>(1);
        ArrayList<DynamicObject> needUpdateSchData = new ArrayList<DynamicObject>(5);
        for (DynamicObject data : dataEntities) {
            Object pkValue = data.getPkValue();
            String changeDateBillNo = data.getString("billno");
            DynamicObjectCollection existSchDataIdList = new ArrayList(1);
            DynamicObject existData = null;
            if (existDataMap != null && existDataMap.get(pkValue) != null) {
                existData = existDataMap.get(pkValue);
                existSchDataIdList = existData.getDynamicObjectCollection("entryentity");
            }
            DynamicObjectCollection entryDataColl = data.getDynamicObjectCollection("entryentity");
            List currSchBillIdList = entryDataColl.stream().map(i -> i.getLong("schbillid")).collect(Collectors.toList());
            List currDbSchBillData = Arrays.stream(schBillDataArr).filter(i -> currSchBillIdList.contains(i.getPkValue())).collect(Collectors.toList());
            for (DynamicObject schData : currDbSchBillData) {
                schData.set("schedulstatus", (Object)ScheStatusEnum.CHANGEDATE.getValue());
                String changeDataRecordNo = schData.getString("changedaterecordno");
                String changeDataRecordId = schData.getString("changedaterecordid");
                String[] changeDataRecordNoArr = changeDataRecordNo.trim().split(",");
                String[] changeDataRecordIdArr = changeDataRecordId.trim().split(",");
                ArrayList<String> changeDataRecordNoList = new ArrayList<String>(Arrays.asList(changeDataRecordNoArr));
                ArrayList<String> changeDataRecordIdList = new ArrayList<String>(Arrays.asList(changeDataRecordIdArr));
                changeDataRecordNoList.remove("");
                changeDataRecordIdList.remove("");
                if (!changeDataRecordNoList.contains(changeDateBillNo)) {
                    changeDataRecordNoList.add(changeDateBillNo);
                }
                if (!changeDataRecordIdList.contains(pkValue.toString())) {
                    changeDataRecordIdList.add(pkValue.toString());
                }
                schData.set("changedaterecordid", (Object)String.join((CharSequence)",", changeDataRecordIdList));
                schData.set("changedaterecordno", (Object)String.join((CharSequence)",", changeDataRecordNoList));
                schData.set("isexistchangedate", (Object)"1");
                List needRemove = existSchDataIdList.stream().filter(i -> schData.getPkValue().equals(i.getLong("schbillid"))).collect(Collectors.toList());
                existSchDataIdList.removeAll(needRemove);
            }
            if (existSchDataIdList.size() <= 0) continue;
            needReductionData.add(Pair.of((Object)existData, (Object)existSchDataIdList));
        }
        needUpdateSchData.addAll(Arrays.asList(schBillDataArr));
        if (needReductionData.size() > 0) {
            List schIdList = needReductionData.stream().map(i -> (List)i.getRight()).flatMap(Collection::stream).map(i -> i.getLong("schbillid")).collect(Collectors.toList());
            DynamicObject[] oldSchDataArr = TmcDataServiceHelper.load((Object[])schIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
            for (Pair needReductionDatum : needReductionData) {
                List right = (List)needReductionDatum.getRight();
                DynamicObject changeDateBill = (DynamicObject)needReductionDatum.getLeft();
                for (DynamicObject needReData : right) {
                    Long schId = needReData.getLong("schbillid");
                    DynamicObject dbData = Arrays.stream(oldSchDataArr).filter(i -> i.getPkValue().equals(schId)).findFirst().get();
                    DynamicObject entryData = changeDateBill.getDynamicObjectCollection("entryentity").stream().filter(i -> dbData.getPkValue().equals(i.getLong("schbillid"))).findFirst().get();
                    dbData.set("schedulstatus", entryData.get("schedulstatus"));
                    String changeDataRecordNo = dbData.getString("changedaterecordno");
                    String changeDataRecordId = dbData.getString("changedaterecordid");
                    ArrayList<String> changeDataRecordNoList = new ArrayList<String>(Arrays.asList(changeDataRecordNo.split(",")));
                    ArrayList<String> changeDataRecordIdList = new ArrayList<String>(Arrays.asList(changeDataRecordId.split(",")));
                    changeDataRecordNoList.remove(changeDateBill.get("billno"));
                    changeDataRecordIdList.remove(changeDateBill.getPkValue().toString());
                    dbData.set("changedaterecordid", (Object)String.join((CharSequence)",", changeDataRecordIdList));
                    dbData.set("changedaterecordno", (Object)String.join((CharSequence)",", changeDataRecordNoList));
                    if (changeDataRecordNoList.size() != 0) continue;
                    dbData.set("isexistchangedate", (Object)"0");
                }
            }
            needUpdateSchData.addAll(Arrays.asList(oldSchDataArr));
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateSchData.toArray(new DynamicObject[0]));
    }
}

