/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheDataCreator;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillAutoScheService
extends AbstractTmcBizOppService {
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(8);
    private Set<Long> errIdSet = new HashSet<Long>(8);

    public List<String> getSelector() {
        List selector = super.getSelector();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        selector.addAll(entityType.getAllFields().keySet());
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        HashSet<Long> noSchedulePayBillIds = new HashSet<Long>(16);
        DynamicObject[] newDynamicObjects = this.getDynamicObject(dynamicObjects, noSchedulePayBillIds);
        List<PayScheCalcModel> scheModels = new PayScheDataTransfer().transScheDataToCalcModelList(Arrays.asList(newDynamicObjects));
        Map<Long, List<PayScheCalcModel>> orgIdGroupedMap = scheModels.stream().collect(Collectors.groupingBy(PayScheCalcModel::getOrgId));
        HashMap<Long, DynamicObject> defaultRules = new HashMap<Long, DynamicObject>(16);
        this.addBillBatchNum(scheModels, orgIdGroupedMap, noSchedulePayBillIds, defaultRules);
        String virtualPageId = String.valueOf(DB.genGlobalLongId());
        IPayScheService payScheService = PayScheServiceFactory.getPayScheService(defaultRules);
        Map<Object, DynamicObject> scheBillMap = Stream.of(newDynamicObjects).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        Map scaleMap = TmcAmountHelper.getScaleMap(scheModels.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : orgIdGroupedMap.entrySet()) {
            DynamicObject scheBill;
            PayScheDataTransfer dataTransfer = new PayScheDataTransfer();
            Long orgId = entry.getKey();
            try {
                payScheService.autoSchedule(orgId, entry.getValue(), virtualPageId, true);
                String errMsg = ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4", (String)"PayScheBillAutoScheService_1", (String)"tmc-psd-business", (Object[])new Object[0]);
                for (PayScheCalcModel paySche : entry.getValue()) {
                    if (!paySche.isNotMatchAutoScheRule() || (scheBill = scheBillMap.get(paySche.getScheId())) == null) continue;
                    this.addErrorMessage(scheBill, errMsg);
                }
            }
            catch (Exception e) {
                for (PayScheCalcModel paySche : entry.getValue()) {
                    paySche.reCalcBalance((Integer)scaleMap.get(paySche.getCurrencyId()));
                    scheBill = scheBillMap.get(paySche.getScheId());
                    if (scheBill == null) continue;
                    this.addErrorMessage(scheBill, e.getMessage());
                }
                continue;
            }
            PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(entry.getValue());
            for (PayScheCalcModel paySche : entry.getValue()) {
                paySche.reCalcBalance((Integer)scaleMap.get(paySche.getCurrencyId()));
                scheBill = scheBillMap.get(paySche.getScheId());
                if (scheBill == null) continue;
                scheBill.set("waitpayamt", scheBill.get("applyamt"));
                dataTransfer.transCalcModelPropsToPayScheData(scheBill, paySche, dataProvider, new HashMap<String, PayScheCalcModel>(2));
            }
        }
        PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(scheModels);
        this.check(scheBillMap, scheModels, dataProvider);
        List<DynamicObject> successDataList = Arrays.stream(newDynamicObjects).filter(o -> !this.errIdSet.contains(o.getLong("id"))).collect(Collectors.toList());
        if (successDataList.size() == 0) {
            return;
        }
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])successDataList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!executeOperate.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)executeOperate));
        }
        ArrayList<DynamicObject> needUpdateScheIdList = new ArrayList<DynamicObject>(successDataList.size());
        for (DynamicObject payScheBill : successDataList) {
            DynamicObject scheBillUpdateInfo = new DynamicObject(newDynamicObjects[0].getDynamicObjectType());
            scheBillUpdateInfo.set("id", payScheBill.getPkValue());
            scheBillUpdateInfo.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            BigDecimal checkAmt = payScheBill.getBigDecimal("amount");
            BigDecimal checkDraftAmt = payScheBill.getBigDecimal("draftamt");
            PayScheHelper.scheBillTransAuditProcess(scheBillUpdateInfo, checkAmt, checkDraftAmt);
            needUpdateScheIdList.add(scheBillUpdateInfo);
        }
        SaveServiceHelper.update((DynamicObject[])needUpdateScheIdList.toArray(new DynamicObject[0]));
    }

    private void check(Map<Object, DynamicObject> scheBillMap, List<PayScheCalcModel> scheModels, PayScheBaseDataProvider dataProvider) {
        for (PayScheCalcModel payScheCalcModel : scheModels) {
            DynamicObject settleTypeDO;
            boolean isDraftBePayChannelOnline;
            boolean isDraftBePayChannelType;
            Set currencyIdSet;
            List<Long> draftBillIds;
            DynamicObject entity;
            Long scheId = payScheCalcModel.getScheId();
            if (this.errIdSet.contains(scheId) || (entity = scheBillMap.get(scheId)) == null) continue;
            String billno = payScheCalcModel.getScheNumber();
            BigDecimal scheAmt = payScheCalcModel.getScheAmt();
            BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
            if (!ScheStatusEnum.NOSCHEDULE.getValue().equals(payScheCalcModel.getScheStatus())) {
                String scheStatusMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6392\u7a0b\u72b6\u6001\u4e3a\u672a\u6392\u7a0b\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355", (String)"PayScheBillAutoScheService_10", (String)"tmc-psd-business", (Object[])new Object[0]), billno);
                this.addErrorMessage(entity, scheStatusMsg);
            }
            if (scheAmt.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject settleTypeDO2;
                String payChannel;
                Long acctBankId;
                Long settleTypeId = payScheCalcModel.getSettleTypeId();
                if (null == settleTypeId || 0L == settleTypeId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_2", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (null == (acctBankId = payScheCalcModel.getAcctBankId()) || 0L == acctBankId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_3", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isEmpty((CharSequence)(payChannel = payScheCalcModel.getPayChannel()))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_4", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if ((settleTypeDO2 = dataProvider.getBaseData("bd_settlementtype", payScheCalcModel.getSettleTypeId())) == null) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_31", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                } else {
                    String paymentchannel = settleTypeDO2.getString("paymentchannel");
                    if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains(payChannel)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_28", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                }
                Long payAcctId = payScheCalcModel.getAcctBankId();
                DynamicObject payBankAcct = dataProvider.getBaseData("bd_accountbanks", payAcctId);
                if (payBankAcct != null && EmptyUtil.isNoEmpty((DynamicObject)payBankAcct)) {
                    BigDecimal singlelimit;
                    DynamicObject strategy;
                    boolean isOpenBank;
                    Set currencyIdSet2 = payBankAcct.getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
                    if (!currencyIdSet2.contains(payScheCalcModel.getCurrencyId())) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"PayScheBillAutoScheService_18", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                    if (PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getPayChannel())) {
                        boolean isSetBankInterface = payBankAcct.getBoolean("issetbankinterface");
                        if (!isSetBankInterface) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde, \u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053", (String)"PayScheBillAutoScheService_12", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                        }
                    } else if (PayChannelEnum.ONLINEBANK.getValue().equals(payScheCalcModel.getPayChannel()) && !(isOpenBank = payBankAcct.getBoolean("isopenbank"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c, \u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053", (String)"PayScheBillAutoScheService_13", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                    Set settlementTypeIds = payBankAcct.getDynamicObjectCollection("settlementtype").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
                    if (settleTypeDO2 != null && settlementTypeIds.size() > 0 && !settlementTypeIds.contains(settleTypeDO2.getLong("id"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheBillAutoScheService_19", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)(strategy = payBankAcct.getDynamicObject("strategy"))) && EmptyUtil.isNoEmpty((BigDecimal)(singlelimit = strategy.getBigDecimal("singlelimit"))) && scheAmt.compareTo(singlelimit) > 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u6392\u6b3e\u91d1\u989d\u8d85\u51fa\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u5355\u7b14\u652f\u4ed8\u9650\u989d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheBillAutoScheService_20", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                }
            }
            if (draftBillAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            Long draftSettleTypeId = payScheCalcModel.getDraftSettleTypeId();
            String draftPayChannel = payScheCalcModel.getDraftpaychannel();
            if (null == draftSettleTypeId || 0L == draftSettleTypeId) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_5", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (StringUtils.isEmpty((CharSequence)draftPayChannel)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_6", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            String draftPayMethod = payScheCalcModel.getDraftPayMethod();
            if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod) && (EmptyUtil.isEmpty(draftBillIds = payScheCalcModel.getDraftBillIds()) || draftBillIds.size() < 1)) {
                String freezeStatus = payScheCalcModel.getFreezeStatus();
                if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u7968\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_7", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
            }
            Long draftPayAcctId = payScheCalcModel.getDraftAcctBankId();
            DynamicObject draftBankAcct = null;
            if (EmptyUtil.isNoEmpty((Long)draftPayAcctId) && !(currencyIdSet = (draftBankAcct = dataProvider.getBaseData("bd_accountbanks", draftPayAcctId)).getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())).contains(payScheCalcModel.getCurrencyId())) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u7968\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"PayScheBillAutoScheService_8", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (isDraftBePayChannelType = PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getDraftpaychannel())) {
                boolean hasBeOfDraftBankAcct = false;
                if (draftBankAcct != null) {
                    hasBeOfDraftBankAcct = draftBankAcct.getBoolean("issetbankinterface");
                }
                if (!hasBeOfDraftBankAcct && draftBillAmt.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u7968\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde, \u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053", (String)"PayScheBillAutoScheService_9", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
            }
            if (isDraftBePayChannelOnline = PayChannelEnum.ONLINEBANK.getValue().equals(payScheCalcModel.getDraftpaychannel())) {
                boolean hasOpenBank = false;
                if (draftBankAcct != null) {
                    hasOpenBank = draftBankAcct.getBoolean("isopenbank");
                }
                if (!hasOpenBank) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u6392\u7968\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c, \u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053", (String)"PayScheBillAutoScheService_11", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
            }
            if ((settleTypeDO = dataProvider.getBaseData("bd_settlementtype", draftSettleTypeId)) == null) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_30", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            } else {
                String paymentchannel = settleTypeDO.getString("paymentchannel");
                if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains(draftPayChannel)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_29", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
            }
            if (draftBankAcct == null) continue;
            Set settlementTypeIds = draftBankAcct.getDynamicObjectCollection("settlementtype").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            if (settleTypeDO == null || settlementTypeIds.size() <= 0 || settlementTypeIds.contains(settleTypeDO.getLong("id"))) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheBillAutoScheService_21", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
        }
    }

    private void addErrorMessage(DynamicObject paySche, String msg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, paySche.getPkValue(), (Object)paySche.getDynamicObjectType().getName());
        operateErrorInfo.setMessage(paySche.get("billno") + ":" + msg);
        this.errorInfoList.add(operateErrorInfo);
        this.errIdSet.add(paySche.getLong("id"));
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }

    private void addBillBatchNum(List<PayScheCalcModel> scheModels, Map<Long, List<PayScheCalcModel>> orgIdGroupedMap, Set<Long> noSchedulePayBillIds, Map<Long, DynamicObject> defaultRules) {
        String batchNum;
        Map<Long, List<PayScheCalcModel>> groupByPayBillIdMap = scheModels.stream().collect(Collectors.groupingBy(PayScheCalcModel::getPayBillId));
        String pageId = String.valueOf(DB.genGlobalLongId());
        HashMap<Long, String> sourceBatchNums = new HashMap<Long, String>(16);
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : groupByPayBillIdMap.entrySet()) {
            List<PayScheCalcModel> payScheCalcModels = entry.getValue();
            if (payScheCalcModels == null || payScheCalcModels.size() <= 1) continue;
            PayScheCalcModel payScheCalcModel = payScheCalcModels.get(0);
            Long orgId = payScheCalcModel.getOrgId();
            long payBillId = entry.getKey();
            if (noSchedulePayBillIds.contains(payBillId)) continue;
            AutoScheDataCreator autoScheDataCreator = new AutoScheDataCreator(orgId, pageId, entry.getValue(), true);
            batchNum = autoScheDataCreator.getBatchNum(payBillId);
            Map<Long, DynamicObject> ruleMap = autoScheDataCreator.getDefaultRules();
            if (ruleMap != null && ruleMap.get(payBillId) != null && EmptyUtil.isNoEmpty((DynamicObject)ruleMap.get(payBillId))) {
                defaultRules.putAll(ruleMap);
            }
            if (!StringUtils.isNotEmpty((CharSequence)batchNum) || !ScheStatusEnum.NOSCHEDULE.getValue().equals(payScheCalcModel.getScheStatus())) continue;
            sourceBatchNums.put(payBillId, batchNum);
        }
        if (sourceBatchNums.isEmpty()) {
            return;
        }
        HashSet<Long> masterPayBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : orgIdGroupedMap.entrySet()) {
            List<PayScheCalcModel> payScheCalcModels = entry.getValue();
            if (payScheCalcModels.size() == 0 || payScheCalcModels.size() == 1) continue;
            for (PayScheCalcModel payScheCalcModel : payScheCalcModels) {
                long payBillId = payScheCalcModel.getPayBillId();
                if (!sourceBatchNums.containsKey(payBillId)) continue;
                batchNum = (String)sourceBatchNums.get(payBillId);
                payScheCalcModel.setBatchnum(batchNum);
                if (!masterPayBillIds.add(payBillId)) continue;
                payScheCalcModel.setMasterData(true);
            }
        }
    }

    private DynamicObject[] getDynamicObject(DynamicObject[] dynamicObjects, Set<Long> noSchedulePayBillIds) {
        List existIds = Arrays.stream(dynamicObjects).map(v -> v.getLong("id")).collect(Collectors.toList());
        DynamicObject[] payScheduleObject = TmcDataServiceHelper.load((Object[])existIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        HashMap<Long, Set> orgPayBillIds = new HashMap<Long, Set>(payScheduleObject.length);
        for (DynamicObject dynamicObject : payScheduleObject) {
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entrys");
            if (entries == null || entries.size() == 0) continue;
            Long org = dynamicObject.getLong("company_id");
            Set payBillIds = orgPayBillIds.computeIfAbsent(org, v -> new HashSet(16));
            for (DynamicObject entry : entries) {
                Long payBillId = entry.getLong("e_payid");
                if (payBillId == null) continue;
                payBillIds.add(payBillId);
            }
        }
        HashSet<Long> removeOrgId = new HashSet<Long>(32);
        for (Long orgId : orgPayBillIds.keySet()) {
            AutoScheDataCreator autoScheDataCreator = new AutoScheDataCreator(orgId);
            boolean isCombine = autoScheDataCreator.isCombine();
            if (isCombine) continue;
            removeOrgId.add(orgId);
        }
        orgPayBillIds.keySet().removeIf(p -> removeOrgId.contains(p));
        HashSet payIds = new HashSet(32);
        for (Map.Entry entry : orgPayBillIds.entrySet()) {
            payIds.addAll((Collection)entry.getValue());
        }
        DynamicObject[] scheduleBills = null;
        if (payIds.size() > 0) {
            QFilter qPayId = new QFilter("entrys.e_payid", "in", payIds);
            DynamicObject[] payScheduleBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id, schedulstatus, entrys.e_payid", (QFilter[])new QFilter[]{qPayId});
            noSchedulePayBillIds.addAll(this.getnoSchedulePayIds(payScheduleBills));
            List<DynamicObject> noScheduleBills = this.getScheduleObjects(payScheduleBills);
            Set removeIds = noScheduleBills.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            List payScheduleBillsIds = Arrays.stream(payScheduleBills).map(v -> v.getLong("id")).collect(Collectors.toList());
            payScheduleBillsIds.removeAll(existIds);
            payScheduleBillsIds.removeAll(removeIds);
            scheduleBills = TmcDataServiceHelper.load((Object[])payScheduleBillsIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        }
        DynamicObject[] newDynamicObjects = new DynamicObject[payScheduleObject.length];
        if (scheduleBills != null && scheduleBills.length > 0) {
            newDynamicObjects = new DynamicObject[payScheduleObject.length + scheduleBills.length];
        }
        System.arraycopy(payScheduleObject, 0, newDynamicObjects, 0, payScheduleObject.length);
        if (scheduleBills != null && scheduleBills.length > 0) {
            System.arraycopy(scheduleBills, 0, newDynamicObjects, payScheduleObject.length, scheduleBills.length);
        }
        return newDynamicObjects;
    }

    private Set<Long> getnoSchedulePayIds(DynamicObject[] payScheduleBills) {
        HashSet<String> scheduleStatus = new HashSet<String>(4);
        scheduleStatus.add("yetchargeback");
        scheduleStatus.add("afreshsche");
        scheduleStatus.add("discard");
        scheduleStatus.add("noschedule");
        List noScheduleBills = Arrays.stream(payScheduleBills).filter(v -> !scheduleStatus.contains(v.getString("schedulstatus"))).collect(Collectors.toList());
        HashSet<Long> noSchedulePayBillIds = new HashSet<Long>(16);
        for (DynamicObject scheduleBill : noScheduleBills) {
            DynamicObjectCollection entries = scheduleBill.getDynamicObjectCollection("entrys");
            if (entries == null || EmptyUtil.isEmpty((DynamicObjectCollection)entries) || entries.size() == 0) continue;
            for (DynamicObject entry : entries) {
                noSchedulePayBillIds.add(entry.getLong("e_payid"));
            }
        }
        return noSchedulePayBillIds;
    }

    private List<DynamicObject> getScheduleObjects(DynamicObject[] payScheduleBills) {
        return Arrays.stream(payScheduleBills).filter(v -> !v.getString("schedulstatus").equals("noschedule")).collect(Collectors.toList());
    }
}

