/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.model.DisposeRowInfo;
import org.apache.commons.lang3.StringUtils;

public class PayScheBillCancelPayService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheBillCancelPayService.class);
    private DraftLockServiceHelper draftLockServiceHelper;
    private static final String SELECT_FIELDS = "id, arrivalno, entrys,entrys.payid,entrys.payno,entrys.operatetype";
    private Map<Long, List<Long>> oldEntryMap = new HashMap<Long, List<Long>>();
    private List<Long> payBillIds = new ArrayList<Long>();
    private Map<Long, DynamicObject> payScheMapPayBill = new HashMap<Long, DynamicObject>();

    public PayScheBillCancelPayService() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("payid");
        selector.add("entrys");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("balanceamt");
        selector.add("waitpayamt");
        selector.add("applyamt");
        selector.add("iscasexitbill");
        selector.add("ismasterdata");
        selector.add("draftno");
        selector.add("draftpaymethod");
        selector.add("settletype");
        selector.add("settletnumber");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String isCasExit = (String)this.getOperationVariable().get("iscasexit");
        ArrayList<Object> ids = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject payScheBill : dataEntities) {
            ArrayList<Long> oldEntry = new ArrayList<Long>();
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
            if (Boolean.parseBoolean(isCasExit)) {
                payScheBill.set("iscasexitbill", (Object)"1");
            }
            DynamicObjectCollection entrys = payScheBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                if (!"paybill".equals(entry.getString("e_billtype"))) continue;
                entry.set("e_billtype", (Object)"schebill");
                oldEntry.add(entry.getLong("id"));
                this.payBillIds.add(entry.getLong("e_payid"));
                this.payScheMapPayBill.put(entry.getLong("e_payid"), payScheBill);
            }
            this.oldEntryMap.put(payScheBill.getLong("id"), oldEntry);
            ids.add(payScheBill.getPkValue());
        }
        logger.info("\u901a\u8fc7\u4ed8\u6b3e\u6392\u7a0b\u5355\u64a4\u56de\u6821\u9a8c\u7684\u6392\u7a0b\u5355\u4e3a\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(ids));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        try {
            DynamicObject[] payBills = TmcDataServiceHelper.load((Object[])this.payBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
            OperateOption option = OperateOption.create();
            OperationResult opResult = null;
            try (DynamicObject[] h = TX.requiresNew((String)"txcancelpay");){
                logger.info("\u5f00\u59cb\u6267\u884c\u9000\u5355\u64cd\u4f5c schecanclepay\uff0c\u9000\u5355\u64cd\u4f5c\u7684id\uff1a{}\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(this.payBillIds), (Object)option);
                opResult = TmcOperateServiceHelper.execOperate((String)"schecanclepay", (String)"cas_paybill", (Object[])this.payBillIds.toArray(), (OperateOption)option);
            }
            if (opResult.isSuccess()) {
                for (DynamicObject payScheBill : dataEntities) {
                    BigDecimal applyAmt = payScheBill.getBigDecimal("applyamt");
                    payScheBill.set("waitpayamt", (Object)applyAmt);
                }
                SaveServiceHelper.save((DynamicObject[])dataEntities);
                Map<String, Long> batchMasterIdMap = Arrays.stream(dataEntities).filter(d -> d.getBoolean("ismasterdata") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{d.getString("batchnum")})).collect(Collectors.toMap(d -> d.getString("batchnum"), d -> d.getLong("id")));
                Long tmpMasterId = 0L;
                ArrayList<DraftLockInfo> linkInfoList = new ArrayList<DraftLockInfo>(8);
                ArrayList<DraftLockInfo> releaseDraftInfos = new ArrayList<DraftLockInfo>(10);
                ArrayList<DynamicObject> releasePayBillDys = new ArrayList<DynamicObject>(payBills.length);
                HashSet<DynamicObject> updatePayBills = new HashSet<DynamicObject>(8);
                ArrayList<Map<String, Object>> payBillsParamsToLC = new ArrayList<Map<String, Object>>(16);
                for (DynamicObject payBill : payBills) {
                    Long pkValue = payBill.getLong("id");
                    String billno = payBill.getString("billno");
                    DynamicObject paySche = this.payScheMapPayBill.get(pkValue);
                    Long payScheId = paySche.getLong("id");
                    String batchnum = paySche.getString("batchnum");
                    if (EmptyUtil.isNoEmpty((String)batchnum) && !paySche.getBoolean("ismasterdata")) continue;
                    if (kd.tmc.psd.common.helper.PayScheHelper.isLCSettlement((DynamicObject)payBill)) {
                        List<Map<String, Object>> param = this.payBillProcess(payBill);
                        payBillsParamsToLC.addAll(param);
                        payBill.set("settletnumber", null);
                        updatePayBills.add(payBill);
                    }
                    DynamicObjectCollection drafts = payBill.getDynamicObjectCollection("draftbill");
                    DynamicObjectCollection payScheDrafts = paySche.getDynamicObjectCollection("draftno");
                    String draftPayMethod = paySche.getString("draftpaymethod");
                    boolean isDraftBook = "draftbook".equals(draftPayMethod);
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)payScheDrafts)) {
                        Object needReleaseDraftInfos = payBill.getDynamicObjectCollection("cas_draftinfo");
                        boolean isOld = false;
                        if (EmptyUtil.isEmpty((Collection)needReleaseDraftInfos)) {
                            isOld = true;
                            DynamicObjectCollection draftbills = payBill.getDynamicObjectCollection("draftbill");
                            HashSet needLockDraftIds = new HashSet();
                            draftbills.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                            DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                            needReleaseDraftInfos = new ArrayList(draftArr);
                        }
                        DraftLockInfo draftLockInfo = new DraftLockInfo();
                        draftLockInfo.setBizBillNo(billno);
                        draftLockInfo.setSourceBillId(payBill.getLong("id"));
                        draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
                        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(10);
                        for (DynamicObject needReleaseDraftInfo : needReleaseDraftInfos) {
                            DraftAmountLockSubInfo draftAmountLockSubInfo = PayScheHelper.getReleaseLockInfo(payBill, isDraftBook, false, needReleaseDraftInfo, isOld);
                            draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
                            releasePayBillDys.add(payBill);
                        }
                        draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
                        releaseDraftInfos.add(draftLockInfo);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)drafts)) continue;
                    DraftLockInfo draftLockInfo = PayScheHelper.getPayToSchChangeLockInfo(pkValue, payScheId);
                    draftLockInfo.setSourceBillId(pkValue);
                    draftLockInfo.setSourceBillType("cas_paybill");
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{batchnum})) {
                        Long curMasterId = batchMasterIdMap.get(batchnum);
                        if (tmpMasterId.equals(curMasterId)) continue;
                        draftLockInfo.setTargetBillId(curMasterId);
                        tmpMasterId = curMasterId;
                    } else {
                        draftLockInfo.setTargetBillId(payScheId);
                    }
                    draftLockInfo.setTargetBillType("psd_schedulebill");
                    linkInfoList.add(draftLockInfo);
                }
                logger.info("\u5f00\u59cb\u6267\u884c\u9000\u5355\u64cd\u4f5c\uff0c\u8fdb\u884c\u7968\u636e\u91ca\u653e\uff0c\u7968\u636e\u4e3a\uff1a{}", (Object)LoggerPrintHelper.printObjectLoggerByToString(linkInfoList));
                if (!CollectionUtils.isEmpty(linkInfoList)) {
                    this.draftLockServiceHelper.changeDraftLock(linkInfoList);
                }
                if (!CollectionUtils.isEmpty(releaseDraftInfos)) {
                    this.draftLockServiceHelper.releaseOrLockDraft(releaseDraftInfos);
                    for (DynamicObject releasePayBillDy : releasePayBillDys) {
                        releasePayBillDy.getDynamicObjectCollection("draftbill").clear();
                        releasePayBillDy.getDynamicObjectCollection("cas_draftinfo").clear();
                    }
                    TmcDataServiceHelper.save((DynamicObject[])releasePayBillDys.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(payBillsParamsToLC)) {
                    DispatchServiceHelper.invokeBizService((String)"tmc", (String)"lc", (String)"letterCreditPayService", (String)"execute", (Object[])new Object[]{payBillsParamsToLC});
                }
                if (!CollectionUtils.isEmpty(updatePayBills)) {
                    TmcDataServiceHelper.save((DynamicObject[])updatePayBills.toArray(new DynamicObject[0]));
                }
            } else {
                this.rollback(dataEntities);
            }
        }
        catch (Exception e) {
            this.rollback(dataEntities);
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u5931\u8d25:%s", (String)"PayScheBillCancelPayService_0", (String)"tmc-psd-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void rollback(DynamicObject[] dataEntities) {
        for (DynamicObject paySche : dataEntities) {
            paySche.set("schedulstatus", (Object)ScheStatusEnum.PAYING.getValue());
            paySche.set("iscasexitbill", (Object)"0");
            List<Long> entryIds = this.oldEntryMap.get(paySche.getPkValue());
            DynamicObjectCollection entrys = paySche.getDynamicObjectCollection("entrys");
            for (DynamicObject entryEntity : entrys) {
                if (!entryIds.contains(entryEntity.getLong("id"))) continue;
                entryEntity.set("e_billtype", (Object)"paybill");
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        try (TXHandle h = TX.requiresNew((String)"txcancelpay");){
            OperateOption option = OperateOption.create();
            option.setVariableValue("isrollback", String.valueOf(true));
            logger.info("\u64a4\u56de\u64cd\u4f5c\u5931\u8d25\uff0c\u5f00\u59cb\u56de\u6eda\u64cd\u4f5c\uff0c\u56de\u6eda\u6570\u636e ID\uff1a{}\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(this.payBillIds), (Object)option);
            TmcOperateServiceHelper.execOperate((String)"schecanclepay", (String)"cas_paybill", (Object[])this.payBillIds.toArray(), (OperateOption)option);
        }
    }

    private List<Map<String, Object>> payBillProcess(DynamicObject paymentBill) {
        ArrayList<Map<String, Object>> disposeData = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection entry = paymentBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Map dri = new DisposeRowInfo().setKeyValue("issuccess", (Object)false).setKeyValue("sourceentity", (Object)paymentBill.getString("sourcebilltype")).setKeyValue("sourcebillid", (Object)paymentBill.getLong("sourcebillid")).setKeyValue("sourcepk", (Object)row.getLong("e_sourcebillid")).setKeyValue("sourceentrypk", (Object)row.getLong("e_sourcebillentryid")).setKeyValue("sourceentryno", (Object)row.getLong("e_corebillentryseq")).setKeyValue("currencypk", (Object)paymentBill.getLong("currency.id")).setKeyValue("amount", (Object)row.getBigDecimal("e_actamt")).setKeyValue("localamt", (Object)row.getBigDecimal("e_localamt")).setKeyValue("payableamt", (Object)row.getBigDecimal("e_payableamt")).setKeyValue("payablelocamt", (Object)row.getBigDecimal("e_payablelocamt")).setKeyValue("refundamt", (Object)row.getBigDecimal("e_refundamt")).setKeyValue("refunddes", (Object)row.getString("e_refunddes")).setKeyValue("targetentity", (Object)"cas_paybill").setKeyValue("targetpk", paymentBill.getPkValue()).setKeyValue("targetentrypk", row.getPkValue()).setKeyValue("operate", (Object)"chargeback").setKeyValue("reason", (Object)paymentBill.getString("reason")).setKeyValue("paymentidentify", EmptyUtil.isEmpty((DynamicObject)paymentBill.getDynamicObject("paymentidentify")) ? paymentBill.getDynamicObject("paymentidentify") : Long.valueOf(paymentBill.getDynamicObject("paymentidentify").getLong("id"))).setKeyValue("targetbillno", (Object)paymentBill.getString("billno")).setKeyValue("bizdate", (Object)paymentBill.getDate("bizdate")).setKeyValue("paydate", (Object)paymentBill.getDate("paydate")).setKeyValue("org", null == paymentBill.getDynamicObject("org") ? Long.valueOf(0L) : paymentBill.getDynamicObject("org").getPkValue()).setKeyValue("openorg", null == paymentBill.getDynamicObject("openorg") ? Long.valueOf(0L) : paymentBill.getDynamicObject("openorg").getPkValue()).setKeyValue("payeracctbank", null == paymentBill.getDynamicObject("payeracctbank") ? Long.valueOf(0L) : paymentBill.getDynamicObject("payeracctbank").getPkValue()).setKeyValue("payeracctbankno", null != paymentBill.getDynamicObject("payeracctbank") ? paymentBill.getDynamicObject("payeracctbank").getString("bankaccountnumber") : null).setKeyValue("payerbank", null == paymentBill.getDynamicObject("payerbank") ? Long.valueOf(0L) : paymentBill.getDynamicObject("payerbank").getPkValue()).setKeyValue("exchangerate", (Object)paymentBill.getBigDecimal("exchangerate")).setKeyValue("entrustorg", null == paymentBill.getDynamicObject("entrustorg") ? Long.valueOf(0L) : paymentBill.getDynamicObject("entrustorg").getPkValue()).setKeyValue("settletype", null == paymentBill.getDynamicObject("settletype") ? Long.valueOf(0L) : paymentBill.getDynamicObject("settletype").getPkValue()).setKeyValue("agreedrate", (Object)paymentBill.getBigDecimal("agreedrate")).setKeyValue("dpcurrency", null == paymentBill.getDynamicObject("dpcurrency") ? Long.valueOf(0L) : paymentBill.getDynamicObject("dpcurrency").getPkValue()).setKeyValue("dpexchangerate", (Object)paymentBill.getBigDecimal("dpexchangerate")).setKeyValue("isdiffcur", (Object)paymentBill.getBoolean("isdiffcur")).setKeyValue("dpamt", (Object)paymentBill.getBigDecimal("dpamt")).setKeyValue("dplocalamt", (Object)paymentBill.getBigDecimal("dplocalamt")).setKeyValue("lossamt", (Object)paymentBill.getBigDecimal("lossamt")).setKeyValue("fee", (Object)paymentBill.getBigDecimal("fee")).setKeyValue("feecurrency", null == paymentBill.getDynamicObject("feecurrency") ? Long.valueOf(0L) : paymentBill.getDynamicObject("feecurrency").getPkValue()).setKeyValue("iscommitbe", (Object)paymentBill.getBoolean("iscommitbe")).setKeyValue("bankreturnmsg", (Object)paymentBill.getString("bankreturnmsg")).setKeyValue("billno", (Object)paymentBill.getString("billno")).setKeyValue("actpayamt", (Object)paymentBill.getBigDecimal("actpayamt")).setKeyValue("settletnumber", (Object)paymentBill.getString("settletnumber")).setKeyValue("description", (Object)paymentBill.getString("description")).build();
            logger.info("\u6392\u7a0b\u64a4\u9500\u53cd\u5199\u5230\u5355\u53cd\u5199\u53c2\u6570\uff1amap\uff1a{}", (Object)SerializationUtils.toJsonString((Object)dri));
            disposeData.add(dri);
        }
        return disposeData;
    }
}

