/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheBillDiscardService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayScheBillDiscardService.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("payrespstatus");
        selector.add("draftpaymethod");
        selector.add("draftinfoentry");
        selector.add("draftno");
        selector.add(String.format("%s.%s", "draftinfoentry", "de_transferamt"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftinfo"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftlogid"));
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        ArrayList<DraftLockInfo> waitReleaseDraftInfos = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject dataEntity : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(dataEntity.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(dataEntity.getString("billno"));
            draftLockInfo.setSourceBillId(dataEntity.getLong("id"));
            dataEntity.set("schedulstatus", (Object)ScheStatusEnum.DISCARD.getValue());
            dataEntity.set("payrespstatus", null);
            String draftPayMethod = dataEntity.getString("draftpaymethod");
            boolean isDraftBook = "draftbook".equals(draftPayMethod);
            Object draftInfoEntrys = dataEntity.getDynamicObjectCollection("draftinfoentry");
            boolean isOld = false;
            if (EmptyUtil.isEmpty((Collection)draftInfoEntrys)) {
                DynamicObjectCollection draftnos = dataEntity.getDynamicObjectCollection("draftno");
                List draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftnoIds)});
                draftInfoEntrys = new ArrayList(draftArr);
                isOld = true;
            }
            ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (DynamicObject draftInfoEntry : draftInfoEntrys) {
                DraftAmountLockSubInfo needReleaseDraftAmountLockInfo = PayScheHelper.getReleaseLockInfo(dataEntity, isDraftBook, false, draftInfoEntry, isOld);
                draftAmountLockSubInfoList.add(needReleaseDraftAmountLockInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
            waitReleaseDraftInfos.add(draftLockInfo);
        }
        if (!waitReleaseDraftInfos.isEmpty()) {
            List<LockResult> lockResults = this.draftLockServiceHelper.releaseOrLockDraft(waitReleaseDraftInfos);
            logger.info("PayScheBill Discard Result => " + LoggerPrintHelper.printCollectionLogger(lockResults));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.afterProcessRollback(dataEntities);
        this.draftLockServiceHelper.rollback();
    }
}

