/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.opservice.payschebill.PayScheBillErrChangeService;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayScheEntryInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayScheFixInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayScheFixResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.PaySchePayInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.RpcStatus;
import kd.tmc.psd.common.enums.BillTypeEnum;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheBillFixPayEntryService
extends PayScheBillErrChangeService {
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("expectpaydate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("schedulstatus");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("exchangerate");
        selector.add("waitpayamt");
        selector.add("exratetable");
        selector.add("transferpost");
        selector.add("iscasexitbill");
        selector.add("payrespstatus");
        selector.add("paytime");
        selector.add("payerrmsg");
        selector.add("payerrmsg_TAG");
        selector.add("batchpayid");
        selector.add("fixcnt");
        selector.add("paymenttype");
        selector.add("isbilldibs");
        selector.add("dibsbalance");
        selector.add("draftpayacct");
        selector.add("draftinfoentry");
        selector.add("lcarrivalno");
        selector.add("businesstype");
        selector.add("institutioncode");
        selector.add("institutionname");
        selector.add(String.format("%s.%s", "draftinfoentry", "de_transferamt"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftinfo"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftlogid"));
        return selector;
    }

    @Override
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject data : dynamicObjects) {
            data.set("fixcnt", (Object)(data.getInt("fixcnt") + 1));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        Set scheIdSetContainsBatch = Arrays.stream(dataEntities).filter(o -> StringUtils.isEmpty((String)o.getString("batchnum"))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        Set batchNumSet = Arrays.stream(dataEntities).map(o -> o.getString("batchnum")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        if (batchNumSet.size() > 0) {
            DynamicObjectCollection batchIdSet = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNumSet)});
            scheIdSetContainsBatch.addAll(batchIdSet.stream().map(o -> o.getLong("id")).collect(Collectors.toSet()));
        }
        DynamicObject[] allDataFromDB = TmcDataServiceHelper.load((Object[])scheIdSetContainsBatch.toArray(), (DynamicObjectType)dataEntities[0].getDynamicObjectType());
        ArrayList<PayScheFixInfo> fixInfoList = new ArrayList<PayScheFixInfo>(10);
        Map payScheInfoMap = Arrays.stream(allDataFromDB).map(PayScheHelper::beanFromDynamicObject).collect(Collectors.toMap(PaySchePayInfo::getScheId, Function.identity(), (a, b) -> a));
        for (DynamicObject data : allDataFromDB) {
            PayScheFixInfo info = new PayScheFixInfo();
            info.setPayScheId(data.getLong("id"));
            info.setPayInfo((PaySchePayInfo)payScheInfoMap.get(info.getPayScheId()));
            DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
            ArrayList<PayScheEntryInfo> entryInfoList = new ArrayList<PayScheEntryInfo>(entryList.size());
            info.setEntryInfoList(entryInfoList);
            for (DynamicObject entry : entryList) {
                PayScheEntryInfo entryInfo = new PayScheEntryInfo();
                boolean waitSche = BillTypeEnum.SCHEBILL.getValue().equals(entry.getString("e_billtype"));
                entryInfo.setWaitSche(waitSche);
                entryInfo.setPayId(entry.getLong("e_payid"));
                entryInfo.setPayEntryId(entry.getLong("e_payentryid"));
                entryInfoList.add(entryInfo);
            }
            fixInfoList.add(info);
        }
        String infoStr = JSON.toJSONString(fixInfoList);
        String invokeResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"payScheService", (String)"fixPayScheBill", (Object[])new Object[]{infoStr});
        List fixResultList = JSON.parseArray((String)invokeResult, PayScheFixResult.class);
        Map payScheIndexMap = Arrays.stream(allDataFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        Set originIdSet = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        for (PayScheFixResult result : fixResultList) {
            DynamicObject paySche = (DynamicObject)payScheIndexMap.get(result.getPayScheId());
            if (paySche == null) continue;
            if (result.getStatus() == RpcStatus.SUCCESS || result.getStatus() == RpcStatus.ROLLBACK) {
                DynamicObjectCollection entryList = paySche.getDynamicObjectCollection("entrys");
                entryList.clear();
                BigDecimal balance = paySche.getBigDecimal("balanceamt");
                for (PayScheEntryInfo entryInfo : result.getEntryList()) {
                    if (result.getStatus() == RpcStatus.SUCCESS && BigDecimal.ZERO.compareTo(balance) == 0 && entryInfo.isWaitSche()) continue;
                    DynamicObject entry = entryList.addNew();
                    entry.set("e_payid", (Object)entryInfo.getPayId());
                    entry.set("e_payentryid", (Object)entryInfo.getPayEntryId());
                    entry.set("e_billtype", (Object)(entryInfo.isWaitSche() ? BillTypeEnum.SCHEBILL.getValue() : BillTypeEnum.PAYBILL.getValue()));
                }
                String scheStatus = result.getStatus() == RpcStatus.SUCCESS ? ScheStatusEnum.PAYING.getValue() : ScheStatusEnum.YETSCHEDULE.getValue();
                paySche.set("schedulstatus", (Object)scheStatus);
                paySche.set("payrespstatus", null);
                paySche.set("payerrmsg", null);
                paySche.set("payerrmsg_TAG", null);
                paySche.set("fixcnt", (Object)0);
                continue;
            }
            if (!originIdSet.contains(result.getPayScheId())) continue;
            paySche.set("payrespstatus", (Object)PayScheRespEnum.PUSH_ERR.getValue());
            paySche.set("payerrmsg", (Object)StringUtils.maxString((String)result.getErrMsg(), (int)255));
            paySche.set("payerrmsg_TAG", (Object)result.getErrMsg());
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, paySche.getPkValue(), (Object)paySche.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(paySche.get("billno") + ":" + result.getErrMsg());
            this.errorInfoList.add(operateErrorInfo);
        }
        SaveServiceHelper.save((DynamicObject[])allDataFromDB);
    }

    @Override
    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

