/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleHelper;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayRpcResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.PaySchePayInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayScheRpcResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.RpcStatus;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheBillPayService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheBillPayService.class);
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("expectpaydate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("schedulstatus");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("exchangerate");
        selector.add("waitpayamt");
        selector.add("exratetable");
        selector.add("transferpost");
        selector.add("iscasexitbill");
        selector.add("payrespstatus");
        selector.add("paytime");
        selector.add("payerrmsg");
        selector.add("payerrmsg_TAG");
        selector.add("batchpayid");
        selector.add("fixcnt");
        selector.add("isbilldibs");
        selector.add("dibsbalance");
        selector.add("paymenttype");
        selector.add("draftpayno");
        selector.add("draftpaystatus");
        selector.add("sourcebillnumber");
        selector.add("billno");
        selector.add("entrys.e_payentryid");
        selector.add("draftpayacct");
        selector.add("draftinfoentry");
        selector.add("lcarrivalno");
        selector.add("businesstype");
        selector.add("institutioncode");
        selector.add("institutionname");
        selector.add(String.format("%s.%s", "draftinfoentry", "de_transferamt"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftinfo"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftlogid"));
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List singlePayList = Arrays.stream(dataEntities).filter(o -> StringUtils.isEmpty((String)o.getString("batchnum"))).collect(Collectors.toList());
        Map<String, List<DynamicObject>> batchMap = Arrays.stream(dataEntities).filter(o -> !StringUtils.isEmpty((String)o.getString("batchnum"))).collect(Collectors.groupingBy(o -> o.getString("batchnum")));
        for (DynamicObject dynamicObject : singlePayList) {
            dynamicObject.set("batchpayid", (Object)BeServiceHelper.generateSerialNumber());
        }
        for (List list : batchMap.values()) {
            String batchPayId = BeServiceHelper.generateSerialNumber();
            for (DynamicObject data : list) {
                data.set("batchpayid", (Object)batchPayId);
            }
        }
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            data.set("schedulstatus", (Object)ScheStatusEnum.PAYING.getValue());
            data.set("iscasexitbill", (Object)"0");
            data.set("fixcnt", (Object)0);
            data.set("payrespstatus", (Object)PayScheRespEnum.WAIT_RESP.getValue());
            data.set("paytime", (Object)new Date());
            ids.add((Long)data.getPkValue());
        }
        logger.info("\u4ed8\u6b3e\u670d\u52a1\u901a\u8fc7\u6821\u9a8c\u7684\u6570\u636e\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(ids));
        int[] nArray = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)("update t_psd_schedulebill set fschedulstatus = 'paying' where fid in (" + TmcBusinessBaseHelper.idListToString(ids) + ") and fschedulstatus = 'yetschedule'"), Collections.singletonList(new Object[0]));
        if (nArray.length < 1 || nArray[0] != ids.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u4ed8\u6b3e\u5931\u8d25, \u6392\u7a0b\u5355\u72b6\u6001\u4e0d\u5168\u4e3a\u5df2\u6392\u7a0b", (String)"PayScheBillFixEntryValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        try {
            Map payScheIndexMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
            List infos = Arrays.stream(dataEntities).map(PayScheHelper::beanFromDynamicObject).collect(Collectors.toList());
            String infoStr = JSON.toJSONString(infos);
            logger.info("\u6392\u7a0b\u5355\u4ed8\u6b3e\u53d1\u9001\u62a5\u6587\uff1a" + infoStr);
            String invokeResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"payScheService", (String)"pushPayBill", (Object[])new Object[]{infoStr});
            List rpcResultList = JSON.parseArray((String)invokeResult, PayRpcResult.class);
            logger.info("\u6392\u7a0b\u5355\u4ed8\u6b3e\u8fd4\u56de\u62a5\u6587\uff1a" + invokeResult);
            HashMap<String, String> payBillArrivalNos = new HashMap<String, String>(16);
            for (PayRpcResult rpcResult : rpcResultList) {
                DynamicObject paySche;
                HashSet<Long> delEntryIdSet = new HashSet<Long>();
                if (RpcStatus.SUCCESS == rpcResult.getStatus()) {
                    logger.info("\u4ed8\u6b3e\u5fae\u670d\u52a1\u6210\u529f");
                    HashSet<Long> successPayScheIdSet = new HashSet<Long>(8);
                    for (PayScheRpcResult result : rpcResult.getSuccessList()) {
                        successPayScheIdSet.add(result.getPayScheId());
                        DynamicObject paySche2 = (DynamicObject)payScheIndexMap.get(result.getPayScheId());
                        if (paySche2 == null) continue;
                        paySche2.set("payrespstatus", null);
                        this.setPayErrMsg(paySche2, null);
                        DynamicObjectCollection entryList = paySche2.getDynamicObjectCollection("entrys");
                        Long resultPayEntryId = result.getPayBillEntryId();
                        for (DynamicObject entry : entryList) {
                            Long payEntryId = entry.getLong("e_payentryid");
                            if (payEntryId == null || resultPayEntryId == null || !payEntryId.equals(resultPayEntryId)) continue;
                            delEntryIdSet.add(payEntryId);
                        }
                        BigDecimal balance = paySche2.getBigDecimal("balanceamt");
                        if (BigDecimal.ZERO.compareTo(balance) == 0) {
                            entryList.removeIf(o -> "schebill".equals(o.get("e_billtype")));
                        }
                        DynamicObject newEntry = entryList.addNew();
                        newEntry.set("e_payid", (Object)result.getPayBillId());
                        newEntry.set("e_payentryid", (Object)result.getPayBillEntryId());
                        newEntry.set("e_billtype", (Object)"paybill");
                        this.updatePayScheduleInfo(paySche2, result, payBillArrivalNos);
                    }
                    for (PaySchePayInfo payInfo : infos) {
                        for (Long scheId : successPayScheIdSet) {
                            if (!scheId.equals(payInfo.getScheId())) continue;
                            DynamicObject paySche3 = (DynamicObject)payScheIndexMap.get(scheId);
                            BigDecimal scheAmt = payInfo.getScheAmt();
                            BigDecimal billAmt = payInfo.getDraftBillAmt();
                            BigDecimal waitPayAmt = paySche3.getBigDecimal("waitpayamt");
                            if (BigDecimal.ZERO.compareTo(waitPayAmt) == 0) {
                                waitPayAmt = paySche3.getBigDecimal("applyamt");
                            }
                            waitPayAmt = waitPayAmt.subtract(scheAmt.add(billAmt));
                            paySche3.set("waitpayamt", (Object)waitPayAmt);
                        }
                    }
                } else if (RpcStatus.ROLLBACK == rpcResult.getStatus()) {
                    logger.info("\u4ed8\u6b3e\u5fae\u670d\u52a1\u56de\u6eda");
                    for (Long errPayScheId : rpcResult.getErrPayScheIdList()) {
                        paySche = (DynamicObject)payScheIndexMap.get(errPayScheId);
                        if (paySche == null) continue;
                        paySche.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
                        paySche.set("payrespstatus", null);
                        this.setPayErrMsg(paySche, rpcResult.getErrMsg());
                    }
                } else if (RpcStatus.ERROR == rpcResult.getStatus()) {
                    logger.info("\u4ed8\u6b3e\u5fae\u670d\u52a1\u5931\u8d25");
                    for (Long errPayScheId : rpcResult.getErrPayScheIdList()) {
                        paySche = (DynamicObject)payScheIndexMap.get(errPayScheId);
                        if (paySche == null) continue;
                        paySche.set("payrespstatus", (Object)PayScheRespEnum.PUSH_ERR.getValue());
                        this.setPayErrMsg(paySche, rpcResult.getErrMsg());
                    }
                }
                PayScheduleHelper.getInstance().deletePaySchePayBillEntry(dataEntities, rpcResult);
                PayScheduleHelper.getInstance().deletePayingPayBillEntry(dataEntities, delEntryIdSet);
            }
            PayScheHelper.updateLcOperateType(payBillArrivalNos, "");
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String exceptionInfo = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            for (DynamicObject data : dataEntities) {
                data.set("payrespstatus", (Object)PayScheRespEnum.UNKNOWN_ERR.getValue());
                this.setPayErrMsg(data, exceptionInfo);
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
            throw e;
        }
    }

    private void updatePayScheduleInfo(DynamicObject paySchedule, PayScheRpcResult result, Map<String, String> payBillArrivalNos) {
        String arrivalNo;
        String settleType = "";
        String[] settlementTypes = new String[]{SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.CREDIT.getValue()};
        List<String> settlementTypeList = Arrays.asList(settlementTypes);
        DynamicObject payBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id, settletype, settletnumber, settletype.settlementtype as settlementtype,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)result.getPayBillId())});
        if (payBill == null || EmptyUtil.isEmpty((DynamicObject)payBill)) {
            return;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)payBill)) {
            settleType = payBill.getString("settlementtype");
        }
        if (StringUtils.isNotEmpty((String)settleType) && settlementTypeList.contains(settleType)) {
            paySchedule.set("draftpayno", (Object)payBill.getString("billno"));
            paySchedule.set("draftpaystatus", (Object)payBill.getString("billstatus"));
        } else {
            paySchedule.set("paymentno", (Object)payBill.getString("billno"));
            paySchedule.set("paybillstatus", (Object)payBill.getString("billstatus"));
        }
        if (kd.tmc.psd.common.helper.PayScheHelper.isCreditSettlement((String)settleType) && StringUtils.isNotEmpty((String)(arrivalNo = payBill.getString("settletnumber")))) {
            payBillArrivalNos.put(payBill.getString("billno"), arrivalNo);
        }
    }

    private void setPayErrMsg(DynamicObject data, String msg) {
        data.set("payerrmsg", msg != null ? StringUtils.maxString((String)msg, (int)255) : null);
        data.set("payerrmsg_TAG", (Object)msg);
        if (msg != null) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, data.getPkValue(), (Object)data.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s:\u4ed8\u6b3e\u5931\u8d25, \u8be6\u60c5\u8bf7\u67e5\u770b\u5355\u636e\u4ed8\u6b3e\u5f02\u5e38\u4fe1\u606f\u5b57\u6bb5", (String)"PayScheBillPayService_3", (String)"tmc-psd-business", (Object[])new Object[0]), data.get("billno")));
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

