/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheBillTransNextService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayScheBillTransNextService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("nextscheduleid");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject payScheBill : dataEntities) {
            DynamicObject newScheduleBill = AutoScheHelper.transToNextPeriod((Long)payScheBill.getPkValue());
            insertList.add(newScheduleBill);
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.TONEXT.getValue());
            payScheBill.set("nextscheduleid", (Object)newScheduleBill.getLong("id"));
            logger.info("\u8f6c\u4e0b\u671f\u7684\u6e90\u5355:{}\uff0c\n\u8f6c\u4e0b\u671f\u7684\u65b0\u5355:{}", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{payScheBill}), (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{newScheduleBill}));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
    }
}

