/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheProRealUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProRealUnAuditService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        String isFromCalc = this.operationVariable.getOrDefault("isFromCalc", null);
        if (EmptyUtil.isNoEmpty((String)isFromCalc)) {
            return;
        }
        List payScheProcBillIds = Stream.of(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
        logger.info("\u6392\u7a0b\u5904\u7406\u5355\u53cd\u5ba1\u6838\u7684Id\u4e3a: {}", (Object)LoggerPrintHelper.printCollectionLogger(payScheProcBillIds));
        DynamicObject[] payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcBillIds), new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.SCHEDULING.getValue())});
        if (payScheBills.length > 0) {
            List payScheBillIds = Arrays.stream(payScheBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            payScheBills = TmcDataServiceHelper.load((Object[])payScheBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        }
        for (DynamicObject payScheBill : payScheBills) {
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.SCHEDULING.getValue());
            payScheBill.set("draftnopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("nopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checktotalamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checkamt", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])payScheBills);
    }
}

