/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheProcAutitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProcAutitService.class);
    private static final String[] SELECTOR = new String[]{"balanceamt", "applyamt", "schedulstatus", "checktotalamt", "summaryid", "scheduleeditnum", "draftamt", "amount", "schedealid", "schedulstatus", "checkdraftamt", "checkamt", "nopayamt", "draftnopayamt"};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("e_entry");
        selector.add("e_amount");
        selector.add("e_draftamt");
        selector.add("e_balanceamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] payScheBills;
        List payScheProcBillIds = Stream.of(dataEntities).map(o -> o.getLong("processorid")).collect(Collectors.toList());
        logger.info("\u5f53\u524d\u9700\u8981\u5ba1\u6838\u7684\u6392\u7a0b\u5904\u7406\u5355ID:{}", (Object)LoggerPrintHelper.printCollectionLogger(payScheProcBillIds));
        for (DynamicObject payScheBill : payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", SELECTOR), (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcBillIds), new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.SCHEDULING.getValue())})) {
            logger.info("\u5ba1\u6838\u524d\u7684\u6392\u7a0b\u5355\u4fe1\u606f:{}", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{payScheBill}));
            BigDecimal checkAmt = payScheBill.getBigDecimal("amount");
            BigDecimal checkDraftAmt = payScheBill.getBigDecimal("draftamt");
            PayScheHelper.scheBillTransAuditProcess(payScheBill, checkAmt, checkDraftAmt);
        }
        SaveServiceHelper.save((DynamicObject[])payScheBills);
        DynamicObject[] payScheProcessorArr = TmcDataServiceHelper.load((Object[])payScheProcBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"));
        OperateOption create = OperateOption.create();
        create.setVariableValue("isFromCalc", "true");
        logger.info("%s \u5355\u5f00\u59cb\u6267\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\uff0c\u6267\u884c\u7684\u5355\u636eID\u4e3a: {}", (Object)"psd_schedealbill", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])payScheProcessorArr));
        TmcOperateServiceHelper.execOperate((String)"audit", (String)"psd_schedealbill", (DynamicObject[])payScheProcessorArr, (OperateOption)create);
    }
}

