/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheDataCreator;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;

public class PayScheProcAutoScheService
extends AbstractTmcBizOppService {
    private static Log LOGGER = LogFactory.getLog(PayScheProcAutoScheService.class);
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        OperationResult executeOperate;
        Map idAndDyMap = Stream.of(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        Set<Object> ids = idAndDyMap.keySet();
        DynamicObject[] payScheduleBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedealid", "in", ids)});
        List payScheduleBillIds = Arrays.stream(payScheduleBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        payScheduleBills = TmcDataServiceHelper.load((Object[])payScheduleBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        Map<Long, List<DynamicObject>> scheDealIdAndScheduleListMap = Arrays.stream(payScheduleBills).collect(Collectors.groupingBy(s -> s.getLong("schedealid")));
        Set applySettleTypeIdSet = Arrays.stream(payScheduleBills).filter(p -> EmptyUtil.isNoEmpty((DynamicObject)p.getDynamicObject("applysettletype"))).map(p -> p.getDynamicObject("applysettletype").getPkValue()).collect(Collectors.toSet());
        Map settleTypeMap = new HashMap(16);
        if (EmptyUtil.isNoEmpty(applySettleTypeIdSet)) {
            settleTypeMap = TmcDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,settlementtype", (QFilter[])new QFilter[]{new QFilter("id", "in", applySettleTypeIdSet)});
        }
        HashSet<DynamicObject> updateScheBillSet = new HashSet<DynamicObject>(16);
        PayScheDataTransfer dataTransfer = new PayScheDataTransfer();
        for (Map.Entry<Long, List<DynamicObject>> entry : scheDealIdAndScheduleListMap.entrySet()) {
            DynamicObject scheBill;
            Map scaleMap;
            List<PayScheCalcModel> filterScheModels;
            Map idAndScheBillMap;
            HashSet<Long> errIdSet;
            List<DynamicObject> scheduleList;
            block10: {
                long scheDealId = entry.getKey();
                scheduleList = entry.getValue();
                errIdSet = new HashSet<Long>(16);
                DynamicObject scheduleDeal = (DynamicObject)idAndDyMap.get(scheDealId);
                if (EmptyUtil.isEmpty((DynamicObject)scheduleDeal)) continue;
                idAndScheBillMap = scheduleList.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
                List<PayScheCalcModel> scheModels = new PayScheDataTransfer().transScheDataToCalcModelList(scheduleList);
                PayScheduleUtil.processExpectDate(scheModels);
                for (PayScheCalcModel scheduleModel : scheModels) {
                    DynamicObject scheduleBill = (DynamicObject)idAndScheBillMap.get(scheduleModel.getScheId());
                    if (EmptyUtil.isEmpty((DynamicObject)scheduleBill) || !EmptyUtil.isNoEmpty((Object)scheduleModel.getExpectDate())) continue;
                    scheduleBill.set("expectdate", (Object)scheduleModel.getExpectDate());
                }
                Map finalSettleTypeMap = settleTypeMap;
                filterScheModels = scheModels.stream().filter(Objects::nonNull).filter(v -> BigDecimal.ZERO.compareTo(v.getScheAmt()) == 0 && BigDecimal.ZERO.compareTo(v.getDraftBillAmt()) == 0 && ScheStatusEnum.SCHEDULING.getValue().equals(v.getScheStatus())).filter(o -> EmptyUtil.isEmpty((String)o.getBatchnum())).filter(o -> EmptyUtil.isEmpty((Long)o.getEntrustPayId())).filter(o -> {
                    Long applySettlementTypeId = o.getApplySettlementTypeId();
                    if (applySettlementTypeId == null) {
                        return true;
                    }
                    DynamicObject settleType = (DynamicObject)finalSettleTypeMap.get(applySettlementTypeId);
                    if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                        String typeString = settleType.getString("settlementtype");
                        return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
                    }
                    return true;
                }).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(filterScheModels)) {
                    updateScheBillSet.addAll(new HashSet<DynamicObject>(scheduleList));
                    continue;
                }
                String virtualPageId = String.valueOf(DB.genGlobalLongId());
                IPayScheService payScheService = PayScheServiceFactory.getPayScheService();
                scaleMap = TmcAmountHelper.getScaleMap(filterScheModels.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
                Long orgId = scheduleDeal.getDynamicObject("company").getLong("id");
                try {
                    PayScheProcessResult<Void> scheProcessResult = payScheService.autoSchedule(orgId, filterScheModels, virtualPageId);
                    if (scheProcessResult.isSuccess() || !EmptyUtil.isNoEmpty(scheProcessResult.getErrMsgList())) break block10;
                    String errorMsg = scheProcessResult.getErrMsgList().stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> "");
                    for (PayScheCalcModel paySche : scheModels) {
                        DynamicObject scheBill2 = (DynamicObject)idAndScheBillMap.get(paySche.getScheId());
                        if (scheBill2 == null) continue;
                        this.addErrorMessage(scheBill2, errorMsg);
                        errIdSet.add(scheBill2.getLong("id"));
                    }
                }
                catch (Exception e) {
                    for (PayScheCalcModel paySche : filterScheModels) {
                        paySche.reCalcBalance((Integer)scaleMap.get(paySche.getCurrencyId()));
                        scheBill = (DynamicObject)idAndScheBillMap.get(paySche.getScheId());
                        if (scheBill == null) continue;
                        this.addErrorMessage(scheBill, e.getMessage());
                        errIdSet.add(scheBill.getLong("id"));
                    }
                    continue;
                }
            }
            PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(filterScheModels);
            for (PayScheCalcModel paySche : filterScheModels) {
                paySche.reCalcBalance((Integer)scaleMap.get(paySche.getCurrencyId()));
                scheBill = (DynamicObject)idAndScheBillMap.get(paySche.getScheId());
                if (EmptyUtil.isEmpty((DynamicObject)scheBill)) continue;
                scheBill.set("waitpayamt", scheBill.get("applyamt"));
                dataTransfer.transCalcModelPropsToPayScheData(scheBill, paySche, dataProvider, new HashMap<String, PayScheCalcModel>(2));
            }
            updateScheBillSet.addAll(scheduleList.stream().filter(o -> !errIdSet.contains(o.getLong("id"))).collect(Collectors.toSet()));
        }
        if (updateScheBillSet.size() > 0 && !(executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])updateScheBillSet.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)executeOperate));
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }

    private void addBillBatchNum(List<PayScheCalcModel> scheModels, Map<Long, List<PayScheCalcModel>> orgIdGroupedMap, Map<Long, DynamicObject> defaultRules) {
        String batchNum;
        Map<Long, List<PayScheCalcModel>> groupByPayBillIdMap = scheModels.stream().collect(Collectors.groupingBy(PayScheCalcModel::getPayBillId));
        String pageId = String.valueOf(DB.genGlobalLongId());
        HashMap<Long, String> sourceBatchNums = new HashMap<Long, String>(16);
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : groupByPayBillIdMap.entrySet()) {
            List<PayScheCalcModel> payScheCalcModels = entry.getValue();
            if (EmptyUtil.isEmpty(payScheCalcModels)) continue;
            PayScheCalcModel payScheCalcModel = payScheCalcModels.get(0);
            Long orgId = payScheCalcModel.getOrgId();
            long payBillId = entry.getKey();
            AutoScheDataCreator autoScheDataCreator = new AutoScheDataCreator(orgId, pageId, entry.getValue(), true);
            batchNum = autoScheDataCreator.getBatchNum(payBillId);
            Map<Long, DynamicObject> ruleMap = autoScheDataCreator.getDefaultRules();
            if (ruleMap != null && ruleMap.get(payBillId) != null && EmptyUtil.isNoEmpty((DynamicObject)ruleMap.get(payBillId))) {
                defaultRules.putAll(ruleMap);
            }
            if (!StringUtils.isNotEmpty((CharSequence)batchNum) || !ScheStatusEnum.NOSCHEDULE.getValue().equals(payScheCalcModel.getScheStatus())) continue;
            sourceBatchNums.put(payBillId, batchNum);
        }
        if (sourceBatchNums.isEmpty()) {
            return;
        }
        HashSet<Long> masterPayBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : orgIdGroupedMap.entrySet()) {
            List<PayScheCalcModel> payScheCalcModels = entry.getValue();
            if (payScheCalcModels.size() == 0 || payScheCalcModels.size() == 1) continue;
            for (PayScheCalcModel payScheCalcModel : payScheCalcModels) {
                long payBillId = payScheCalcModel.getPayBillId();
                if (!sourceBatchNums.containsKey(payBillId)) continue;
                batchNum = (String)sourceBatchNums.get(payBillId);
                payScheCalcModel.setBatchnum(batchNum);
                if (!masterPayBillIds.add(payBillId)) continue;
                payScheCalcModel.setMasterData(true);
            }
        }
    }

    private void addErrorMessage(DynamicObject paySche, String msg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, paySche.getPkValue(), (Object)paySche.getDynamicObjectType().getName());
        operateErrorInfo.setMessage(paySche.get("billno") + ":" + msg);
        this.errorInfoList.add(operateErrorInfo);
    }
}

