/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheProcCalcUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProcCalcUnAuditService.class);
    private static final String[] SELECTOR = new String[]{"schedulstatus", "draftnopayamt", "nopayamt", "nopayamt", "checktotalamt", "checkamt"};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("processorid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] payScheProcessorArr;
        DynamicObject[] payScheBills;
        List payScheProcBillIds = Stream.of(dataEntities).map(o -> o.getLong("processorid")).collect(Collectors.toList());
        logger.info("\u5f53\u524d\u9700\u8981\u5ba1\u6838\u7684\u6392\u7a0b\u5904\u7406\u5355ID:{}", (Object)LoggerPrintHelper.printCollectionLogger(payScheProcBillIds));
        for (DynamicObject payScheBill : payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", SELECTOR), (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcBillIds), new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.YETSCHEDULE.getValue())})) {
            logger.info("\u5ba1\u6838\u524d\u7684\u6392\u7a0b\u5355\u4fe1\u606f:{}", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{payScheBill}));
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.SCHEDULING.getValue());
            payScheBill.set("draftnopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("nopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checktotalamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checkamt", (Object)BigDecimal.ZERO);
            logger.info("\u5ba1\u6838\u540e\u7684\u6392\u7a0b\u5355\u4fe1\u606f:{}", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{payScheBill}));
        }
        SaveServiceHelper.save((DynamicObject[])payScheBills);
        for (DynamicObject processor : payScheProcessorArr = TmcDataServiceHelper.load((Object[])payScheProcBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"))) {
            processor.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])payScheProcessorArr);
    }
}

