/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheProcDelService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProcDelService.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismasterdata");
        selector.add("batchnum");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List payScheProcBillIds = Stream.of(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        logger.info("\u5f53\u524d\u9700\u8981\u5220\u9664\u7684\u6392\u7a0b\u5904\u7406\u5355ID:{}", (Object)LoggerPrintHelper.printCollectionLogger(payScheProcBillIds));
        DynamicObject[] payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcBillIds)});
        List payScheBillIds = Arrays.stream(payScheBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        payScheBills = TmcDataServiceHelper.load((Object[])payScheBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        PayScheduleUtil.processPayScheduleBillDelete(payScheBills, this.draftLockServiceHelper);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.afterProcessRollback(dataEntities);
        this.draftLockServiceHelper.rollback();
    }
}

