/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheHelper;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheProcSaveOrSubmit
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProcSaveOrSubmit.class);
    private boolean isSubmit;
    private DraftLockServiceHelper draftLockServiceHelper;

    public PayScheProcSaveOrSubmit(boolean isSubmit) {
        this.isSubmit = isSubmit;
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map opVariable = this.getOperationVariable();
        String cacheDateStr = (String)opVariable.get("key_payschemodel");
        logger.info("\u5f85\u4fdd\u5b58\u7684\u7f13\u5b58\u4e2d\u6570\u636e\u4e3a:{}", (Object)cacheDateStr);
        if (EmptyUtil.isNoEmpty((String)cacheDateStr)) {
            List<PayScheCalcModel> scheData = PayScheCalcModel.deserializeList(cacheDateStr);
            String allDeleteScheduleBills = opVariable.getOrDefault("deleteScheduleBillList", null);
            ArrayList<PayScheCalcModel> allDeleteScheduleList = EmptyUtil.isNoEmpty((String)allDeleteScheduleBills) ? PayScheCalcModel.deserializeList(allDeleteScheduleBills) : new ArrayList<PayScheCalcModel>(10);
            scheData.addAll(allDeleteScheduleList);
            List<PayScheCalcModel> scheDataList = scheData.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
            Map<String, PayScheCalcModel> mergeData = scheData.stream().filter(o -> o.isArchiveMerger()).collect(Collectors.toMap(o -> o.getBatchnum(), o -> o));
            for (DynamicObject payScheProc : dataEntities) {
                this.saveCachePaySche(payScheProc, scheDataList, mergeData);
            }
            this.processDeletePayScheduleBill(allDeleteScheduleList);
        }
    }

    private void processDeletePayScheduleBill(List<PayScheCalcModel> allDeleteScheduleList) {
        if (EmptyUtil.isEmpty(allDeleteScheduleList)) {
            return;
        }
        List payScheBillIds = allDeleteScheduleList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        Object[] payScheBills = TmcDataServiceHelper.load((Object[])payScheBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        if (EmptyUtil.isNoEmpty((Object[])payScheBills)) {
            PayScheduleUtil.processPayScheduleBillDelete((DynamicObject[])payScheBills, this.draftLockServiceHelper);
        }
    }

    private void saveCachePaySche(DynamicObject processor, List<PayScheCalcModel> scheList, Map<String, PayScheCalcModel> mergeData) {
        PayScheDataTransfer dataTransfer = new PayScheDataTransfer();
        PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(scheList);
        Long processorId = processor.getLong("processorid");
        List scheBillIds = scheList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        ArrayList<Object> waitChargebackIdList = new ArrayList<Object>();
        DynamicObject[] scheBills = TmcDataServiceHelper.load((Object[])scheBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        Map<Object, DynamicObject> scheBillFromDbMap = Stream.of(scheBills).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        ArrayList<DynamicObject> waiteSaveScheBill = new ArrayList<DynamicObject>(scheList.size());
        Map<Long, String> scheStatusMap = AutoScheHelper.getNextBillStatusMap(Arrays.asList(scheBills));
        ArrayList<Long> nextBillIds = new ArrayList<Long>(scheBills.length);
        StringBuilder errorMsg = new StringBuilder();
        for (PayScheCalcModel paySche : scheList) {
            DynamicObject scheBill = scheBillFromDbMap.get(paySche.getScheId());
            if (scheBill == null) {
                DynamicObject originSplitData;
                Long topSplitId = PayScheCalcModel.getTopSplitId(paySche, scheList);
                logger.info("\u65e0\u6cd5\u4eceDB\u4e2d\u627e\u5230\u6392\u7a0b\u5355,\u4e3a\u62c6\u5206\u51fa\u7684\u5355\u636e or \u5dee\u989d\u62c6\u5206\u7684\u5355\u636e,\u5176\u62c6\u5206id\u4e3a:{}, \u62c6\u5206\u7684\u539f\u59cb\u5355\u636e\u4e3a: {}", (Object)topSplitId, (Object)scheBillFromDbMap.get(topSplitId));
                if (topSplitId == null || (originSplitData = scheBillFromDbMap.get(topSplitId)) == null) continue;
                scheBill = TmcDataServiceHelper.clone((DynamicObject)originSplitData);
            }
            String scheBillFromDbStatus = scheBill.getString("schedulstatus");
            String scheNewStatus = paySche.getScheStatus();
            dataTransfer.transCalcModelPropsToPayScheData(scheBill, paySche, dataProvider, mergeData);
            scheBill.set("waitpayamt", scheBill.get("applyamt"));
            if (ScheStatusEnum.YETCHARGEBACK.getValue().equals(scheNewStatus) && !ScheStatusEnum.YETCHARGEBACK.getValue().equals(scheBillFromDbStatus)) {
                waitChargebackIdList.add(scheBill.getPkValue());
            }
            if (ScheStatusEnum.SCHEDULING.getValue().equals(scheBillFromDbStatus) && ScheStatusEnum.TONEXT.getValue().equals(scheNewStatus)) {
                logger.info("\u6392\u7a0b\u4e2d\u72b6\u6001\u8f6c\u4e0b\u671f\uff0c\u751f\u6210\u4e0b\u6e38\u5355\u636e");
                DynamicObject newScheduleBill = AutoScheHelper.transToNextPeriod(scheBill);
                waiteSaveScheBill.add(newScheduleBill);
                scheBill.set("nextscheduleid", (Object)newScheduleBill.getLong("id"));
            } else if (ScheStatusEnum.TONEXT.getValue().equals(scheBillFromDbStatus) && ScheStatusEnum.SCHEDULING.getValue().equals(scheNewStatus)) {
                logger.info("\u8f6c\u4e0b\u671f->\u6392\u7a0b\u4e2d,\u5148\u6821\u9a8c\u4e0b\u6e38\u5355\u636e\u72b6\u6001,\u518d\u5220\u9664\u4e0b\u6e38\u5355\u636e");
                String nextBillStatus = scheStatusMap.get(scheBill.getLong("nextscheduleid"));
                if (nextBillStatus != null && !ScheStatusEnum.NOSCHEDULE.getValue().equals(nextBillStatus)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u5f53\u8f6c\u4e0b\u671f\u751f\u6210\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u72b6\u6001\u4e3a\u672a\u6392\u7a0b\u65f6\uff0c\u624d\u80fd\u64a4\u9500\u8f6c\u4e0b\u671f\u3002", (String)"PayScheServiceImpl_43", (String)"tmc-psd-business", (Object[])new Object[0]), scheBill.getString("billno")));
                    continue;
                }
                nextBillIds.add(scheBill.getLong("nextscheduleid"));
                scheBill.set("nextscheduleid", null);
            }
            if (paySche.isDiffSplit()) {
                logger.info("\u5dee\u989d\u62c6\u5206\uff0c\u6e05\u7a7a\u8f6c\u4e0b\u671fID");
                scheBill.set("nextscheduleid", null);
            }
            waiteSaveScheBill.add(scheBill);
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])waiteSaveScheBill.toArray(new DynamicObject[waiteSaveScheBill.size()]), (OperateOption)OperateOption.create());
        if (!executeOperate.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)executeOperate));
        }
        if (!CollectionUtils.isEmpty(waitChargebackIdList)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("key_isskipvalidate", "true");
            logger.info("\u5f00\u59cb\u6267\u884c {} \u5355\u636e\u7684\u9000\u5355\u64cd\u4f5c,\u9000\u5355\u7684\u5355\u636e\u4e3a: {}", (Object)"psd_schedulebill", (Object)LoggerPrintHelper.printCollectionLogger(waitChargebackIdList));
            OperationResult result = OperationServiceHelper.executeOperate((String)"chargeback", (String)"psd_schedulebill", (Object[])waitChargebackIdList.toArray(), (OperateOption)option);
            if (!result.isSuccess()) {
                throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result));
            }
        }
        if (!EmptyUtil.isEmpty(nextBillIds)) {
            logger.info("\u5f00\u59cb\u5220\u9664\u5df2\u8f6c\u4e0b\u671f\u7684\u4e0b\u6e38\u5355\u636e,\u5220\u9664\u7684\u5355\u636eID\u4e3a: {}", (Object)LoggerPrintHelper.printCollectionLogger(waitChargebackIdList));
            DeleteServiceHelper.delete((IDataEntityType)scheBills[0].getDataEntityType(), (Object[])nextBillIds.toArray(new Long[nextBillIds.size()]));
        }
        DynamicObject dbProcessor = TmcDataServiceHelper.loadSingle((Object)processorId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"));
        dbProcessor.set("description", (Object)processor.getString("description"));
        if (this.isSubmit) {
            dbProcessor.set("adjustcount", (Object)(processor.getInt("adjustcount") + 1));
            TmcOperateServiceHelper.execOperate((String)"submit", (String)"psd_schedealbill", (DynamicObject[])new DynamicObject[]{dbProcessor}, (OperateOption)OperateOption.create());
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbProcessor});
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.afterProcessRollback(dataEntities);
        this.draftLockServiceHelper.rollback();
    }
}

