/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.utils.CombineUtil;
import kd.tmc.psd.common.builder.FormulaGetHandle;
import kd.tmc.psd.common.builder.ISingleTaskContext;
import kd.tmc.psd.common.builder.SingleTaskContext;
import kd.tmc.psd.common.helper.PayScheHelper;

public class AutoScheDataCreator {
    private static Log logger = LogFactory.getLog(AutoScheDataCreator.class);
    private long orgId;
    private List<PayScheCalcModel> payScheDataList;
    private DraftBillLockCache billCache;
    private Map<Long, Integer> scaleMap;
    private boolean oneKeySche;
    private Map<Long, DynamicObject> defaultRules;

    public AutoScheDataCreator(long orgId, String pageId, List<PayScheCalcModel> payScheDataList) {
        this(orgId, pageId, payScheDataList, false);
    }

    public AutoScheDataCreator(long orgId, String pageId, List<PayScheCalcModel> payScheDataList, boolean oneKeySche) {
        this.orgId = orgId;
        this.payScheDataList = payScheDataList;
        this.billCache = new DraftBillLockCache(pageId);
        this.scaleMap = TmcAmountHelper.getScaleMap(payScheDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        this.oneKeySche = oneKeySche;
        this.defaultRules = new HashMap<Long, DynamicObject>(16);
    }

    public AutoScheDataCreator(long orgId) {
        this.orgId = orgId;
    }

    public boolean isCombine() {
        DynamicObject rule = this.getRule();
        if (rule == null || EmptyUtil.isEmpty((DynamicObject)rule)) {
            return false;
        }
        boolean isCombine = rule.getBoolean("iscombine");
        return isCombine;
    }

    public String getBatchNum(long payBillId) {
        DynamicObject org = TmcDataServiceHelper.loadSingle((Object)this.orgId, (String)"bos_org");
        DynamicObject rule = this.getRule();
        if (rule == null || EmptyUtil.isEmpty((DynamicObject)rule)) {
            return "";
        }
        boolean isCombine = rule.getBoolean("iscombine");
        if (!isCombine) {
            return "";
        }
        List<DynamicObject> ruleEntry = this.getRuleEntry(org, rule);
        Set<String> filterProps = this.getFilterProperties(ruleEntry);
        List<Long> allScheIdList = this.payScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        DynamicObjectCollection scheduleBills = this.getScheduleBills(allScheIdList, filterProps);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)scheduleBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u65e0\u9700\u6392\u7a0b\u3002", (String)"AutoScheHandler_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        HashMap scheduleBillMap = new HashMap();
        scheduleBills.forEach(bill -> scheduleBillMap.put(bill.getLong("id"), bill));
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(filterProps.size());
        DynamicObjectType dType = scheduleBills.getDynamicObjectType();
        for (String prop : filterProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        List<PayScheCalcModel> scheDataList = this.filterPayScheDataList();
        boolean isSameRule = true;
        if (ruleEntry == null || EmptyUtil.isEmpty(ruleEntry)) {
            logger.info("====AutoScheDataCreator==ruleEntry is null");
            return "";
        }
        DynamicObject selectRule = null;
        for (DynamicObject ruleRow : ruleEntry) {
            for (PayScheCalcModel scheData : scheDataList) {
                Long topSplitId;
                DynamicObject onlyForFilterScheObj = (DynamicObject)scheduleBillMap.get(scheData.getScheId());
                if (onlyForFilterScheObj == null && (topSplitId = PayScheCalcModel.getTopSplitId(scheData, this.payScheDataList)) != null) {
                    onlyForFilterScheObj = (DynamicObject)scheduleBillMap.get(topSplitId);
                }
                if (onlyForFilterScheObj == null) {
                    logger.info("====AutoScheDataCreator==onlyForFilterScheObj is null");
                    isSameRule = false;
                    break;
                }
                if (!this.isMatchRule(onlyForFilterScheObj, ruleRow, fldProperties)) {
                    logger.info("====AutoScheDataCreator==isMatchRule : false");
                    isSameRule = false;
                    break;
                }
                isSameRule = true;
            }
            if (!isSameRule) continue;
            selectRule = ruleRow;
            break;
        }
        logger.info("====AutoScheDataCreator==isSameRule : {}", (Object)isSameRule);
        if (isSameRule) {
            this.defaultRules.put(payBillId, selectRule);
            return CombineUtil.generateCombineNum(this.orgId);
        }
        return "";
    }

    public Tuple<List<WaitScheData>, List<WaitScheData>> createAutoPayScheList() {
        ArrayList<WaitScheData> waitScheFundData = new ArrayList<WaitScheData>(10);
        ArrayList<WaitScheData> waitScheBillData = new ArrayList<WaitScheData>(10);
        DynamicObject org = TmcDataServiceHelper.loadSingle((Object)this.orgId, (String)"bos_org");
        DynamicObject rule = this.getRule();
        List<DynamicObject> ruleEntry = this.getRuleEntry(org, rule);
        Set<String> filterProps = this.getFilterProperties(ruleEntry);
        List<Long> allScheIdList = this.payScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        DynamicObjectCollection scheduleBills = this.getScheduleBills(allScheIdList, filterProps);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)scheduleBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u65e0\u9700\u6392\u7a0b\u3002", (String)"AutoScheHandler_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        HashMap scheduleBillMap = new HashMap();
        scheduleBills.forEach(bill -> scheduleBillMap.put(bill.getLong("id"), bill));
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(filterProps.size());
        DynamicObjectType dType = scheduleBills.getDynamicObjectType();
        for (String prop : filterProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        HashSet<Long> releasedBillSet = new HashSet<Long>();
        List<PayScheCalcModel> scheDataList = this.filterPayScheDataList();
        for (PayScheCalcModel scheData : scheDataList) {
            Long topSplitId;
            DynamicObject onlyForFilterScheObj = (DynamicObject)scheduleBillMap.get(scheData.getScheId());
            if (onlyForFilterScheObj == null && (topSplitId = PayScheCalcModel.getTopSplitId(scheData, this.payScheDataList)) != null) {
                onlyForFilterScheObj = (DynamicObject)scheduleBillMap.get(topSplitId);
            }
            if (onlyForFilterScheObj == null || ruleEntry == null) continue;
            boolean hasRule = false;
            Long payBillId = scheData.getPayBillId();
            DynamicObject defaultRule = null;
            if (payBillId != null && this.defaultRules != null) {
                defaultRule = this.defaultRules.get(payBillId);
            }
            if (defaultRule != null && EmptyUtil.isNoEmpty(defaultRule)) {
                hasRule = this.autoScheduleByRule(waitScheFundData, waitScheBillData, releasedBillSet, scheData, defaultRule);
            } else {
                for (DynamicObject ruleRow : ruleEntry) {
                    if (!this.isMatchRule(onlyForFilterScheObj, ruleRow, fldProperties)) continue;
                    hasRule = this.autoScheduleByRule(waitScheFundData, waitScheBillData, releasedBillSet, scheData, ruleRow);
                    break;
                }
            }
            if (!this.oneKeySche || hasRule) continue;
            scheData.setNotMatchAutoScheRule(true);
        }
        this.billCache.release(releasedBillSet);
        return Tuple.create(waitScheFundData, waitScheBillData);
    }

    private boolean autoScheduleByRule(List<WaitScheData> waitScheFundData, List<WaitScheData> waitScheBillData, Set<Long> releasedBillSet, PayScheCalcModel scheData, DynamicObject ruleRow) {
        WaitScheData autoScheData;
        DynamicObject fundflowitem = ruleRow.getDynamicObject("fundflowitem");
        DynamicObject fundRule = ruleRow.getDynamicObject("rowchengtrule");
        DynamicObject billRule = ruleRow.getDynamicObject("rowticketrule");
        if (fundflowitem != null) {
            scheData.setFundUsageId((Long)fundflowitem.getPkValue());
        }
        BigDecimal fundScale = ruleRow.getBigDecimal("scheradio");
        BigDecimal billScale = ruleRow.getBigDecimal("schedraftradio");
        scheData.setScheAmt(BigDecimal.ZERO);
        scheData.setDraftBillAmt(BigDecimal.ZERO);
        if (!CollectionUtils.isEmpty(scheData.getDraftBillIds())) {
            releasedBillSet.addAll(scheData.getDraftBillIds());
        }
        scheData.setDraftBillIds(null);
        scheData.reCalcBalance(this.scaleMap.get(scheData.getCurrencyId()));
        BigDecimal scheBalance = scheData.getScheBalance();
        BigDecimal fundAmt = scheBalance.multiply(fundScale);
        BigDecimal billAmt = scheBalance.multiply(billScale);
        scheData.setTransferPost(ruleRow.getString("transferpost"));
        if (fundRule != null && fundAmt.compareTo(BigDecimal.ZERO) != 0) {
            autoScheData = new WaitScheData();
            autoScheData.setScheRule(fundRule);
            autoScheData.setAmount(fundAmt);
            autoScheData.setPayScheData(scheData);
            waitScheFundData.add(autoScheData);
        }
        if (billRule != null && billAmt.compareTo(BigDecimal.ZERO) != 0 && EmptyUtil.isNoEmpty((Long)scheData.getCurrencyId()) && EmptyUtil.isNoEmpty((Long)scheData.getApplyCurrencyId()) && scheData.getCurrencyId().compareTo(scheData.getApplyCurrencyId()) == 0) {
            autoScheData = new WaitScheData();
            autoScheData.setScheRule(billRule);
            autoScheData.setAmount(billAmt);
            autoScheData.setPayScheData(scheData);
            waitScheBillData.add(autoScheData);
        }
        return true;
    }

    public List<WaitScheData> createFundDataList(DynamicObject fundRule) {
        ArrayList<WaitScheData> autoScheDataList = new ArrayList<WaitScheData>(10);
        List<PayScheCalcModel> dataList = this.filterPayScheDataList();
        for (PayScheCalcModel payScheCalcModel : dataList) {
            WaitScheData autoScheData = new WaitScheData();
            autoScheData.setScheRule(fundRule);
            autoScheData.setPayScheData(payScheCalcModel);
            if (payScheCalcModel.getScheAmt().compareTo(BigDecimal.ZERO) > 0) {
                autoScheData.setAmount(payScheCalcModel.getScheAmt());
            } else {
                autoScheData.setAmount(payScheCalcModel.getScheBalance());
            }
            autoScheDataList.add(autoScheData);
        }
        return autoScheDataList;
    }

    public List<WaitScheData> createBillDataList(DynamicObject billRule) {
        ArrayList<WaitScheData> autoScheDataList = new ArrayList<WaitScheData>(10);
        List<PayScheCalcModel> dataList = this.filterPayScheDataList();
        for (PayScheCalcModel payScheCalcModel : dataList) {
            WaitScheData autoScheData = new WaitScheData();
            autoScheData.setScheRule(billRule);
            autoScheData.setPayScheData(payScheCalcModel);
            if (payScheCalcModel.getDraftBillAmt().compareTo(BigDecimal.ZERO) > 0) {
                autoScheData.setAmount(payScheCalcModel.getDraftBillAmt());
            } else {
                autoScheData.setAmount(payScheCalcModel.getScheBalance());
            }
            autoScheDataList.add(autoScheData);
        }
        return autoScheDataList;
    }

    private DynamicObjectCollection getScheduleBills(List<Long> scheDealBillIds, Collection<String> filterProps) {
        HashSet<String> selProps = new HashSet<String>(filterProps);
        selProps.add("id");
        selProps.add("currency");
        selProps.add("expectdate");
        selProps.add("applyamt");
        selProps.add("balanceamt");
        selProps.add("schedulstatus");
        selProps.add("fundflowitem");
        selProps.add("applysettletype");
        selProps.add("applyacctbank");
        selProps.add("paymenttype");
        String selectString = StringUtils.join((Object[])selProps.toArray(new String[selProps.size()]), (String)",");
        DynamicObjectCollection scheduleBills = null;
        QFilter pkFilter = new QFilter("id", "in", scheDealBillIds);
        try (DataSet dsn = QueryServiceHelper.queryDataSet((String)AutoScheDataCreator.class.getName(), (String)"psd_schedulebill", (String)selectString, (QFilter[])new QFilter[]{pkFilter}, null);){
            scheduleBills = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        return scheduleBills;
    }

    private List<PayScheCalcModel> filterPayScheDataList() {
        Map<String, List<PayScheCalcModel>> groupedList = this.payScheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).collect(Collectors.groupingBy(PayScheCalcModel::getBatchnum));
        Set negateCombineNumSet = groupedList.entrySet().stream().filter(o -> {
            BigDecimal applyAmtSum = ((List)o.getValue()).stream().map(t -> t.getActualApplyAmt(this.scaleMap.get(t.getCurrencyId()))).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            return applyAmtSum.compareTo(BigDecimal.ZERO) < 0;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        List<PayScheCalcModel> scheModelList = this.payScheDataList.stream().filter(o -> {
            String batchNum;
            return EmptyUtil.isEmpty((String)o.getBatchnum()) || !negateCombineNumSet.contains(batchNum = o.getBatchnum());
        }).collect(Collectors.toList());
        return scheModelList;
    }

    private boolean isMatchRule(DynamicObject schedulebill, DynamicObject ruleRow, Map<String, DynamicProperty> fldProperties) {
        boolean isMatchRule = false;
        String filterStr = ruleRow.getString("e_datafilterdesc_real_TAG");
        if (EmptyUtil.isNoEmpty((String)filterStr)) {
            MainEntityType mainEntityType;
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType = MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
            if (!"".equals(baseFilterStr)) {
                try {
                    SingleTaskContext taskContext = new SingleTaskContext();
                    taskContext.setSrcEntityType(mainEntityType);
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, schedulebill, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    logger.error((Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private DynamicObject getRule() {
        Object rule = null;
        QFilter orgF = new QFilter("orgentryentity.org.id", "=", (Object)this.orgId);
        QFilter enableF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter effDateFilter = PayScheHelper.buildAutoRuleEffDateFilter();
        String queryProp = String.join((CharSequence)",", "entryentity.e_datafilterdesc_real", "entryentity.e_datafilterdesc_real_TAG", "entryentity.scheradio", "entryentity.schedraftradio", "entryentity.rowchengtrule", "entryentity.rowticketrule", "entryentity.fundflowitem", "entryentity.transferpost", "entryentity.onekeysche", "iscombine");
        Object[] rules = BusinessDataServiceHelper.load((String)"psd_autoschedule_rule", (String)queryProp, (QFilter[])new QFilter[]{orgF, enableF, effDateFilter});
        if (EmptyUtil.isNoEmpty((Object[])rules)) {
            rule = rules[0];
            DynamicObjectCollection entryEntities = rule.getDynamicObjectCollection("entryentity");
            entryEntities.stream().filter(Objects::nonNull).forEach(dy -> {
                DynamicObject amtRule = dy.getDynamicObject("rowchengtrule");
                DynamicObject defaultAcct = Optional.ofNullable(amtRule).map(o -> o.getDynamicObject("defaultaccount")).orElseGet(() -> null);
                if (null != defaultAcct) {
                    defaultAcct = BusinessDataServiceHelper.loadSingle((Object)defaultAcct.getPkValue(), (String)"psd_defaultaccount");
                    dy.getDynamicObject("rowchengtrule").set("defaultaccount", (Object)defaultAcct);
                }
            });
        } else {
            rules = BusinessDataServiceHelper.load((String)"psd_autoschedule_rule", (String)queryProp, (QFilter[])new QFilter[]{enableF, QFilter.isNull((String)"orgentryentity.org.id"), effDateFilter});
            if (EmptyUtil.isNoEmpty((Object[])rules)) {
                rule = rules[0];
            }
        }
        return rule;
    }

    private List<DynamicObject> getRuleEntry(DynamicObject org, DynamicObject rule) {
        List<DynamicObject> ruleEntry = null;
        if (EmptyUtil.isEmpty((DynamicObject)rule)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u72b6\u6001\u6216\u542f\u7528\u65f6\u95f4\u5185\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"AutoScheHandler_1", (String)"tmc-psd-business", (Object[])new Object[0]), org.getString("name")));
        }
        if (rule != null && !EmptyUtil.isEmpty((DynamicObject)rule)) {
            ruleEntry = rule.getDynamicObjectCollection("entryentity").stream().filter(o -> !this.oneKeySche || o.getBoolean("onekeysche")).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(ruleEntry)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u72b6\u6001\u6216\u542f\u7528\u65f6\u95f4\u5185\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"AutoScheHandler_1", (String)"tmc-psd-business", (Object[])new Object[0]), org.getString("name")));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u72b6\u6001\u6216\u542f\u7528\u65f6\u95f4\u5185\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"AutoScheHandler_1", (String)"tmc-psd-business", (Object[])new Object[0]), org.getString("name")));
        }
        if (EmptyUtil.isEmpty(ruleEntry)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u72b6\u6001\u6216\u542f\u7528\u65f6\u95f4\u5185\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"AutoScheHandler_1", (String)"tmc-psd-business", (Object[])new Object[0]), org.getString("name")));
        }
        return ruleEntry;
    }

    private Set<String> getFilterProperties(List<DynamicObject> ruleEntry) {
        HashSet<String> filterProps = new HashSet<String>();
        if (ruleEntry != null) {
            for (DynamicObject ruleRow : ruleEntry) {
                MainEntityType mainEntityType;
                CRCondition filterObj;
                String baseFilterStr;
                String filterStr = ruleRow.getString("e_datafilterdesc_real_TAG");
                if (!EmptyUtil.isNoEmpty((String)filterStr) || !EmptyUtil.isNotEmpty((CharSequence)(baseFilterStr = (filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class)).buildFullFormula(mainEntityType = MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"))))) continue;
                String[] vars = FormulaEngine.extractVariables((String)baseFilterStr);
                filterProps.addAll(Arrays.asList(vars));
            }
        }
        return filterProps;
    }

    public Map<Long, DynamicObject> getDefaultRules() {
        return this.defaultRules;
    }

    public void setDefaultRules(Map<Long, DynamicObject> defaultRules) {
        this.defaultRules = defaultRules;
    }
}

