/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.check.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.psd.business.service.paysche.check.IPsdDataCheckTask;
import kd.tmc.psd.business.service.paysche.check.utils.DataCheckUtil;

public class PsdPayConsistencyCheckTask
implements IPsdDataCheckTask {
    private static final Log logger = LogFactory.getLog(PsdPayConsistencyCheckTask.class);

    @Override
    public boolean execute() {
        if (DataCheckUtil.isStop()) {
            return false;
        }
        Tuple<Boolean, List<String>> checkResult = this.consistencyCheck();
        if (!((Boolean)checkResult.item1).booleanValue()) {
            String errMsg = ((List)checkResult.item2).stream().filter(Objects::nonNull).collect(Collectors.joining("\r\n"));
            logger.error(errMsg);
            DataCheckUtil.saveResult("psd_consistency_data_check", "psd", false, String.format("%s:\r\n%s", ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u4e00\u81f4\u6027\u68c0\u6d4b\u3002", (String)"PsdPayConsistencyCheckTask_1", (String)"tmc-psd-business", (Object[])new Object[0]), errMsg), "kd.tmc.psd.business.service.paysche.check.impl.PsdPayConsistencyCheckTask");
            return false;
        }
        return true;
    }

    private Tuple<Boolean, List<String>> consistencyCheck() {
        HashSet<String> status = new HashSet<String>(4);
        status.add("noschedule");
        status.add("scheduling");
        status.add("yetschedule");
        status.add("paying");
        QFilter filter = new QFilter("schedulstatus", "in", status);
        filter.and(new QFilter("freezestatus", "=", (Object)"0"));
        DynamicObjectCollection schedulebills = QueryServiceHelper.query((String)"psd_schedulebill", (String)"billno,entrys,entrys.e_payid,entrys.e_payentryid,entrys.e_billtype", (QFilter[])new QFilter[]{filter});
        Set ids = schedulebills.stream().filter(Objects::nonNull).map(o -> o.getLong("entrys.e_payid")).collect(Collectors.toSet());
        DynamicObject[] paybills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        Map relationPayBillMap = Arrays.stream(paybills).filter(Objects::nonNull).collect(Collectors.toMap(o -> Long.valueOf(o.getPkValue().toString()), Function.identity()));
        ArrayList<String> errMsgs = new ArrayList<String>(10);
        boolean consistencyCheck = true;
        for (DynamicObject payscheEntry : schedulebills) {
            Long payBillId = payscheEntry.getLong("entrys.e_payid");
            Long payBillEntryId = payscheEntry.getLong("entrys.e_payentryid");
            String payType = payscheEntry.getString("entrys.e_billtype");
            if (relationPayBillMap.containsKey(payBillId)) {
                DynamicObjectCollection payDetailEntry;
                Set scheIds;
                DynamicObject paybill = (DynamicObject)relationPayBillMap.get(payBillId);
                String error = null;
                boolean iswaitsche = paybill.getBoolean("iswaitsche");
                if ("schebill".equals(payType) && !iswaitsche) {
                    consistencyCheck = false;
                    error = String.format(ResManager.loadKDString((String)"\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4ed8\u6b3e\u6392\u7a0b\u5355\u3010%1$s\u3011\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u3010%2$s\u3011\u4e3a\u975e\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\uff0c\u800c\u5206\u5f55\u4e2d\u6570\u636e\u4e3a\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PsdPayConsistencyCheckTask_3", (String)"tmc-psd-business", (Object[])new Object[0]), payscheEntry.getString("billno"), paybill.getString("billno"));
                } else if ("paybill".equals(payType) && iswaitsche) {
                    error = String.format(ResManager.loadKDString((String)"\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4ed8\u6b3e\u6392\u7a0b\u5355\u3010%1$s\u3011\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u3010%2$s\u3011\u4e3a\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\uff0c\u800c\u5206\u5f55\u4e2d\u6570\u636e\u4e3a\u4ed8\u6b3e\u4e1a\u52a1\u4ed8\u6b3e\u5355\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PsdPayConsistencyCheckTask_4", (String)"tmc-psd-business", (Object[])new Object[0]), payscheEntry.getString("billno"), paybill.getString("billno"));
                    consistencyCheck = false;
                }
                if (error == null && !(scheIds = (payDetailEntry = paybill.getDynamicObjectCollection("entry")).stream().map(o -> o.getLong("id")).collect(Collectors.toSet())).contains(payBillEntryId)) {
                    error = String.format(ResManager.loadKDString((String)"\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4ed8\u6b3e\u6392\u7a0b\u5355\u30101$%s\u3011\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u3010%2$s\u3011\u4e2d\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\u3010%3$s\u3011\u7684\u5206\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PsdPayConsistencyCheckTask_5", (String)"tmc-psd-business", (Object[])new Object[0]), payscheEntry.getString("billno"), paybill.getString("billno"), payBillEntryId);
                    consistencyCheck = false;
                }
                if (error == null) continue;
                errMsgs.add(error);
                continue;
            }
            consistencyCheck = false;
            String error = String.format(ResManager.loadKDString((String)"\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4ed8\u6b3e\u6392\u7a0b\u5355\u3010%1$s\u3011\u7684\u4ed8\u6b3e\u5355\u4fe1\u606f\u5206\u5f55\u4e2d\u3010%2$s\u3011\u6240\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PsdPayConsistencyCheckTask_2", (String)"tmc-psd-business", (Object[])new Object[0]), payscheEntry.getString("billno"), payBillId);
            errMsgs.add(error);
            break;
        }
        return Tuple.create((Object)consistencyCheck, errMsgs);
    }
}

