/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.controller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.controller.PayScheFormOperate;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;
import kd.tmc.psd.business.service.paysche.repo.PayScheDataRepository;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;
import kd.tmc.psd.common.enums.MergeTypeEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.untils.StringUtils;

public abstract class PayScheCalcBaseHandler<T extends SumScheData> {
    protected PayScheDataRepository<T> dataRepository;
    protected IPayScheService payScheService;

    public PayScheCalcBaseHandler(String pageId) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.dataRepository = new PayScheDataRepository(pageId, type);
        this.payScheService = PayScheServiceFactory.getPayScheService();
    }

    protected void initData(List<PayScheCalcModel> dataList) {
        this.dataRepository.clearCurrSumId();
        this.reloadData(dataList);
        new DraftBillLockCache(this.getView().getPageId()).releaseAll();
    }

    protected void reloadData(List<PayScheCalcModel> dataList) {
        Map scaleMap = TmcAmountHelper.getScaleMap(dataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        HashMap<String, BigDecimal> batchScheAmount = new HashMap<String, BigDecimal>(16);
        for (PayScheCalcModel payScheCalcModel : dataList) {
            payScheCalcModel.reCalcBalance((Integer)scaleMap.get(payScheCalcModel.getCurrencyId()));
            this.calSingleAmount(batchScheAmount, payScheCalcModel);
        }
        this.changeMergeAmount(dataList, batchScheAmount);
        List<T> sumDataList = this.getSumScheService().loadSummaryData(dataList);
        this.dataRepository.saveAll(sumDataList, dataList);
        this.getView().updateSummaryInfo(sumDataList, true);
    }

    public void directUpdateDataList(List<PayScheCalcModel> needUpdateDataList) {
        List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
        Map<Long, PayScheCalcModel> scheDataMap = allScheDataList.stream().collect(Collectors.toMap(o -> o.getScheId(), o -> o, (a, b) -> a));
        ArrayList<PayScheCalcModel> newDataList = new ArrayList<PayScheCalcModel>();
        for (PayScheCalcModel needUpdateData : needUpdateDataList) {
            PayScheCalcModel oldScheData = scheDataMap.get(needUpdateData.getScheId());
            if (oldScheData != null) {
                oldScheData.replaceData(needUpdateData);
                continue;
            }
            newDataList.add(needUpdateData);
        }
        allScheDataList.addAll(newDataList);
        this.reloadData(allScheDataList);
    }

    public void directUpdateData(List<PayScheCalcModel> needDeleteDataList) {
        if (EmptyUtil.isNoEmpty(needDeleteDataList)) {
            List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
            allScheDataList = allScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
            Set deleteScheBillNoSet = needDeleteDataList.stream().map(s -> s.getCalcPropVal("e_billno").toString()).collect(Collectors.toSet());
            allScheDataList.removeIf(scheData -> deleteScheBillNoSet.contains(scheData.getCalcPropVal("e_billno").toString()));
            this.reloadData(allScheDataList);
        }
    }

    public void loadScheDataList(Long sumId) {
        this.dataRepository.setCurrSumId(sumId);
        List<PayScheCalcModel> scheDataList = this.dataRepository.getScheDataList(sumId);
        this.getView().updateScheDataList(scheDataList, true);
    }

    public void autoSchedule() {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(ResManager.loadKDString((String)"\u81ea\u52a8\u6392\u7a0b", (String)"PayScheProcessorHandler_01", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public void filterScheData(List<PayScheCalcModel> scheDataList) {
                List needUpdateList = scheDataList.stream().filter(Objects::nonNull).filter(v -> BigDecimal.ZERO.compareTo(v.getScheAmt()) == 0 && BigDecimal.ZERO.compareTo(v.getDraftBillAmt()) == 0 && ScheStatusEnum.SCHEDULING.getValue().equals(v.getScheStatus())).filter(o -> EmptyUtil.isEmpty((String)o.getBatchnum())).filter(o -> EmptyUtil.isEmpty((Long)o.getEntrustPayId())).filter(o -> {
                    Long applySettlementTypeId = o.getApplySettlementTypeId();
                    if (applySettlementTypeId == null) {
                        return true;
                    }
                    DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((Object)applySettlementTypeId, (String)"bd_settlementtype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                        String typeString = settleType.getString("settlementtype");
                        return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
                    }
                    return true;
                }).collect(Collectors.toList());
                scheDataList.clear();
                scheDataList.addAll(needUpdateList);
            }

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.autoSchedule(PayScheCalcBaseHandler.this.getView().getOrgId(), scheDataList, PayScheCalcBaseHandler.this.getView().getPageId());
            }
        });
    }

    public void sumSchedule(Long sumId, final SumScheInfo sumScheInfo) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, ResManager.loadKDString((String)"\u6c47\u603b\u6392\u7a0b", (String)"PayScheProcessorHandler_11", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public void filterScheData(List<PayScheCalcModel> scheDataList) {
                List needUpdateList = scheDataList.stream().filter(v -> ScheStatusEnum.SCHEDULING.getValue().equals(v.getScheStatus())).filter(o -> {
                    Long applySettlementTypeId = o.getApplySettlementTypeId();
                    if (applySettlementTypeId == null) {
                        return true;
                    }
                    DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((Object)applySettlementTypeId, (String)"bd_settlementtype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                        String typeString = settleType.getString("settlementtype");
                        return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
                    }
                    return true;
                }).filter(o -> EmptyUtil.isEmpty((Long)o.getEntrustPayId())).filter(o -> EmptyUtil.isEmpty((String)o.getBatchnum())).collect(Collectors.toList());
                scheDataList.clear();
                scheDataList.addAll(needUpdateList);
            }

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                SumScheData sumData = (SumScheData)sumDataList.get(0);
                sumData.setDimName(sumScheInfo.getName());
                return PayScheCalcBaseHandler.this.payScheService.sumSchedule(PayScheCalcBaseHandler.this.getView().getOrgId(), scheDataList, sumScheInfo, PayScheCalcBaseHandler.this.getView().getPageId());
            }
        });
    }

    public List<Long> updateScheInfo(Long sumId, final List<PayScheCalcModel> payScheDataList, final String pageId, final String changeProp, final boolean isMergerArchive, final BigDecimal draftTransAmounts) {
        List scheIdList = payScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        PayScheProcessResult result = this.doScheFormOperate(new PayScheFormOperate<T, List<Long>>(isMergerArchive, sumId, scheIdList){

            @Override
            public PayScheProcessResult<List<Long>> doOperate(List<T> sumDataList, List<PayScheCalcModel> needUpdateScheDataLst) {
                PayScheProcessorInfo payScheProcessorInfo = PayScheCalcBaseHandler.this.getView().getProcessorInfo();
                payScheProcessorInfo.setPageIdForBids(PayScheCalcBaseHandler.this.getView().getPageId());
                if (!isMergerArchive) {
                    return PayScheCalcBaseHandler.this.payScheService.updateScheData(needUpdateScheDataLst, payScheDataList, payScheProcessorInfo, pageId, draftTransAmounts);
                }
                PayScheCalcBaseHandler.this.dealMergeDraftChg(needUpdateScheDataLst, changeProp, payScheDataList);
                return PayScheCalcBaseHandler.this.payScheService.batchUpdateScheData(needUpdateScheDataLst, payScheDataList, payScheProcessorInfo, pageId, draftTransAmounts);
            }
        });
        return (List)result.getResult();
    }

    private void dealMergeDraftChg(List<PayScheCalcModel> needUpdateScheDataLst, String changeProp, List<PayScheCalcModel> payScheDataList) {
        if (StringUtils.isEmpty((String)changeProp) || !"mergeDraftChg".equals(changeProp)) {
            return;
        }
        Map scheIdToMap = needUpdateScheDataLst.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, Function.identity(), (a, b) -> a));
        for (Map.Entry sche : scheIdToMap.entrySet()) {
            Long scheId = sche.getKey();
            PayScheCalcModel payScheCalcModel = (PayScheCalcModel)sche.getValue();
            for (PayScheCalcModel psc : payScheDataList) {
                List<PayScheDraftInfo> draftInfos;
                Long pscId = psc.getScheId();
                if (pscId.compareTo(scheId) != 0 || (draftInfos = payScheCalcModel.getPayScheDraftInfos()) == null || draftInfos.size() == 0) continue;
                List<PayScheDraftInfo> payScheDraftInfos = psc.getPayScheDraftInfos();
                if (payScheDraftInfos != null && payScheDraftInfos.size() > 0) {
                    payScheDraftInfos.clear();
                } else {
                    payScheDraftInfos = new ArrayList<PayScheDraftInfo>(16);
                }
                payScheDraftInfos.addAll(draftInfos);
                psc.setPayScheDraftInfos(payScheDraftInfos);
                List<Long> draftBillIds = payScheDraftInfos.stream().map(o -> o.getDraftId()).collect(Collectors.toList());
                if (psc.getDraftBillIds() != null) {
                    psc.getDraftBillIds().clear();
                }
                psc.setDraftBillIds(draftBillIds);
            }
        }
    }

    public void autoFillPayInfo(final Long fillId, Long sumId, final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u6279\u91cf\u6392\u6b3e", (String)"PayScheProcessorHandler_15", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.autoFillPayInfo(PayScheCalcBaseHandler.this.getView().getOrgId(), fillId, scheDataList, PayScheCalcBaseHandler.this.getView().getPageId());
            }

            @Override
            void afterDoOpreation(List<PayScheCalcModel> scheCalcModels) {
                super.afterDoOpreation(scheCalcModels);
                List<PayScheCalcModel> virtualPaySches = scheCalcModels.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isArchiveMerger).filter(o -> {
                    Long applySettlementTypeId = o.getApplySettlementTypeId();
                    if (applySettlementTypeId == null) {
                        return true;
                    }
                    DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((Object)applySettlementTypeId, (String)"bd_settlementtype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                        String typeString = settleType.getString("settlementtype");
                        return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
                    }
                    return true;
                }).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(virtualPaySches)) {
                    List batchNums = virtualPaySches.stream().filter(Objects::nonNull).filter(o -> scheIdList.contains(o.getScheId())).map(PayScheCalcModel::getBatchnum).collect(Collectors.toList());
                    for (String batchNum : batchNums) {
                        List<PayScheCalcModel> payScheDataByBatchNum = PayScheCalcBaseHandler.this.dataRepository.getPayScheDataByBatchNum(batchNum);
                        scheCalcModels.addAll(payScheDataByBatchNum);
                    }
                    PayScheProcessorInfo payScheProcessorInfo = PayScheCalcBaseHandler.this.getView().getProcessorInfo();
                    payScheProcessorInfo.setPageIdForBids(PayScheCalcBaseHandler.this.getView().getPageId());
                    PayScheCalcBaseHandler.this.payScheService.batchUpdateScheData(scheCalcModels, virtualPaySches, payScheProcessorInfo, PayScheCalcBaseHandler.this.getView().getPageId(), null);
                }
            }
        });
    }

    public void autoFillTradeBillInfo(final Long fillId, Long sumId, final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u6279\u91cf\u6392\u7968", (String)"PayScheProcessorHandler_16", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.autoFillTradeBillInfo(PayScheCalcBaseHandler.this.getView().getOrgId(), fillId, scheDataList, PayScheCalcBaseHandler.this.getView().getPageId());
            }

            @Override
            void afterDoOpreation(List<PayScheCalcModel> scheCalcModels) {
                super.afterDoOpreation(scheCalcModels);
                List<PayScheCalcModel> virtualPaySches = scheCalcModels.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isArchiveMerger).filter(o -> {
                    Long applySettlementTypeId = o.getApplySettlementTypeId();
                    if (applySettlementTypeId == null) {
                        return true;
                    }
                    DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((Object)applySettlementTypeId, (String)"bd_settlementtype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                        String typeString = settleType.getString("settlementtype");
                        return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
                    }
                    return true;
                }).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(virtualPaySches)) {
                    List batchNums = virtualPaySches.stream().filter(Objects::nonNull).filter(o -> scheIdList.contains(o.getScheId())).map(PayScheCalcModel::getBatchnum).collect(Collectors.toList());
                    for (String batchNum : batchNums) {
                        List<PayScheCalcModel> payScheDataByBatchNum = PayScheCalcBaseHandler.this.dataRepository.getPayScheDataByBatchNum(batchNum);
                        scheCalcModels.addAll(payScheDataByBatchNum);
                    }
                    PayScheProcessorInfo payScheProcessorInfo = PayScheCalcBaseHandler.this.getView().getProcessorInfo();
                    payScheProcessorInfo.setPageIdForBids(PayScheCalcBaseHandler.this.getView().getPageId());
                    PayScheCalcBaseHandler.this.payScheService.batchUpdateScheData(scheCalcModels, virtualPaySches, payScheProcessorInfo, PayScheCalcBaseHandler.this.getView().getPageId(), null);
                }
            }
        });
    }

    public void transToNextPeriod(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u8f6c\u4e0b\u671f", (String)"PayScheProcessorHandler_04", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.transToNextPeriod(scheDataList);
            }
        });
    }

    public void cancelTrans(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u53d6\u6d88\u8f6c\u4e0b\u671f", (String)"PayScheProcessorHandler_05", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.cancelTrans(scheDataList);
            }
        });
    }

    public void refusePay(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u62d2\u4ed8", (String)"PayScheProcessorHandler_06", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.refusePay(scheDataList);
            }
        });
    }

    public void cancelRefusePay(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u53d6\u6d88\u62d2\u4ed8", (String)"PayScheProcessorHandler_07", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            public PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCalcBaseHandler.this.payScheService.cancelRefusePay(scheDataList);
            }
        });
    }

    public List<PayScheCalcModel> getAllScheDataList() {
        return this.dataRepository.getAllScheDataList();
    }

    public List<PayScheCalcModel> getAllCombineDataList(String combineNum) {
        List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
        return allScheDataList.stream().filter(o -> Objects.equals(o.getBatchnum(), combineNum)).collect(Collectors.toList());
    }

    public List<PayScheCalcModel> getAllCombineDataList() {
        List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
        return allScheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).collect(Collectors.toList());
    }

    public void release() {
        this.dataRepository.clearCache();
        DraftBillLockCache cache = new DraftBillLockCache(this.getView().getPageId());
        cache.releaseAll();
    }

    public void clearDraftBillCache() {
        new DraftBillLockCache(this.getView().getPageId()).releaseAll();
    }

    /*
     * WARNING - void declaration
     */
    protected <R> PayScheProcessResult<R> doScheFormOperate(PayScheFormOperate<T, R> operate) {
        ArrayList<PayScheCalcModel> scheOldDataList = new ArrayList(10);
        List<Object> scheSumInfoList = new ArrayList<T>();
        if (operate.isEntireOperate()) {
            Long sumId = operate.getSumId();
            if (sumId != null) {
                scheOldDataList = this.dataRepository.getScheDataList(operate.getSumId());
                scheSumInfoList.add(this.dataRepository.getScheSumInfo(operate.getSumId()));
            } else {
                scheOldDataList = this.dataRepository.getAllScheDataList();
                scheSumInfoList = this.dataRepository.getAllScheSumInfoList();
            }
        } else {
            scheOldDataList = this.dataRepository.getScheDataList(operate.getSumId(), operate.getScheIdList());
            if (Long.valueOf(-1L).compareTo(operate.getSumId()) != 0) {
                scheSumInfoList.add(this.dataRepository.getScheSumInfo(operate.getSumId()));
            }
        }
        operate.beforeDoOpreation(scheOldDataList);
        List<Long> scheIdList = operate.getScheIdList();
        if (operate.isMergerArchive()) {
            List batchNums = scheOldDataList.stream().filter(Objects::nonNull).filter(o -> scheIdList.contains(o.getScheId())).map(PayScheCalcModel::getBatchnum).collect(Collectors.toList());
            for (String batchNum : batchNums) {
                List<PayScheCalcModel> payScheDataByBatchNum = this.dataRepository.getPayScheDataByBatchNum(batchNum);
                scheOldDataList.addAll(payScheDataByBatchNum);
            }
        }
        operate.filterScheData(scheOldDataList);
        List<PayScheCalcModel> needUpdateNewData = scheOldDataList.stream().map(PayScheCalcModel::serialize).map(PayScheCalcModel::deserialize).collect(Collectors.toList());
        PayScheProcessResult<R> result = operate.doOperate(scheSumInfoList, needUpdateNewData);
        operate.afterDoOpreation(needUpdateNewData);
        List<PayScheCalcModel> needDeleteDataList = result.getNeedDeleteDataList();
        if (needDeleteDataList == null) {
            needDeleteDataList = new ArrayList<PayScheCalcModel>();
        }
        needUpdateNewData.removeAll(needDeleteDataList);
        if (result.isSuccess() || result.isStrictValidate()) {
            // empty if block
        }
        if (result.isNeedConfirm()) {
            return result;
        }
        HashMap<String, List<PayScheCalcModel>> mergePaySches = new HashMap<String, List<PayScheCalcModel>>(16);
        HashMap<String, List<PayScheCalcModel>> cancleMergePaySches = new HashMap<String, List<PayScheCalcModel>>(16);
        Map<Long, List<PayScheCalcModel>> updatePayScheMap = needUpdateNewData.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getScheId()));
        for (PayScheCalcModel bakPaySche : scheOldDataList) {
            void var18_29;
            boolean exist;
            Object upBatchNum;
            List<PayScheCalcModel> updatePaySches = updatePayScheMap.get(bakPaySche.getScheId());
            if (updatePaySches == null || updatePaySches.size() <= 0) continue;
            PayScheCalcModel updatePaySche = updatePaySches.get(0);
            String bakBatchNum = Optional.ofNullable(bakPaySche.getBatchnum()).map(o -> o.trim()).orElseGet(() -> "");
            if (bakBatchNum.equals(upBatchNum = Optional.ofNullable(updatePaySche.getBatchnum()).map(o -> o.trim()).orElseGet(() -> ""))) continue;
            if (EmptyUtil.isNoEmpty((String)upBatchNum)) {
                void var18_25;
                exist = mergePaySches.containsKey(upBatchNum);
                Object var18_22 = null;
                if (exist) {
                    List list = (List)mergePaySches.get(upBatchNum);
                } else {
                    ArrayList arrayList = new ArrayList(10);
                }
                var18_25.add(updatePaySche);
                mergePaySches.put((String)upBatchNum, (List<PayScheCalcModel>)var18_25);
                continue;
            }
            exist = cancleMergePaySches.containsKey(bakBatchNum);
            Object var18_26 = null;
            if (exist) {
                List list = (List)cancleMergePaySches.get(bakBatchNum);
            } else {
                ArrayList arrayList = new ArrayList(10);
            }
            var18_29.add(updatePaySche);
            cancleMergePaySches.put(bakBatchNum, (List<PayScheCalcModel>)var18_29);
        }
        ArrayList<PayScheCalcModel> upPaySches = new ArrayList<PayScheCalcModel>(10);
        if (mergePaySches != null && mergePaySches.size() > 0) {
            this.updateVirtMergerPayScheModel(mergePaySches, upPaySches, needDeleteDataList, MergeTypeEnum.MERGE);
        }
        if (cancleMergePaySches != null && cancleMergePaySches.size() > 0) {
            this.updateVirtMergerPayScheModel(cancleMergePaySches, upPaySches, needDeleteDataList, MergeTypeEnum.CANCLE_MERGE);
        }
        if (upPaySches != null && upPaySches.size() > 0) {
            List changeIds = upPaySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toList());
            needUpdateNewData = needUpdateNewData.stream().filter(Objects::nonNull).filter(o -> !changeIds.contains(o.getScheId())).collect(Collectors.toList());
            needUpdateNewData.addAll(upPaySches);
        }
        if (needDeleteDataList != null && needDeleteDataList.size() > 0) {
            Set delIds = needDeleteDataList.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
            List tureUpPaySches = needUpdateNewData.stream().filter(Objects::nonNull).filter(o -> !delIds.contains(o.getScheId())).collect(Collectors.toList());
            needUpdateNewData.clear();
            needUpdateNewData.addAll(tureUpPaySches);
        }
        Map scaleMap = TmcAmountHelper.getScaleMap(needUpdateNewData.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        ArrayList<String> updateProps = new ArrayList<String>(10);
        updateProps.add("e_fundflowitem");
        updateProps.add("e_department");
        updateProps.add("e_project");
        ArrayList<PayScheCalcModel> waitUpVirPaySches = new ArrayList<PayScheCalcModel>(10);
        HashMap<String, BigDecimal> batchScheAmount = new HashMap<String, BigDecimal>(16);
        for (PayScheCalcModel scheData : needUpdateNewData) {
            scheData.reCalcBalance((Integer)scaleMap.get(scheData.getCurrencyId()));
            if (scheIdList != null && scheIdList.contains(scheData.getScheId()) && scheData.isMasterData()) {
                void var19_38;
                Optional<PayScheCalcModel> optional = needUpdateNewData.stream().filter(PayScheCalcModel::isArchiveMerger).filter(o -> scheData.getBatchnum().equals(o.getBatchnum())).findFirst();
                Object var19_39 = null;
                if (optional.isPresent()) {
                    PayScheCalcModel payScheCalcModel = optional.get();
                } else {
                    PayScheCalcModel payScheCalcModel = this.dataRepository.getVirtualPaySche(-1L, scheData.getBatchnum());
                }
                if (var19_38 != null) {
                    var19_38.updateData(scheData, updateProps);
                    waitUpVirPaySches.add((PayScheCalcModel)var19_38);
                }
            }
            this.calSingleAmount(batchScheAmount, scheData);
        }
        this.changeMergeAmount(needUpdateNewData, batchScheAmount);
        this.addNewPaySches(needUpdateNewData, waitUpVirPaySches);
        this.getSumScheService().calculateSumInfo(scheSumInfoList, scheOldDataList, needUpdateNewData, needDeleteDataList);
        operate.updateCacheBeforeOpreation(needUpdateNewData);
        Map<Long, List<PayScheCalcModel>> sumIdMap = needUpdateNewData.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : sumIdMap.entrySet()) {
            Long l = entry.getKey();
            ArrayList<PayScheCalcModel> needUpdateScheDataList = new ArrayList<PayScheCalcModel>((Collection)entry.getValue());
            List<PayScheCalcModel> needInsertDataList = needUpdateScheDataList.stream().filter(PayScheCalcModel::isNewScheData).collect(Collectors.toList());
            if (needInsertDataList.size() > 0) {
                List<PayScheCalcModel> realInsertDataList = this.dataRepository.isNewScheData(l, needInsertDataList);
                Set realInsertDataIdSet = realInsertDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
                for (PayScheCalcModel payScheCalcModel : needInsertDataList) {
                    if (!realInsertDataIdSet.contains(payScheCalcModel.getScheId())) continue;
                    needUpdateScheDataList.remove(payScheCalcModel);
                }
                if (realInsertDataList.size() > 0) {
                    this.dataRepository.insertScheDataList(l, realInsertDataList);
                }
            }
            if (needUpdateScheDataList.size() <= 0) continue;
            this.dataRepository.updateScheDataList(l, needUpdateScheDataList);
        }
        if (needDeleteDataList.size() > 0) {
            Map<Long, List<PayScheCalcModel>> needDeleteDataMap = needDeleteDataList.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
            for (Map.Entry<Long, List<PayScheCalcModel>> entry : needDeleteDataMap.entrySet()) {
                this.dataRepository.removeScheDataList(entry.getKey(), entry.getValue().stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList()));
            }
        }
        if (result.isReload()) {
            List<PayScheCalcModel> reloadScheDataList = this.dataRepository.getAllScheDataList();
            List<T> list = this.getSumScheService().rebuildSummaryData(reloadScheDataList);
            this.dataRepository.saveAll(list, reloadScheDataList);
            this.dataRepository.clearCurrSumId();
            this.getView().updateSummaryInfo(list, true);
            if (list.size() == 0) {
                this.getView().updateScheDataList(new ArrayList<PayScheCalcModel>(), true);
            }
        } else {
            if (scheSumInfoList.size() > 0) {
                this.dataRepository.updateScheSumInfo(scheSumInfoList);
                this.getView().updateSummaryInfo(scheSumInfoList, false);
            }
            if (operate.isEntireOperate()) {
                Long sumId = operate.getSumId();
                if (sumId == null) {
                    sumId = this.dataRepository.getCurrSumId();
                }
                if (sumId != null) {
                    ArrayList<PayScheCalcModel> arrayList = new ArrayList<PayScheCalcModel>();
                    for (PayScheCalcModel needUpdateData : needUpdateNewData) {
                        if (!needUpdateData.getSummaryId().equals(sumId)) continue;
                        arrayList.add(needUpdateData);
                    }
                    if (arrayList.size() > 0) {
                        this.getView().updateScheDataList(arrayList, false);
                    }
                }
            } else if (needUpdateNewData.size() > 0) {
                this.getView().updateScheDataList(needUpdateNewData, false);
            }
            if (needDeleteDataList.size() > 0) {
                this.getView().deleteScheData(needDeleteDataList);
            }
        }
        if (!result.isSuccess()) {
            this.getView().showErrorMessage(result.getErrMsgList());
        } else if (operate.getOpName() != null) {
            this.getView().showSuccessMessage(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u6210\u529f", (String)"PayScheProcessorHandler_08", (String)"tmc-psd-business", (Object[])new Object[0]), operate.getOpName()));
        }
        return result;
    }

    public void freeze(Long sumId, List<Long> scheIdList, final boolean isRemove, final boolean isMegerArchivePaySche) {
        scheIdList = scheIdList.stream().distinct().collect(Collectors.toList());
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u51bb\u7ed3", (String)"PayScheProcessorHandler_13", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            void beforeDoOpreation(List<PayScheCalcModel> scheDataList) {
                super.beforeDoOpreation(scheDataList);
                if (isMegerArchivePaySche) {
                    List<PayScheCalcModel> needFreezeVirPaySches = PayScheCalcBaseHandler.this.dataRepository.getScheDataList(-1L, this.getScheIdList());
                    scheDataList.addAll(needFreezeVirPaySches);
                    this.getScheIdList().addAll(this.getScheIdList());
                    for (PayScheCalcModel needFreezeVirPaySch : needFreezeVirPaySches) {
                        String batchnum = needFreezeVirPaySch.getBatchnum();
                        List<PayScheCalcModel> linkBatchNumPayScheLst = PayScheCalcBaseHandler.this.dataRepository.getPayScheDataByBatchNum(batchnum);
                        List linkIds = linkBatchNumPayScheLst.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
                        scheDataList.addAll(linkBatchNumPayScheLst);
                        this.getScheIdList().addAll(linkIds);
                    }
                }
            }

            @Override
            PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                if (!isMegerArchivePaySche) {
                    scheDataList = scheDataList.stream().filter(o -> {
                        String batchNum = o.getBatchnum();
                        return !isRemove || !StringUtils.isNotEmpty((String)batchNum);
                    }).collect(Collectors.toList());
                }
                scheDataList = scheDataList.stream().distinct().collect(Collectors.toList());
                PayScheProcessResult<Void> result = PayScheCalcBaseHandler.this.payScheService.freeze(scheDataList, PayScheCalcBaseHandler.this.getView().getPageId());
                return result;
            }
        });
    }

    public void thaw(Long sumId, List<Long> scheIdList, final Date userExpectDate, final boolean isMegerArchivePaySche) {
        this.doScheFormOperate(new PayScheFormOperate<T, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u89e3\u51bb", (String)"PayScheProcessorHandler_14", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            void beforeDoOpreation(List<PayScheCalcModel> scheDataList) {
                super.beforeDoOpreation(scheDataList);
                if (isMegerArchivePaySche) {
                    List<PayScheCalcModel> needFreezeVirPaySches = PayScheCalcBaseHandler.this.dataRepository.getScheDataList(-1L, this.getScheIdList());
                    scheDataList.addAll(needFreezeVirPaySches);
                    this.getScheIdList().addAll(this.getScheIdList());
                    for (PayScheCalcModel needFreezeVirPaySch : needFreezeVirPaySches) {
                        String batchnum = needFreezeVirPaySch.getBatchnum();
                        List<PayScheCalcModel> linkBatchNumPayScheLst = PayScheCalcBaseHandler.this.dataRepository.getPayScheDataByBatchNum(batchnum);
                        List linkIds = linkBatchNumPayScheLst.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
                        scheDataList.addAll(linkBatchNumPayScheLst);
                        this.getScheIdList().addAll(linkIds);
                    }
                }
            }

            @Override
            PayScheProcessResult<Void> doOperate(List<T> sumDataList, List<PayScheCalcModel> scheDataList) {
                for (PayScheCalcModel scheData : scheDataList) {
                    Date expectDate = scheData.getExpectDate();
                    Date currentDate = new Date(System.currentTimeMillis());
                    if (expectDate != null && Long.compare(expectDate.getTime(), currentDate.getTime()) >= 0 || userExpectDate == null) continue;
                    scheData.setExpectDate(userExpectDate);
                }
                PayScheProcessResult<Void> result = PayScheCalcBaseHandler.this.payScheService.thaw(scheDataList);
                return result;
            }
        });
    }

    private void updateVirtMergerPayScheModel(Map<String, List<PayScheCalcModel>> scheDataMap, List<PayScheCalcModel> upPaySches, List<PayScheCalcModel> deletePaySches, MergeTypeEnum mergeType) {
        for (Map.Entry<String, List<PayScheCalcModel>> combinePayScheEntry : scheDataMap.entrySet()) {
            String batchnum = combinePayScheEntry.getKey();
            List<PayScheCalcModel> paySches = combinePayScheEntry.getValue();
            PayScheCalcModel virPaySche = null;
            if (MergeTypeEnum.MERGE == mergeType) {
                virPaySche = this.dataRepository.getVirtualPaySche(-1L, batchnum);
                if (virPaySche == null) {
                    virPaySche = PayScheCalcModel.createVirtualPaySche(paySches, false);
                } else {
                    BigDecimal applyAmtTotal = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getApplyAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
                    applyAmtTotal = applyAmtTotal.add(virPaySche.getApplyAmt());
                    virPaySche.setApplyAmt(applyAmtTotal);
                    int oldMergerCnt = virPaySche.getMergerCnt() != null ? virPaySche.getMergerCnt() : 0;
                    virPaySche.setMergerCnt(oldMergerCnt + paySches.size());
                }
                upPaySches.add(virPaySche);
                continue;
            }
            if (MergeTypeEnum.CANCLE_MERGE != mergeType) continue;
            Optional<PayScheCalcModel> existArchiveMegerData = paySches.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isArchiveMerger).findAny();
            if (existArchiveMegerData.isPresent()) {
                virPaySche = existArchiveMegerData.get();
                List<PayScheCalcModel> payScheByBatchNums = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                for (PayScheCalcModel payScheByBatchNum : payScheByBatchNums) {
                    payScheByBatchNum.setBatchnum(null);
                    payScheByBatchNum.setMasterDataId(null);
                    payScheByBatchNum.setArchiveMerger(false);
                    payScheByBatchNum.setMasterData(false);
                }
                upPaySches.addAll(payScheByBatchNums);
                deletePaySches.add(virPaySche);
                continue;
            }
            virPaySche = this.dataRepository.getVirtualPaySche(-1L, batchnum);
            String tips = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u5e76\u6279\u6b21\u53f7\u201c%s\u201d\u5bf9\u5e94\u7684\u865a\u62df\u5408\u5e76\u6392\u7a0b\u5355\u6570\u636e\u3002", (String)"PayScheCalcBaseHandler_01", (String)"tmc-psd-business", (Object[])new Object[0]);
            if (virPaySche == null) {
                throw new KDBizException(String.format(tips, batchnum));
            }
            Integer mergerCnt = virPaySche.getMergerCnt();
            Integer currCnt = mergerCnt - paySches.size();
            if (currCnt == 0 || currCnt == 1) {
                deletePaySches.add(virPaySche);
                List<PayScheCalcModel> payScheDataByBatchNum = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                for (PayScheCalcModel payScheCalcModel : payScheDataByBatchNum) {
                    payScheCalcModel.setMasterData(false);
                    payScheCalcModel.setArchiveMerger(false);
                    payScheCalcModel.setBatchnum(null);
                    payScheCalcModel.setMasterDataId(null);
                }
                upPaySches.addAll(payScheDataByBatchNum);
                continue;
            }
            BigDecimal applyAmtTotal = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getApplyAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            applyAmtTotal = virPaySche.getApplyAmt().subtract(applyAmtTotal);
            virPaySche.setApplyAmt(applyAmtTotal);
            virPaySche.setMergerCnt(currCnt);
            Optional<PayScheCalcModel> any = paySches.stream().filter(Objects::nonNull).filter(o -> o.isMasterData()).findAny();
            if (any.isPresent()) {
                PayScheCalcModel consumer = any.get();
                consumer.setMasterData(false);
                consumer.setMasterDataId(null);
                upPaySches.add(consumer);
                List<PayScheCalcModel> payScheByBatchNums = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                Set removePayScheIds = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
                List remainPaySches = payScheByBatchNums.stream().filter(Objects::nonNull).filter(o -> !removePayScheIds.contains(o.getScheId())).collect(Collectors.toList());
                PayScheCalcModel masterPaySche = (PayScheCalcModel)remainPaySches.get(0);
                masterPaySche.setMasterData(true);
                masterPaySche.setMasterDataId(virPaySche.getMasterDataId());
                upPaySches.add(masterPaySche);
            }
            upPaySches.add(virPaySche);
        }
    }

    protected abstract IPayScheProcessorView<T> getView();

    protected abstract ISumScheService<T> getSumScheService();

    private void addNewPaySches(List<PayScheCalcModel> originPaySches, List<PayScheCalcModel> newPaySches) {
        List changeIds = newPaySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        originPaySches = originPaySches.stream().filter(Objects::nonNull).filter(o -> !changeIds.contains(o.getScheId())).collect(Collectors.toList());
        originPaySches.addAll(newPaySches);
    }

    private void calSingleAmount(Map<String, BigDecimal> batchScheAmount, PayScheCalcModel payScheCalcModel) {
        if (!this.isDiffCurrency(payScheCalcModel)) {
            return;
        }
        String batchNum = payScheCalcModel.getBatchnum();
        if (!payScheCalcModel.isArchiveMerger() && StringUtils.isNotEmpty((String)batchNum)) {
            BigDecimal amount = batchScheAmount.get(batchNum);
            if (amount == null) {
                amount = BigDecimal.ZERO;
            }
            amount = amount.add(payScheCalcModel.getScheBalance());
            batchScheAmount.put(batchNum, amount);
        }
    }

    private boolean isDiffCurrency(PayScheCalcModel payScheCalcModel) {
        return payScheCalcModel.getApplyCurrencyId().compareTo(payScheCalcModel.getCurrencyId()) != 0;
    }

    private void changeMergeAmount(List<PayScheCalcModel> needUpdateNewData, Map<String, BigDecimal> batchScheAmount) {
        if (batchScheAmount == null || batchScheAmount.size() == 0) {
            return;
        }
        for (PayScheCalcModel scheData : needUpdateNewData) {
            String batchNum;
            BigDecimal amount;
            if (!scheData.isArchiveMerger() || (amount = batchScheAmount.get(batchNum = scheData.getBatchnum())) == null) continue;
            scheData.setScheBalance(amount);
        }
    }
}

