/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheFormOperate;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSplitSumData;
import kd.tmc.psd.business.service.paysche.service.impl.SplitSumScheService;
import org.apache.commons.collections4.CollectionUtils;

public class PayScheSplitHandler
extends PayScheCalcBaseHandler<PayScheSplitSumData> {
    private SplitSumScheService splitSumScheService;
    private IPayScheProcessorView<PayScheSplitSumData> view;
    private PayScheCalcModel originData;

    public PayScheSplitHandler(IPayScheProcessorView<PayScheSplitSumData> view, PayScheCalcModel originData) {
        super(view.getPageId());
        this.view = view;
        this.originData = originData;
        this.splitSumScheService = new SplitSumScheService(originData);
    }

    public void initSplitData() {
        PayScheProcessResult<PayScheCalcModel> result = this.payScheService.createSplitOriginData(this.originData);
        if (result.isSuccess()) {
            this.initData(new ArrayList<PayScheCalcModel>(Collections.singletonList(result.getResult())));
            this.loadScheDataList(0L);
        } else {
            this.view.showErrorMessage(result.getErrMsgList());
        }
    }

    public boolean validateSplitInfo() {
        List<PayScheCalcModel> combineDataList = this.getAllScheDataList();
        boolean isAmtZero = false;
        boolean hasDiffSymbol = false;
        BigDecimal splitAmtSum = BigDecimal.ZERO;
        for (PayScheCalcModel calcModel : combineDataList) {
            BigDecimal applyAmt = calcModel.getApplyAmt();
            if (BigDecimal.ZERO.compareTo(applyAmt) == 0) {
                isAmtZero = true;
            }
            if (applyAmt.multiply(this.originData.getApplyAmt()).compareTo(BigDecimal.ZERO) < 0) {
                hasDiffSymbol = true;
            }
            splitAmtSum = splitAmtSum.add(applyAmt);
        }
        boolean isBalanceZero = splitAmtSum.compareTo(this.originData.getApplyAmt()) == 0;
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (!isBalanceZero) {
            errMsgList.add(ResManager.loadKDString((String)"\u62c6\u5206\u4f59\u989d\u4e0d\u4e3a0", (String)"PayScheSplitHandler_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (isAmtZero) {
            errMsgList.add(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u636e\u4e2d\uff0c\u62c6\u5206\u91d1\u989d\u4e0d\u53ef\u4e3a0\u3002", (String)"PayScheSplitHandler_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (hasDiffSymbol) {
            errMsgList.add(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u636e\u4e2d\uff0c\u62c6\u5206\u91d1\u989d\u5e94\u4e0e\u539f\u7533\u8bf7\u91d1\u989d\u7b26\u53f7\u76f8\u540c\u3002", (String)"PayScheSplitHandler_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (errMsgList.size() > 0) {
            this.view.showErrorMessage(errMsgList);
            return false;
        }
        return true;
    }

    public void insertSplitData() {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSplitSumData, PayScheCalcModel>(Long.valueOf(0L), ResManager.loadKDString((String)"\u65b0\u589e\u62c6\u5206\u884c", (String)"PayScheSplitHandler_3", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<PayScheCalcModel> doOperate(List<PayScheSplitSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                PayScheProcessResult<PayScheCalcModel> splitResult = PayScheSplitHandler.this.payScheService.split(PayScheSplitHandler.this.originData);
                if (splitResult.isSuccess()) {
                    scheDataList.add(splitResult.getResult());
                } else {
                    PayScheSplitHandler.this.getView().showErrorMessage(splitResult.getErrMsgList());
                }
                return splitResult;
            }
        });
    }

    public void batchInsertSplitData(final List<BigDecimal> needInsertAmtList) {
        if (CollectionUtils.isEmpty(needInsertAmtList)) {
            return;
        }
        this.doScheFormOperate(new PayScheFormOperate<PayScheSplitSumData, PayScheCalcModel>(Long.valueOf(0L), (String)null){

            @Override
            PayScheProcessResult<PayScheCalcModel> doOperate(List<PayScheSplitSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                ArrayList<PayScheCalcModel> successList = new ArrayList<PayScheCalcModel>(needInsertAmtList.size());
                PayScheCalcModel resultData = null;
                for (BigDecimal insertAmt : needInsertAmtList) {
                    PayScheProcessResult<PayScheCalcModel> splitResult = PayScheSplitHandler.this.payScheService.split(PayScheSplitHandler.this.originData, insertAmt);
                    if (splitResult.isSuccess()) {
                        successList.add(splitResult.getResult());
                        scheDataList.add(splitResult.getResult());
                        if (resultData != null) continue;
                        resultData = splitResult.getResult();
                        continue;
                    }
                    splitResult.setNeedDeleteDataList(successList);
                    return splitResult;
                }
                return new PayScheProcessResult<Object>(resultData);
            }
        });
    }

    public void deleteSplitData(final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSplitSumData, Void>(Long.valueOf(0L), ResManager.loadKDString((String)"\u5220\u9664\u62c6\u5206\u884c", (String)"PayScheSplitHandler_4", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheSplitSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                PayScheProcessResult<Void> result = new PayScheProcessResult<Void>();
                List<PayScheCalcModel> waitRemoveDataList = scheDataList.stream().filter(o -> scheIdList.contains(o.getScheId())).collect(Collectors.toList());
                boolean isContainOriginData = waitRemoveDataList.stream().anyMatch(o -> PayScheSplitHandler.this.originData.getScheId().equals(o.getScheId()));
                if (isContainOriginData) {
                    result.addErrorMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u7b2c\u4e00\u884c\u6570\u636e(\u62c6\u5206\u6e90\u5355)\u3002", (String)"PayScheSplitHandler_5", (String)"tmc-psd-business", (Object[])new Object[0]));
                } else if (scheDataList.size() == waitRemoveDataList.size()) {
                    result.addErrorMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u5168\u90e8\u6570\u636e\u3002", (String)"PayScheSplitHandler_6", (String)"tmc-psd-business", (Object[])new Object[0]));
                } else {
                    result.setNeedDeleteDataList(waitRemoveDataList);
                }
                return result;
            }
        });
    }

    @Override
    protected IPayScheProcessorView<PayScheSplitSumData> getView() {
        return this.view;
    }

    @Override
    protected ISumScheService<PayScheSplitSumData> getSumScheService() {
        return this.splitSumScheService;
    }
}

