/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PaySchePropVal;
import kd.tmc.psd.business.service.paysche.data.config.PayScheConfigData;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheDataTransfer {
    private static Log logger = LogFactory.getLog(PayScheDataTransfer.class);
    private List<PayScheConfigData> psdConfigDataList = PayScheConfigData.load();

    public List<PayScheCalcModel> transScheDataToCalcModelList(List<DynamicObject> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PayScheCalcModel> modelList = new ArrayList<PayScheCalcModel>(10);
        for (DynamicObject data : dataList) {
            PayScheCalcModel calcModel = this.transDataToCalcModel(data);
            modelList.add(calcModel);
        }
        return modelList;
    }

    public PayScheCalcModel transDataToCalcModel(DynamicObject data) {
        DynamicObjectCollection entries;
        HashMap<String, PaySchePropVal> dataMap = new HashMap<String, PaySchePropVal>(10);
        PayScheCalcModel calcModel = new PayScheCalcModel(dataMap);
        DynamicObjectType objectType = data.getDynamicObjectType();
        for (PayScheConfigData configData : this.psdConfigDataList) {
            String scheCalcProp = configData.getScheCalcProp();
            String scheBillProp = configData.getScheBillProp();
            boolean editable = configData.isEditable();
            boolean unique = configData.isUnique();
            PaySchePropVal propVal = new PaySchePropVal();
            propVal.setScheCalcProp(scheCalcProp);
            propVal.setScheProp(scheBillProp);
            propVal.setEditable(editable);
            propVal.setCombineUnique(unique);
            propVal.setPayScheDataSetting(configData.getPayScheDataSetting());
            DynamicProperty prop = null;
            if ("psd_schedulebill".equals(objectType.getName())) {
                if (EmptyUtil.isNotEmpty((CharSequence)scheBillProp)) {
                    prop = objectType.getProperty(scheBillProp);
                }
            } else {
                prop = objectType.getProperty(scheCalcProp);
            }
            if (prop != null) {
                this.setPropVal(propVal, prop, prop.getValue((Object)data));
            }
            dataMap.put(scheCalcProp, propVal);
        }
        if ("psd_schedulebill".equals(objectType.getName())) {
            calcModel.setScheId((Long)data.getPkValue());
            calcModel.initPayScheDraftInfo(data.getDynamicObjectCollection("draftinfoentry"));
        } else {
            calcModel.setScheId(data.getLong("e_id"));
        }
        if (data.containsProperty("entrys") && (entries = data.getDynamicObjectCollection("entrys")) != null && entries.size() > 0) {
            DynamicObject entry = (DynamicObject)entries.get(0);
            long payBillId = entry.getLong("e_payid");
            calcModel.setPayBillId(payBillId);
        }
        return calcModel;
    }

    private void setPropVal(PaySchePropVal propVal, DynamicProperty prop, Object val) {
        if (val != null) {
            if (prop instanceof BasedataProp) {
                DynamicObject baseDataVal = (DynamicObject)val;
                val = baseDataVal.getPkValue();
            } else if (prop instanceof MulBasedataProp) {
                DynamicObjectCollection multiBaseDataVal = (DynamicObjectCollection)val;
                val = multiBaseDataVal.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            }
            propVal.setData(val);
        } else {
            propVal.setData(null);
        }
    }

    public void transCalcModelPropsToPayScheData(List<DynamicObject> scheDataList, List<PayScheCalcModel> calcModelList, Map<String, PayScheCalcModel> mergeData) {
        PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(calcModelList);
        Map<Object, DynamicObject> scheDataMap = scheDataList.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (a, b) -> a));
        for (PayScheCalcModel calcModel : calcModelList) {
            Long scheId = calcModel.getScheId();
            DynamicObject scheData = scheDataMap.get(scheId);
            if (scheData == null) continue;
            this.transCalcModelPropsToPayScheData(scheData, calcModel, dataProvider, mergeData);
        }
    }

    public void transCalcModelPropsToPayScheData(DynamicObject scheData, PayScheCalcModel calcModel, PayScheBaseDataProvider dataProvider, Map<String, PayScheCalcModel> mergeData) {
        for (PaySchePropVal propVal : calcModel.getDataMap().values()) {
            String entityType;
            String propName = propVal.getScheProp();
            if (EmptyUtil.isEmpty((String)propName)) continue;
            DynamicProperty prop = dataProvider.getCalcEntryProp().getProperty(propVal.getScheCalcProp());
            if (prop instanceof BasedataProp) {
                logger.info("{} \u4e3a\u57fa\u7840\u6570\u636e\u7c7b\u578b\u3002", (Object)prop);
                entityType = prop instanceof ItemClassProp ? (String)calcModel.getCalcPropVal(((ItemClassProp)prop).getTypePropName()) : ((BasedataProp)prop).getBaseEntityId();
                entityType = StringUtils.checkEntityType((String)entityType, (String)"cas_recbill_f7", (String)"cas_recbill");
                DynamicObject baseDataVal = dataProvider.getBaseData(entityType, propVal.getData());
                scheData.set(propName, (Object)baseDataVal);
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                logger.info("{} \u4e3a\u591a\u57fa\u7840\u6570\u636e\u7c7b\u578b\u3002", (Object)prop);
                entityType = ((MulBasedataProp)prop).getBaseEntityId();
                List<DynamicObject> baseDataList = dataProvider.getMultiBaseData(entityType, (List)propVal.getData());
                if (baseDataList.size() > 0) {
                    DynamicObjectCollection multiPropVal = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)scheData, (String)propName, (DynamicObject[])baseDataList.toArray(new DynamicObject[0]));
                    scheData.set(propName, (Object)multiPropVal);
                    continue;
                }
                scheData.set(propName, null);
                continue;
            }
            scheData.set(propName, propVal.getData());
        }
        List<PayScheDraftInfo> payScheDraftInfos = calcModel.getPayScheDraftInfos();
        payScheDraftInfos = this.getPayScheDraftInfos(scheData, calcModel, dataProvider, mergeData, payScheDraftInfos);
        DynamicObjectCollection draftinfoEntryCol = scheData.getDynamicObjectCollection("draftinfoentry");
        draftinfoEntryCol.clear();
        if (EmptyUtil.isNoEmpty(payScheDraftInfos)) {
            for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfos) {
                DynamicObject dynamicObject = draftinfoEntryCol.addNew();
                dynamicObject.set("de_draftinfo", (Object)payScheDraftInfo.getDraftId());
                dynamicObject.set("de_transferamt", (Object)payScheDraftInfo.getTransferAmt());
                dynamicObject.set("de_draftlogid", (Object)payScheDraftInfo.getDraftLogId());
            }
        }
    }

    private List<PayScheDraftInfo> getPayScheDraftInfos(DynamicObject scheData, PayScheCalcModel calcModel, PayScheBaseDataProvider dataProvider, Map<String, PayScheCalcModel> mergeData, List<PayScheDraftInfo> payScheDraftInfos) {
        String batchNum = calcModel.getBatchnum();
        if (StringUtils.isEmpty((String)batchNum)) {
            return payScheDraftInfos;
        }
        PayScheCalcModel payScheCalcModel = mergeData.get(batchNum);
        if (payScheCalcModel == null) {
            return payScheDraftInfos;
        }
        List<PayScheDraftInfo> draftInfos = payScheCalcModel.getPayScheDraftInfos();
        if (draftInfos == null || draftInfos.size() == 0) {
            return payScheDraftInfos;
        }
        Set draftIds = draftInfos.stream().map(o -> o.getDraftId()).collect(Collectors.toSet());
        DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        if (drafts.length > 0) {
            DynamicObjectCollection multiPropVal = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)scheData, (String)"draftno", (DynamicObject[])drafts);
            scheData.set("draftno", (Object)multiPropVal);
        }
        return draftInfos;
    }

    public void transCalcModelToCalcEntry(IDataModel dataModel, PayScheCalcModel calcModel, int rowIndex, boolean onlyForMulBaseData) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        DynamicObjectType entityType = entryEntity.getDynamicObjectType();
        Map<String, PaySchePropVal> dataMap = calcModel.getDataMap();
        ArrayList<PaySchePropVal> propValList = new ArrayList<PaySchePropVal>(dataMap.values());
        propValList.sort((o1, o2) -> {
            int sort1 = 0;
            int sort2 = 0;
            DynamicProperty prop1 = entityType.getProperty(o1.getScheCalcProp());
            DynamicProperty prop2 = entityType.getProperty(o2.getScheCalcProp());
            if (prop1 instanceof BasedataProp || prop1 instanceof MulBasedataProp) {
                sort1 = 100;
            }
            if (prop2 instanceof BasedataProp || prop2 instanceof MulBasedataProp) {
                sort2 = 100;
            }
            return sort1 - sort2;
        });
        for (PaySchePropVal propVal : propValList) {
            String propName = propVal.getScheCalcProp();
            Object val = propVal.getData();
            DynamicProperty property = entityType.getProperty(propName);
            if (property instanceof MulBasedataProp) {
                List valList = (List)val;
                if (valList != null && valList.size() > 0) {
                    dataModel.setValue(propName, (Object)valList.toArray(), rowIndex);
                    continue;
                }
                dataModel.setValue(propName, null, rowIndex);
                continue;
            }
            if (onlyForMulBaseData) continue;
            try {
                dataModel.setValue(propName, val, rowIndex);
            }
            catch (Exception e) {
                logger.info("error:", (Object)e);
            }
        }
    }

    public List<Map<String, Object>> transCalcModelToCalcEntry(IDataModel dataModel, List<PayScheCalcModel> calcModelList) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        DynamicObjectType entityType = entryEntity.getDynamicObjectType();
        return calcModelList.stream().map(o -> {
            HashMap dataMap = new HashMap();
            for (PaySchePropVal propVal : o.getDataMap().values()) {
                DynamicProperty prop = entityType.getProperty(propVal.getScheCalcProp());
                if (prop instanceof MulBasedataProp) continue;
                dataMap.put(propVal.getScheCalcProp(), propVal.getData());
            }
            return dataMap;
        }).collect(Collectors.toList());
    }
}

