/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.data.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PayScheConfigData {
    private String scheCalcProp;
    private String scheBillProp;
    private boolean editable;
    private boolean unique;
    private boolean combineControl;
    private String payScheDataSetting;

    public static List<PayScheConfigData> load() {
        DynamicObjectCollection psdConfigDataList = QueryServiceHelper.query((String)"psd_dataconfig", (String)String.join((CharSequence)",", "schecalcprop", "schebillprop", "editable", "combineunique", "combinecontrol", "payschedataset"), (QFilter[])new QFilter[0]);
        ArrayList<PayScheConfigData> configList = new ArrayList<PayScheConfigData>();
        for (DynamicObject configData : psdConfigDataList) {
            String scheCalcProp = configData.getString("schecalcprop");
            String scheBillProp = configData.getString("schebillprop");
            boolean editable = configData.getBoolean("editable");
            boolean unique = configData.getBoolean("combineunique");
            boolean combineControl = configData.getBoolean("combinecontrol");
            String payScheDataSetting = configData.getString("payschedataset");
            PayScheConfigData config = new PayScheConfigData();
            config.setScheCalcProp(scheCalcProp);
            config.setScheBillProp(scheBillProp);
            config.setEditable(editable);
            config.setUnique(unique);
            config.setCombineControl(combineControl);
            config.setPayScheDataSetting(payScheDataSetting);
            configList.add(config);
        }
        return configList;
    }

    public static List<String> getUniqueCalcProps(List<PayScheConfigData> configList) {
        return configList.stream().filter(PayScheConfigData::isUnique).map(PayScheConfigData::getScheCalcProp).collect(Collectors.toList());
    }

    public static List<String> getCombineCtlCalcProps(List<PayScheConfigData> configList) {
        return configList.stream().filter(PayScheConfigData::isCombineControl).map(PayScheConfigData::getScheCalcProp).collect(Collectors.toList());
    }

    public String getScheCalcProp() {
        return this.scheCalcProp;
    }

    public void setScheCalcProp(String scheCalcProp) {
        this.scheCalcProp = scheCalcProp;
    }

    public String getScheBillProp() {
        return this.scheBillProp;
    }

    public void setScheBillProp(String scheBillProp) {
        this.scheBillProp = scheBillProp;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isCombineControl() {
        return this.combineControl;
    }

    public void setCombineControl(boolean combineControl) {
        this.combineControl = combineControl;
    }

    public String getPayScheDataSetting() {
        return this.payScheDataSetting;
    }

    public void setPayScheDataSetting(String payScheDataSetting) {
        this.payScheDataSetting = payScheDataSetting;
    }
}

