/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.tmc.psd.extpoint.task.IAssemblySecondaryDevFields;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockInfo;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.data.LogBizStatusEnum;
import kd.tmc.psd.business.service.paysche.data.LogOperateTypeEnum;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.ChargeBackInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PaySchePayInfo;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.business.service.paysche.sumsche.data.PrimeRuleVal;
import kd.tmc.psd.common.enums.PsdEffectEleEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheHelper {
    private static Log logger = LogFactory.getLog(PayScheHelper.class);
    private static final String SELECT_FIELDS = "id, arrivalno, lockamount,entrys,entrys.payid,entrys.payno,entrys.operatetype";

    @Deprecated
    public static QFilter getChooseDraftQFilter(Long scheId, Object companyId, DynamicObject draftSettleTypes, DynamicObject currencyDObj, List<Long> limitbankIds, List<Long> draftIdList, IDataModel dataModel, BigDecimal choosebalanceAmt, Boolean isBillDibs) {
        DynamicObject[] bankcgSetting;
        List type_codeList;
        QFilter allFilter = new QFilter("company", "=", companyId).and(new QFilter("istransfer", "=", (Object)"1")).and(new QFilter("billstatus", "=", (Object)"C"));
        allFilter = allFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(scheId)))));
        allFilter = allFilter.and(new QFilter("currency", "=", currencyDObj.getPkValue()));
        if (!isBillDibs.booleanValue()) {
            QFilter q1 = new QFilter("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"1");
            QFilter q2 = new QFilter("availableamount", "<=", (Object)choosebalanceAmt).and("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"0");
            allFilter = allFilter.and(q1.or(q2));
        } else {
            allFilter = allFilter.and(new QFilter("availableamount", ">", (Object)BigDecimal.ZERO));
        }
        allFilter = allFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        if (EmptyUtil.isNoEmpty((DynamicObject)draftSettleTypes)) {
            String settlementtype = draftSettleTypes.getString("settlementtype");
            Long linkSettlementTypeId = Optional.ofNullable(draftSettleTypes.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> draftSettleTypes.getLong("id"));
            List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList(settlementtype, linkSettlementTypeId);
            allFilter.and(new QFilter("draftbilltype", "in", billTypeIdList));
        }
        if (EmptyUtil.isNoEmpty(limitbankIds) && limitbankIds.size() > 0 && !EmptyUtil.isEmpty(type_codeList = Arrays.stream(bankcgSetting = TmcDataServiceHelper.load((Object[])limitbankIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"))).map(v -> v.getString("type_code")).collect(Collectors.toList()))) {
            QFilter accBankNo = null;
            for (String type_code : type_codeList) {
                if (accBankNo == null) {
                    accBankNo = new QFilter("accepterbankno", "like", (Object)(type_code + "%"));
                    continue;
                }
                accBankNo.or(new QFilter("accepterbankno", "like", (Object)(type_code + "%")));
            }
            allFilter.and(accBankNo);
        }
        allFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        PayScheHelper.getSelectedDraftFilter(dataModel, draftIdList, allFilter);
        QFilter nullFilter = QFilter.isNull((String)"billpool");
        allFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
        return allFilter;
    }

    public static void scheBillTransAuditProcess(DynamicObject payScheBill, BigDecimal checkAmt, BigDecimal checkDraftAmt) {
        if (checkDraftAmt.compareTo(BigDecimal.ZERO) == 0 && checkAmt.compareTo(BigDecimal.ZERO) == 0) {
            logger.info("\u6392\u6b3e\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u5747\u4e3a0\u7684\u65f6\u5019\uff0c\u5f00\u59cb\u5c06\u672a\u5904\u7406\u7684\u5355\u636e\u8fdb\u884c\u91ca\u653e");
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.NOSCHEDULE.getValue());
            payScheBill.set("schedealid", null);
            payScheBill.set("scheduleeditnum", null);
            payScheBill.set("summaryid", null);
            return;
        }
        payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
        payScheBill.set("nopayamt", (Object)checkAmt);
        payScheBill.set("draftnopayamt", (Object)checkDraftAmt);
        payScheBill.set("checktotalamt", (Object)checkAmt.add(checkDraftAmt));
        payScheBill.set("checkamt", (Object)checkAmt);
        payScheBill.set("checkdraftamt", (Object)checkDraftAmt);
    }

    public static QFilter getChooseDraftQFilter(Long scheId, DynamicObject draftSettleTypes, DynamicObject currencyDObj, List<Long> limitbankIds, List<Long> draftIdList, IDataModel dataModel, BigDecimal choosebalanceAmt, Boolean isBillDibs) {
        DynamicObject[] bankcgSetting;
        List type_codeList;
        QFilter allFilter = new QFilter("istransfer", "=", (Object)"1").and(new QFilter("billstatus", "=", (Object)"C"));
        allFilter = allFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(scheId)))));
        allFilter = allFilter.and(new QFilter("currency", "=", currencyDObj.getPkValue()));
        if (!isBillDibs.booleanValue()) {
            QFilter q1 = new QFilter("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"1");
            QFilter q2 = new QFilter("availableamount", "<=", (Object)choosebalanceAmt).and("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"0");
            allFilter = allFilter.and(q1.or(q2));
        } else {
            allFilter = allFilter.and(new QFilter("availableamount", ">", (Object)BigDecimal.ZERO));
        }
        allFilter = allFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        if (EmptyUtil.isNoEmpty((DynamicObject)draftSettleTypes)) {
            String settlementtype = draftSettleTypes.getString("settlementtype");
            Long linkSettlementTypeId = Optional.ofNullable(draftSettleTypes.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> draftSettleTypes.getLong("id"));
            List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList(settlementtype, linkSettlementTypeId);
            allFilter.and(new QFilter("draftbilltype", "in", billTypeIdList));
        }
        if (EmptyUtil.isNoEmpty(limitbankIds) && limitbankIds.size() > 0 && !EmptyUtil.isEmpty(type_codeList = Arrays.stream(bankcgSetting = TmcDataServiceHelper.load((Object[])limitbankIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"))).map(v -> v.getString("type_code")).collect(Collectors.toList()))) {
            QFilter accBankNo = null;
            for (String type_code : type_codeList) {
                if (accBankNo == null) {
                    accBankNo = new QFilter("accepterbankno", "like", (Object)(type_code + "%"));
                    continue;
                }
                accBankNo.or(new QFilter("accepterbankno", "like", (Object)(type_code + "%")));
            }
            allFilter.and(accBankNo);
        }
        allFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        PayScheHelper.getSelectedDraftFilter(dataModel, draftIdList, allFilter);
        QFilter nullFilter = QFilter.isNull((String)"billpool");
        allFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
        return allFilter;
    }

    public static QFilter getChoosePayDraftQFilter(Long scheId, Object companyId, DynamicObject draftSettleTypes, DynamicObject currencyDObj, String payeeName, List<Long> draftIdList, String pageId, BigDecimal limitChooseDraftAmt, Boolean isBillDibs) {
        Set draftBillIds;
        Set<Long> lockedBillIdSet;
        QFilter allFilter = new QFilter("drawercompany", "=", companyId).and(new QFilter("billstatus", "=", (Object)"C"));
        allFilter = allFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(scheId)))));
        allFilter = allFilter.and(new QFilter("currency", "=", currencyDObj.getPkValue()));
        if (!isBillDibs.booleanValue()) {
            allFilter = allFilter.and(new QFilter("availableamount", "<=", (Object)limitChooseDraftAmt));
        }
        allFilter = allFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
        if (EmptyUtil.isNoEmpty((DynamicObject)draftSettleTypes)) {
            String settlementtype = draftSettleTypes.getString("settlementtype");
            Long linkSettlementTypeId = Optional.ofNullable(draftSettleTypes.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> draftSettleTypes.getLong("id"));
            List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList(settlementtype, linkSettlementTypeId);
            allFilter.and(new QFilter("draftbilltype", "in", billTypeIdList));
        }
        allFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        if (EmptyUtil.isNoEmpty((String)payeeName)) {
            allFilter.and(new QFilter("receivername", "=", (Object)payeeName));
        }
        if ((lockedBillIdSet = new DraftBillLockCache(pageId).getLockedBillIdSet()).size() > 0) {
            if (EmptyUtil.isNoEmpty(draftIdList) && draftIdList.size() > 0) {
                ArrayList<Long> excludeIdList = new ArrayList<Long>();
                for (Long lockedBill : draftIdList) {
                    if (!draftIdList.contains(lockedBill)) continue;
                    excludeIdList.add(lockedBill);
                }
                if (excludeIdList.size() > 0) {
                    lockedBillIdSet.removeAll(excludeIdList);
                }
            }
            allFilter.and(new QFilter("id", "not in", lockedBillIdSet));
        }
        allFilter.and(new QFilter("source", "!=", (Object)"cas"));
        logger.info("select draft");
        DynamicObjectCollection payDraftColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])new QFilter[]{allFilter});
        Set selectDraftIdSet = payDraftColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill.fbasedataid", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"D"), new QFilter("draftbill.fbasedataid", "in", selectDraftIdSet)});
        if (paybills != null && paybills.length > 0 && EmptyUtil.isNoEmpty(draftBillIds = Arrays.stream(paybills).map(o -> o.get("draftbill.fbasedataid")).collect(Collectors.toSet()))) {
            allFilter.and(new QFilter("id", "not in", draftBillIds));
        }
        return allFilter;
    }

    @Deprecated
    public static BigDecimal getDraftsAmts(List<Long> draftnoIds) {
        Object[] drafts = TmcDataServiceHelper.load((Object[])draftnoIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        BigDecimal totalAmts = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((Object[])drafts) && drafts.length > 0) {
            for (Object draft : drafts) {
                totalAmts = totalAmts.add(draft.getBigDecimal("availableamount"));
            }
        }
        return totalAmts;
    }

    public static List<PrimeRuleVal> getProjectOrSupplierSort(String effectEle) {
        Object[] sortDObj;
        String entityName = "bd_suppliergroup";
        if (PsdEffectEleEnum.PROJECTSORT.getValue().equals(effectEle)) {
            entityName = "bd_projectkind";
        }
        if (EmptyUtil.isNoEmpty((Object[])(sortDObj = TmcDataServiceHelper.load((String)entityName, (String)"id,name", (QFilter[])new QFilter[0]))) && sortDObj.length > 0) {
            List<PrimeRuleVal> valList = Arrays.stream(sortDObj).map(v -> new PrimeRuleVal(v.getString("name"), String.valueOf(v.getLong("id")))).collect(Collectors.toList());
            return valList;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static PaySchePayInfo beanFromDynamicObject(DynamicObject obj) {
        DynamicObjectCollection draftEntrys;
        String lcArrivalNo;
        DynamicObject paymentTypeObj;
        DynamicObject draftAcctBank;
        DynamicObject settleType;
        boolean isOneRate;
        PaySchePayInfo info = new PaySchePayInfo();
        DynamicObject applyCurrency = obj.getDynamicObject("currency");
        BigDecimal applyAmt = obj.getBigDecimal("applyamt");
        BigDecimal billAmt = obj.getBigDecimal("draftamt");
        BigDecimal scheAmt = obj.getBigDecimal("amount");
        BigDecimal balance = obj.getBigDecimal("balanceamt");
        BigDecimal exchangeRate = obj.getBigDecimal("exchangerate");
        int percentScale = 23;
        int scale = applyCurrency.getInt("amtprecision");
        BigDecimal waitPayAmt = obj.getBigDecimal("waitpayamt");
        if (BigDecimal.ZERO.compareTo(waitPayAmt) == 0 && BigDecimal.ZERO.compareTo(applyAmt) != 0) {
            waitPayAmt = applyAmt;
        }
        boolean isFullSche = BigDecimal.ZERO.compareTo(balance) == 0;
        boolean bl = isOneRate = BigDecimal.ONE.compareTo(exchangeRate) == 0;
        if (!isOneRate) {
            BigDecimal scheAmtScale;
            BigDecimal totalAmt = scheAmt.add(billAmt).add(balance);
            if (isFullSche) {
                if (BigDecimal.ZERO.compareTo(scheAmt) != 0 && BigDecimal.ZERO.compareTo(billAmt) == 0) {
                    scheAmt = waitPayAmt;
                    billAmt = BigDecimal.ZERO;
                } else if (BigDecimal.ZERO.compareTo(billAmt) != 0 && BigDecimal.ZERO.compareTo(scheAmt) == 0) {
                    scheAmt = BigDecimal.ZERO;
                    billAmt = waitPayAmt;
                } else {
                    if (BigDecimal.ZERO.compareTo(scheAmt) == 0 || BigDecimal.ZERO.compareTo(billAmt) == 0) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u6392\u7a0b\uff0c\u518d\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PayScheHelper_0", (String)"tmc-psd-business", (Object[])new Object[0]), obj.getString("billno")));
                    scheAmtScale = scheAmt.divide(totalAmt, 23, RoundingMode.HALF_UP);
                    scheAmt = scheAmtScale.multiply(waitPayAmt).setScale(scale, RoundingMode.HALF_UP);
                    billAmt = waitPayAmt.subtract(scheAmt);
                }
            } else if (BigDecimal.ZERO.compareTo(scheAmt) != 0 && BigDecimal.ZERO.compareTo(billAmt) == 0) {
                scheAmtScale = scheAmt.divide(totalAmt, 23, RoundingMode.HALF_UP);
                scheAmt = waitPayAmt.multiply(scheAmtScale).setScale(scale, RoundingMode.HALF_UP);
                billAmt = BigDecimal.ZERO;
            } else if (BigDecimal.ZERO.compareTo(billAmt) != 0 && BigDecimal.ZERO.compareTo(scheAmt) == 0) {
                scheAmt = BigDecimal.ZERO;
                BigDecimal billAmtScale = billAmt.divide(totalAmt, 23, RoundingMode.HALF_UP);
                billAmt = waitPayAmt.multiply(billAmtScale).setScale(scale, RoundingMode.HALF_UP);
            } else {
                if (BigDecimal.ZERO.compareTo(scheAmt) == 0 || BigDecimal.ZERO.compareTo(billAmt) == 0) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u6392\u7a0b\uff0c\u518d\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PayScheHelper_0", (String)"tmc-psd-business", (Object[])new Object[0]), obj.getString("billno")));
                scheAmtScale = scheAmt.divide(totalAmt, 23, RoundingMode.HALF_UP);
                BigDecimal billAmtScale = billAmt.divide(totalAmt, 23, RoundingMode.HALF_UP);
                scheAmt = scheAmtScale.multiply(waitPayAmt);
                BigDecimal totalScheAmt = scheAmt.add(billAmt = billAmtScale.multiply(waitPayAmt));
                if (totalScheAmt.abs().compareTo(waitPayAmt.abs()) > 0) {
                    BigDecimal diff = totalScheAmt.subtract(waitPayAmt);
                    if (billAmt.abs().compareTo(diff.abs()) > 0) {
                        billAmt = billAmt.subtract(diff);
                    } else {
                        if (scheAmt.abs().compareTo(diff.abs()) <= 0) throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f02\u5e01\u79cd\u7cbe\u5ea6\u6362\u7b97\u5f02\u5e38\u3002\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6392\u6b3e\u6392\u7968\u91d1\u989d\u3002", (String)"PayScheHelper_1", (String)"tmc-psd-business", (Object[])new Object[0]), obj.getString("billno")));
                        scheAmt = scheAmt.subtract(diff);
                    }
                }
            }
        }
        info.setScheAmt(scheAmt);
        info.setDraftBillAmt(billAmt);
        info.setScheId(obj.getLong("id"));
        info.setExpectDate(obj.getDate("expectdate"));
        info.setExpectPayDate(obj.getDate("expectpaydate"));
        info.setBatchPayId(obj.getString("batchpayid"));
        DynamicObject paycurrency = obj.getDynamicObject("paycurrency");
        if (null != paycurrency) {
            info.setCurrencyId(paycurrency.getLong("id"));
        }
        info.setApplyCurrencyId(applyCurrency.getLong("id"));
        DynamicObject fundflowitem = obj.getDynamicObject("fundflowitem");
        if (null != fundflowitem) {
            info.setFundUsageId(fundflowitem.getLong("id"));
        }
        if (null != (settleType = obj.getDynamicObject("settletype"))) {
            info.setSettleTypeId(settleType.getLong("id"));
            info.setBusinessType(obj.getString("businesstype"));
        }
        DynamicObject acctBank = obj.getDynamicObject("acctbank");
        String acctBankType = obj.getString("acctbanktype");
        if (null != acctBank) {
            if (acctBankType.equals("bd_accountbanks")) {
                info.setAcctBankId(acctBank.getLong("id"));
                info.setInstitutionCode(obj.getString("institutioncode"));
                info.setInstitutionName(obj.getString("institutionname"));
            } else {
                info.setCashAcctId(acctBank.getLong("id"));
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(draftAcctBank = obj.getDynamicObject("draftpayacct")))) {
            info.setDraftPayAcctId(draftAcctBank.getLong("id"));
        }
        if (null != (paymentTypeObj = obj.getDynamicObject("paymenttype"))) {
            info.setPaymentType(paymentTypeObj.getLong("id"));
        }
        info.setSourceBillId(obj.getLong("sourcebillid"));
        info.setSourceBillType(obj.getString("sourcebilltype"));
        info.setSourceEntryId(obj.getString("sourcebillentryid"));
        info.setPayChannel(obj.getString("paymentchannel"));
        info.setDraftPayMethod(obj.getString("draftpaymethod"));
        DynamicObject draftSettleType = obj.getDynamicObject("draftsettletype");
        if (null != draftSettleType) {
            info.setDraftSettleTypeId(draftSettleType.getLong("id"));
            info.setDraftSettleType(draftSettleType.getString("settlementtype"));
        }
        info.setDraftpaychannel(obj.getString("draftpaychannel"));
        DynamicObjectCollection draftBills = obj.getDynamicObjectCollection("draftno");
        if (!draftBills.isEmpty()) {
            List<Long> drafts = draftBills.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            info.setDraftBillIds(drafts);
        }
        info.setApplyAmt(applyAmt);
        info.setScheBalance(balance);
        info.setScheStatus(obj.getString("schedulstatus"));
        info.setBatchSeqNo(obj.getString("batchnum"));
        info.setMergeFlag(!StringUtils.isEmpty((CharSequence)info.getBatchSeqNo()));
        info.setExchangerate(exchangeRate);
        DynamicObject exratetable = obj.getDynamicObject("exratetable");
        if (null != exratetable) {
            info.setExratetableId(exratetable.getLong("id"));
        }
        HashSet<Long> payIdSet = new HashSet<Long>();
        HashSet<Long> payEntryIdSet = new HashSet<Long>();
        DynamicObjectCollection entryList = obj.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entryList) {
            String type = entry.getString("e_billtype");
            long payId = entry.getLong("e_payid");
            long entryId = entry.getLong("e_payentryid");
            if (!"schebill".equals(type)) continue;
            payIdSet.add(payId);
            payEntryIdSet.add(entryId);
        }
        info.setPayIdList(new ArrayList<Long>(payIdSet));
        info.setPayEntryIdList(new ArrayList<Long>(payEntryIdSet));
        info.setTransferpost(Optional.ofNullable(obj.get("transferpost")).map(o -> o.toString()).orElseGet(() -> ""));
        PluginProxy pluginProxy = PluginProxy.create(IAssemblySecondaryDevFields.class, (String)"kd.sdk.tmc.psd.extpoint.interest.IAssemblySecondaryDevFields");
        List result = pluginProxy.callReplace(proxy -> {
            Map maps = proxy.assemblySecondaryDevFields(obj);
            return maps;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        logger.info(String.format("\u5904\u7406\u7ed3\u679c\u53c2\u6570\uff1a%s", result));
        if (EmptyUtil.isNoEmpty(result) && EmptyUtil.isNoEmpty(result.get(0))) {
            Object o2 = result.get(0);
            Map fields = (Map)o2;
            info.setSecondaryFields(fields);
        }
        info.setIsbilldibs(obj.getBoolean("isbilldibs"));
        DynamicObject receiveObject = obj.getDynamicObject("dibsbalance");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiveObject)) {
            info.setReceiveId(receiveObject.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty((String)(lcArrivalNo = obj.getString("lcarrivalno")))) {
            info.setLcarrivalNo(lcArrivalNo);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(draftEntrys = obj.getDynamicObjectCollection("draftinfoentry")))) {
            HashMap<Long, BigDecimal> draftInfoMap = new HashMap<Long, BigDecimal>(draftEntrys.size());
            HashMap<Long, Long> draftIdLogIdMap = new HashMap<Long, Long>(draftInfoMap.size());
            for (DynamicObject draftEntry : draftEntrys) {
                long draftId = PayScheHelper.getDraftId(draftEntry);
                Long draftLogId = draftEntry.getLong("de_draftlogid");
                BigDecimal transferAmt = draftEntry.getBigDecimal("de_transferamt");
                draftInfoMap.put(draftId, transferAmt);
                draftIdLogIdMap.put(draftId, draftLogId);
            }
            info.setDraftInfoMap(draftInfoMap);
            info.setDraftIdLogIdMap(draftIdLogIdMap);
        }
        logger.info("\u8f6c\u6362\u7684\u4e4b\u540e\u7684 PaySchePayInfo \u5bf9\u8c61\u4e3a: {}", (Object)LoggerPrintHelper.printObjectLoggerByToString((Object[])new PaySchePayInfo[]{info}));
        return info;
    }

    public static ChargeBackInfo createChargeBackInfo(DynamicObject obj) {
        BigDecimal applyAmt = obj.getBigDecimal("applyamt");
        ChargeBackInfo info = new ChargeBackInfo();
        HashSet<Long> payIdSet = new HashSet<Long>();
        HashSet<Long> payEntryIdSet = new HashSet<Long>();
        DynamicObjectCollection entryList = obj.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entryList) {
            String type = entry.getString("e_billtype");
            long payId = entry.getLong("e_payid");
            long entryId = entry.getLong("e_payentryid");
            if (!"schebill".equals(type)) continue;
            payIdSet.add(payId);
            payEntryIdSet.add(entryId);
        }
        info.setScheId(obj.getLong("id"));
        info.setBatchPayId(obj.getString("batchpayid"));
        info.setPayIdList(new ArrayList<Long>(payIdSet));
        info.setPayEntryIdList(new ArrayList<Long>(payEntryIdSet));
        info.setApplyAmt(applyAmt);
        logger.info("\u521b\u5efa\u7684\u9000\u5355\u4fe1\u606f\u4e3a: {}", (Object)LoggerPrintHelper.printObjectLoggerByToString((Object[])new ChargeBackInfo[]{info}));
        return info;
    }

    @Deprecated
    public static List<Long> transDyObjCollection2List(DynamicObjectCollection doc) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (doc.isEmpty()) {
            return ids;
        }
        for (DynamicObject doObj : doc) {
            ids.add(doObj.getLong("fbasedataid_id"));
        }
        return ids;
    }

    public static void changeDraftLockCache(Object oldValue, Object newValue, String pageId) {
        HashSet<Long> calDraftnoIdSet = new HashSet<Long>(10);
        List oldDraftnoIdList = Optional.ofNullable(oldValue).map(o -> JSON.parseArray((String)o.toString(), Long.class)).orElseGet(ArrayList::new);
        List newDraftnoIdList = Optional.ofNullable(newValue).map(o -> JSON.parseArray((String)o.toString(), Long.class)).orElseGet(ArrayList::new);
        calDraftnoIdSet.clear();
        calDraftnoIdSet.addAll(oldDraftnoIdList);
        calDraftnoIdSet.removeAll(newDraftnoIdList);
        new DraftBillLockCache(pageId).release(calDraftnoIdSet);
        calDraftnoIdSet.clear();
        calDraftnoIdSet.addAll(newDraftnoIdList);
        calDraftnoIdSet.removeAll(oldDraftnoIdList);
        new DraftBillLockCache(pageId).lock(calDraftnoIdSet);
    }

    @Deprecated
    public static List<Object> getBillTypeIdList(String settlementType) {
        DynamicObject[] dynObjWithId = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)settlementType)});
        return Arrays.stream(dynObjWithId).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    public static List<Object> getBillTypeIdList(String settlementType, Long settlementTypeId) {
        DynamicObject[] dynObjWithId = null;
        dynObjWithId = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtypebd.fbasedataid.id", "=", (Object)settlementTypeId)});
        if (dynObjWithId.length == 0) {
            dynObjWithId = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)settlementType), QFilter.isNull((String)"settlementtypebd.fbasedataid.id")});
        }
        return Arrays.stream(dynObjWithId).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    public static void changeDraftLock(List<DraftLockInfo> lockInfoList) {
        if (CollectionUtils.isEmpty(lockInfoList)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"changeBillLockInfo", (Object[])new Object[]{JSON.toJSONString(lockInfoList)});
    }

    public static List<LockResult> lockDraft(List<DraftAmountLockInfo> draftAmountLockInfos) {
        if (CollectionUtils.isEmpty(draftAmountLockInfos)) {
            return null;
        }
        String result = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"lockBillsByLog", (Object[])new Object[]{JSON.toJSONString(draftAmountLockInfos)});
        return JSON.parseArray((String)result, LockResult.class);
    }

    public static List<LockResult> updateDraft(List<DraftAmountLockInfo> draftAmountLockInfos) {
        if (CollectionUtils.isEmpty(draftAmountLockInfos)) {
            return null;
        }
        String result = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"updateBillsByLog", (Object[])new Object[]{JSON.toJSONString(draftAmountLockInfos)});
        return JSON.parseArray((String)result, LockResult.class);
    }

    @Deprecated
    public static void releaseOrLockDraft(List<DraftLockInfo> lockInfoList) {
        if (CollectionUtils.isEmpty(lockInfoList)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"lockOrReleaseBill", (Object[])new Object[]{JSON.toJSONString(lockInfoList)});
    }

    @Deprecated
    public static void releaseReceiveBills(List<JSONObject> releaseOrLockReceiveBills) {
        if (CollectionUtils.isEmpty(releaseOrLockReceiveBills)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"receiveBillSynUse", (String)"releaseReceiveBill", (Object[])new Object[]{releaseOrLockReceiveBills.toString()});
    }

    public static void lockReceiveBills(List<JSONObject> releaseOrLockReceiveBills) {
        if (CollectionUtils.isEmpty(releaseOrLockReceiveBills)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"receiveBillSynUse", (String)"lockReceiveBill", (Object[])new Object[]{releaseOrLockReceiveBills.toString()});
    }

    @Deprecated
    public static QFilter getPrimeRuleFiler(long orgId) {
        QFilter dateFilter = new QFilter("enabledate", "<=", (Object)DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)false));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = new QFilter("u_entry.u_org", "=", (Object)orgId);
        QFilter allOrgFilter = new QFilter("faceallorg", "=", (Object)"1");
        return dateFilter.and(enableFilter).and(orgFilter.or(allOrgFilter));
    }

    public static DynamicObject getCombineRule(Long orgId) {
        DynamicObject[] combineRules = TmcDataServiceHelper.load((String)"psd_autocombinerule", (String)"org,entryentity,entryentity.feildname,entryentity.feildvalue", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (combineRules.length > 0) {
            return combineRules[0];
        }
        return null;
    }

    public static DraftAmountLockSubInfo getReleaseLockInfo(DynamicObject paysche, boolean isDraftBook, boolean isLock, DynamicObject draftInfo, boolean isOld) {
        Object draftInfoObj;
        String transferAmtProp = "amount";
        String draftLogIdProp = "";
        String draftInfoMeta = "de_draftinfo";
        if (paysche.getDataEntityType().getName().equals("cas_paybill") && !isOld) {
            transferAmtProp = "transamount";
            draftLogIdProp = "draftbilllogid";
            draftInfoMeta = "draftbillinfo";
        } else if (paysche.getDataEntityType().getName().equals("psd_schedulebill") && !isOld) {
            transferAmtProp = "de_transferamt";
            draftLogIdProp = "de_draftlogid";
        }
        DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
        if (isLock) {
            draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
        } else {
            draftAmountLockSubInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
        }
        String billTrade = "relatedpay";
        if (isDraftBook) {
            billTrade = "endorse";
        }
        draftAmountLockSubInfo.setBillTrade(billTrade);
        long draftId = 0L;
        BigDecimal transferAmt = BigDecimal.ZERO;
        draftId = !isOld ? ((draftInfoObj = draftInfo.get(draftInfoMeta)) instanceof DynamicObject ? draftInfo.getDynamicObject(draftInfoMeta).getLong("id") : draftInfo.getLong(draftInfoMeta)) : draftInfo.getLong("id");
        draftAmountLockSubInfo.setBillId(draftId);
        transferAmt = Optional.ofNullable(draftInfo.getBigDecimal(transferAmtProp)).map(o -> o).orElseGet(() -> BigDecimal.ZERO);
        draftAmountLockSubInfo.setDealAmount(transferAmt);
        if (!isOld) {
            Long draftLogId = draftInfo.getLong(draftLogIdProp);
            draftAmountLockSubInfo.setBillLogId(draftLogId);
        }
        return draftAmountLockSubInfo;
    }

    public static DraftLockInfo getPayToSchChangeLockInfo(Long backPayBillId, Long paySchId) {
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillId(backPayBillId);
        draftLockInfo.setSourceBillType("cas_paybill");
        draftLockInfo.setTargetBillId(paySchId);
        draftLockInfo.setTargetBillType("psd_schedulebill");
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,draftbill,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.transamount,cas_draftinfo.draftbilllogid,", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)backPayBillId)});
        DynamicObject payBill = payBills[0];
        String number = payBill.getString("billno");
        draftLockInfo.setBizBillNo(number);
        DynamicObjectCollection draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntrys)) {
            for (DynamicObject draftInfoEntry : draftInfoEntrys) {
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                long billId = draftInfoEntry.getDynamicObject("draftbillinfo").getLong("id");
                BigDecimal transamount = draftInfoEntry.getBigDecimal("transamount");
                long draftbilllogid = draftInfoEntry.getLong("draftbilllogid");
                draftAmountLockSubInfo.setBillId(billId);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setDealAmount(transamount);
                draftAmountLockSubInfo.setBillLogId(draftbilllogid);
                draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
            }
        } else {
            DynamicObjectCollection newDrafts = payBill.getDynamicObjectCollection("draftbill");
            ArrayList<Long> draftIDList = new ArrayList<Long>(8);
            for (DynamicObject draftno : newDrafts) {
                long draftId = draftno.getDynamicObject("fbasedataid").getLong("id");
                draftIDList.add(draftId);
            }
            DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIDList)});
            Map<Long, BigDecimal> idAndAmountMap = draftArr.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("amount")));
            for (DynamicObject newDraft : newDrafts) {
                DynamicObject draftDy = newDraft.getDynamicObject("fbasedataid");
                long draftBillId = draftDy.getLong("id");
                BigDecimal amount = idAndAmountMap.get(draftBillId);
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(draftBillId);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setDealAmount(amount);
                draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
            }
        }
        if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoList)) {
            draftLockInfo.setLockSubInfoList(draftAmountLockSubInfoList);
        }
        return draftLockInfo;
    }

    public static DraftLockInfo getSchToPayChangeLockInfo(Long backPayBillId, Long paySchId) {
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setTargetBillId(backPayBillId);
        draftLockInfo.setTargetBillType("cas_paybill");
        draftLockInfo.setSourceBillId(paySchId);
        draftLockInfo.setSourceBillType("psd_schedulebill");
        DynamicObject sourceBillDy = BusinessDataServiceHelper.loadSingle((Object)paySchId, (String)"psd_schedulebill");
        String number = sourceBillDy.getString("billno");
        draftLockInfo.setBizBillNo(number);
        DynamicObjectCollection psdDraftinfoDOC = sourceBillDy.getDynamicObjectCollection("draftinfoentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)psdDraftinfoDOC)) {
            ArrayList<DraftAmountLockSubInfo> releaseDraftLockInfos = new ArrayList<DraftAmountLockSubInfo>(psdDraftinfoDOC.size());
            for (DynamicObject draftInfo : psdDraftinfoDOC) {
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                long draftId = draftInfo.getLong("id");
                BigDecimal transAmount = draftInfo.getBigDecimal("de_transferamt");
                long draftbilllogid = draftInfo.getLong("de_draftlogid");
                draftAmountLockSubInfo.setDealAmount(transAmount);
                draftAmountLockSubInfo.setBillLogId(draftbilllogid);
                draftAmountLockSubInfo.setBillId(draftId);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                releaseDraftLockInfos.add(draftAmountLockSubInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(releaseDraftLockInfos);
        }
        return draftLockInfo;
    }

    public static long getDraftId(DynamicObject draftInfo) {
        long draftId = 0L;
        Object draftInfoObj = draftInfo.get("de_draftinfo");
        draftId = draftInfoObj instanceof DynamicObject ? draftInfo.getDynamicObject("de_draftinfo").getLong("id") : draftInfo.getLong("de_draftinfo");
        return draftId;
    }

    public static void releaseDraft(PayScheCalcModel newScheData) {
        if (newScheData.getPayScheDraftInfos() == null || newScheData.getPayScheDraftInfos().size() == 0) {
            return;
        }
        List<PayScheDraftInfo> payScheDraftInfos = newScheData.getPayScheDraftInfos();
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        ArrayList<DraftLockInfo> waitReleaseDraftInfos = new ArrayList<DraftLockInfo>(2);
        for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfos) {
            DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
            draftAmountLockSubInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
            draftAmountLockSubInfo.setBillTrade("endorse");
            draftAmountLockSubInfo.setBillId(payScheDraftInfo.getDraftId());
            draftAmountLockSubInfo.setDealAmount(payScheDraftInfo.getTransferAmt());
            draftAmountLockSubInfo.setBillLogId(payScheDraftInfo.getDraftLogId());
            draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
        }
        draftLockInfo.setSourceBillType((String)newScheData.getCalcPropVal("e_sourcebilltype"));
        draftLockInfo.setBizBillNo((String)newScheData.getCalcPropVal("e_billno"));
        draftLockInfo.setSourceBillId(newScheData.getScheId());
        draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
        waitReleaseDraftInfos.add(draftLockInfo);
        DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
        draftLockServiceHelper.releaseOrLockDraft(waitReleaseDraftInfos);
    }

    public static void updateLcOperateType(Map<String, String> payBillArrivalNos, String operateType) {
        if (payBillArrivalNos.size() == 0) {
            return;
        }
        DynamicObject[] arrBills = TmcDataServiceHelper.load((String)"lc_arrival", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("arrivalno", "in", payBillArrivalNos.values())});
        HashSet<DynamicObject> updateArrivals = new HashSet<DynamicObject>(payBillArrivalNos.size());
        for (DynamicObject arrBill : arrBills) {
            String billNo = arrBill.getString("arrivalno");
            DynamicObjectCollection entries = arrBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String payBillNo = entry.getString("payno");
                String compareLcNo = payBillArrivalNos.get(payBillNo);
                if (StringUtils.isEmpty((CharSequence)compareLcNo) || !billNo.contains(compareLcNo)) continue;
                entry.set("operatetype", (Object)operateType);
                updateArrivals.add(arrBill);
            }
        }
        if (updateArrivals.size() > 0) {
            TmcDataServiceHelper.save((DynamicObject[])updateArrivals.toArray(new DynamicObject[0]));
        }
    }

    public static QFilter getSelectedDraftFilter(IDataModel nodel, List<Long> draftIdList, QFilter qFilter) {
        DynamicObjectCollection entryList = nodel.getEntryEntity("entryentity");
        HashSet selectedDraftIds = new HashSet(entryList.size());
        for (DynamicObject entry : entryList) {
            DynamicObjectCollection draftnoList = entry.getDynamicObjectCollection("e_draftno");
            Set draftnoIds = draftnoList.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            if (draftnoIds.size() == 0) continue;
            selectedDraftIds.addAll(draftnoIds);
        }
        if (selectedDraftIds.size() == 0) {
            return qFilter;
        }
        if (EmptyUtil.isNoEmpty(draftIdList) && draftIdList.size() > 0) {
            ArrayList<Long> excludeIdList = new ArrayList<Long>();
            for (Long lockedBill : draftIdList) {
                if (!draftIdList.contains(lockedBill)) continue;
                excludeIdList.add(lockedBill);
            }
            if (excludeIdList.size() > 0) {
                selectedDraftIds.removeAll(excludeIdList);
            }
        }
        logger.info("====PayScheCalcBasePlugin::lockedBillIdSet sql:{}", (Object)LoggerPrintHelper.printCollectionLogger(selectedDraftIds));
        if (selectedDraftIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", selectedDraftIds));
        }
        return qFilter;
    }

    public static String getNeedPreRecButNotRec(DynamicObject[] draftBillColl) {
        String errorMsg = "";
        HashMap orgIdAndDrftIdMap = new HashMap(16);
        HashMap<Long, String> draftIdAndDrfBillnoMap = new HashMap<Long, String>(16);
        for (DynamicObject draftDy : draftBillColl) {
            String rptype = draftDy.getString("rptype");
            if (!"receivebill".equalsIgnoreCase(rptype)) continue;
            draftIdAndDrfBillnoMap.put(draftDy.getLong("id"), draftDy.getString("billno"));
            long companyId = draftDy.getDynamicObject("company").getLong("id");
            Set draftBillIdSet = (Set)orgIdAndDrftIdMap.get(companyId);
            if (EmptyUtil.isNoEmpty((Object)draftBillIdSet)) {
                draftBillIdSet.add(draftDy.getLong("id"));
                continue;
            }
            HashSet<Long> draftBillIdSetNew = new HashSet<Long>(1);
            draftBillIdSetNew.add(draftDy.getLong("id"));
            orgIdAndDrftIdMap.put(companyId, draftBillIdSetNew);
        }
        HashSet needCheckDraftIdSet = new HashSet(16);
        for (Map.Entry entry : orgIdAndDrftIdMap.entrySet()) {
            Set draftIds;
            boolean isneedrecfirst;
            Long orgId = (Long)entry.getKey();
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            Boolean isneedrecfirstOb = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isneedrecfirst");
            if (null == isneedrecfirstOb || !(isneedrecfirst = isneedrecfirstOb.booleanValue()) || !EmptyUtil.isNoEmpty((Object)(draftIds = (Set)orgIdAndDrftIdMap.get(orgId)))) continue;
            needCheckDraftIdSet.addAll(draftIds);
        }
        if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
            QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", needCheckDraftIdSet);
            filter.and("billstatus", "=", (Object)"D");
            DynamicObjectCollection cas_recbills = QueryServiceHelper.query((String)"cas_recbill", (String)"draftbill.fbasedataid.id as draftid", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_recbills)) {
                Set haRecDraftIdSet = cas_recbills.stream().map(e -> e.getLong("draftid")).collect(Collectors.toSet());
                boolean bl = needCheckDraftIdSet.removeAll(haRecDraftIdSet);
            }
            if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
                StringJoiner stringJoiner = new StringJoiner("\r\n");
                for (Long draftid : needCheckDraftIdSet) {
                    String drfatbillnoStr = (String)draftIdAndDrfBillnoMap.get(draftid);
                    String msg = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e \u201c%s\u201d \u672a\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u4e1a\u52a1\u95ed\u73af\uff0c\u8bf7\u5148\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u540e\u518d\u7528\u4e8e\u4ed8\u6b3e\u3002", (String)"PayScheHelper_9_2", (String)"tmc-psd-business", (Object[])new Object[]{drfatbillnoStr});
                    stringJoiner.add(msg);
                }
                if (EmptyUtil.isNoEmpty((Object)stringJoiner)) {
                    errorMsg = stringJoiner.toString();
                }
            }
        }
        return errorMsg;
    }

    public static DynamicObject getDefaultAccount(DynamicObject defaultAccountObj, PayScheCalcModel scheData) {
        DynamicObject targetMappingInfo = null;
        DynamicObject firstOrgMappingInfo = null;
        DynamicObjectCollection mappingInfoColl = defaultAccountObj.getDynamicObjectCollection("entryentity");
        Long dataOrgId = scheData.getOrgId();
        Long payCurrencyId = scheData.getCurrencyId();
        Long payeeBank = scheData.getPayeeBank();
        Long payBillTypeId = scheData.getPaymenttypeId();
        logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u6392\u7a0b\u5355\u4fe1\u606f\uff0corg\uff1a{%s},currency:{%s},payeeBank:{%s}", dataOrgId, payCurrencyId, payeeBank));
        String beBankName = "";
        if (payeeBank != null) {
            DynamicObject beBankObj = TmcDataServiceHelper.loadSingle((Object)payeeBank, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_bebank"));
            beBankName = beBankObj.getString("name");
        }
        String finalBeBankName = beBankName;
        List orgEqualsColl = mappingInfoColl.stream().filter(e -> e.getDynamicObject("org").getPkValue().equals(dataOrgId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgEqualsColl)) {
            return null;
        }
        logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e\u6216\u6392\u7968-\u5339\u914d\u5230\u7ec4\u7ec7\u4e00\u81f4\u7684\u4ed8\u6b3e\u4eba\u6570\uff1a{%s}", orgEqualsColl.size()));
        boolean isNullCurrency = false;
        boolean isNullBankType = false;
        boolean isNullPayBillType = false;
        for (DynamicObject orgEqualsItemObj : orgEqualsColl) {
            List currencyList = orgEqualsItemObj.getDynamicObjectCollection("currency").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            isNullCurrency = CollectionUtils.isEmpty(currencyList);
            List bankTypeNameList = orgEqualsItemObj.getDynamicObjectCollection("banktype").stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toList());
            isNullBankType = CollectionUtils.isEmpty(bankTypeNameList);
            List payBillTypeList = orgEqualsItemObj.getDynamicObjectCollection("paybilltype").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            isNullPayBillType = CollectionUtils.isEmpty(payBillTypeList);
            if (isNullCurrency && isNullBankType && isNullPayBillType && firstOrgMappingInfo == null) {
                logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e\u6216\u6392\u7968-\u5339\u914d\u5230\u7b2c\u4e00\u6761\u53ea\u6709\u7ec4\u7ec7\u4e00\u81f4\u7684\u4ed8\u6b3e\u4eba\uff0c%s", orgEqualsItemObj.getPkValue()));
                firstOrgMappingInfo = orgEqualsItemObj;
            }
            List isExistList = bankTypeNameList.stream().filter(e -> finalBeBankName.indexOf((String)e) >= 0).collect(Collectors.toList());
            if (currencyList.contains(payCurrencyId) && isExistList.size() > 0 && payBillTypeList.contains(payBillTypeId)) {
                logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e\u6216\u6392\u7968-\u5339\u914d\u5230\u7ec4\u7ec7\uff0c\u94f6\u884c\u7c7b\u522b\uff0c\u5e01\u79cd\uff0c\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\u7684\u4fe1\u606f\uff0c%s", orgEqualsItemObj.getPkValue()));
                targetMappingInfo = orgEqualsItemObj;
                break;
            }
            if (targetMappingInfo != null || !isNullCurrency && !currencyList.contains(payCurrencyId) || !isNullBankType && isExistList.size() <= 0 || !isNullPayBillType && !payBillTypeList.contains(payBillTypeId)) continue;
            logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e\u6216\u6392\u7968-\u5339\u914d\u5230\u7ec4\u7ec7\uff0c\u94f6\u884c\u7c7b\u522b\uff0c\u5e01\u79cd\uff0c\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\u7684\u4fe1\u606f\uff0c%s", orgEqualsItemObj.getPkValue()));
            targetMappingInfo = orgEqualsItemObj;
        }
        if (targetMappingInfo == null) {
            targetMappingInfo = firstOrgMappingInfo;
        }
        return targetMappingInfo;
    }
}

