/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractPayScheProcessorCreator {
    protected List<String> errMsgList = new ArrayList<String>();

    public PayScheProcessResult<Long> createProcessor() {
        PayScheProcessResult<Long> result = new PayScheProcessResult<Long>();
        result.setErrMsgList(this.errMsgList);
        try (TXHandle tx = TX.requiresNew((String)"psd_schedealbill.save");){
            this.validate();
            if (!result.isSuccess()) {
                PayScheProcessResult<Long> payScheProcessResult = result;
                return payScheProcessResult;
            }
            try {
                Long processorId = this.createProcessorBill();
                if (result.isSuccess()) {
                    result.setResult(processorId);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return result;
    }

    private Long createProcessorBill() {
        Pair<DynamicObject, Object> scheInfo = this.getScheInfo();
        DynamicObject org = (DynamicObject)scheInfo.getLeft();
        int scheSeq = 1;
        DynamicObject payScheProcessBill = BusinessDataServiceHelper.newDynamicObject((String)"psd_schedealbill");
        boolean ontimesche = true;
        if (scheInfo.getRight() instanceof DynamicObject) {
            DynamicObject currPeriod = (DynamicObject)scheInfo.getRight();
            QFilter scheOrgFilter = new QFilter("company", "=", org.getPkValue());
            QFilter schePeriodFilter = new QFilter("scheduleperiod", "=", currPeriod.getPkValue());
            DynamicObject[] lastScheProcessorArr = TmcDataServiceHelper.load((String)"psd_schedealbill", (String)"scheduleseq", (QFilter[])new QFilter[]{scheOrgFilter, schePeriodFilter}, (String)"createtime desc", (int)1);
            if (lastScheProcessorArr.length > 0) {
                scheSeq = lastScheProcessorArr[0].getInt("scheduleseq") + 1;
            }
            payScheProcessBill.set("startdate", (Object)currPeriod.getDate("startdate"));
            payScheProcessBill.set("scheduleperiod", (Object)currPeriod);
            payScheProcessBill.set("enddate", (Object)currPeriod.getDate("enddate"));
        } else if (scheInfo.getRight() instanceof Map) {
            ontimesche = false;
            HashMap right = (HashMap)scheInfo.getRight();
            Date startDate = (Date)right.get("startdate");
            Date endDate = (Date)right.get("enddate");
            QFilter scheOrgFilter = new QFilter("company", "=", org.getPkValue());
            DynamicObject[] lastScheProcessorArr = TmcDataServiceHelper.load((String)"psd_schedealbill", (String)"scheduleseq", (QFilter[])new QFilter[]{scheOrgFilter}, (String)"createtime desc", (int)1);
            if (lastScheProcessorArr.length > 0) {
                scheSeq = lastScheProcessorArr[0].getInt("scheduleseq") + 1;
            }
            payScheProcessBill.set("startdate", (Object)startDate);
            payScheProcessBill.set("enddate", (Object)endDate);
            payScheProcessBill.set("scheduleperiod", null);
        }
        payScheProcessBill.set("company", (Object)org);
        payScheProcessBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        payScheProcessBill.set("bizdate", (Object)DateUtils.getCurrentDate());
        payScheProcessBill.set("creator", (Object)RequestContext.get().getUserId());
        payScheProcessBill.set("modifier", (Object)RequestContext.get().getUserId());
        payScheProcessBill.set("createtime", (Object)DateUtils.getCurrentTime());
        payScheProcessBill.set("modifytime", (Object)DateUtils.getCurrentTime());
        payScheProcessBill.set("scheduleseq", (Object)scheSeq);
        payScheProcessBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"psd_schedealbill", (DynamicObject)payScheProcessBill, (String)org.getPkValue().toString(), null));
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payScheProcessBill});
        payScheProcessBill = (DynamicObject)save[0];
        Long processorId = (Long)payScheProcessBill.getPkValue();
        this.updatePayScheData(processorId, ontimesche);
        return processorId;
    }

    private void updatePayScheData(Long processorId, boolean onTimeSche) {
        DynamicObject processorBill = TmcDataServiceHelper.loadSingle((Object)processorId, (String)"psd_schedealbill");
        DynamicObject[] scheBillArr = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", "schedulstatus", "scheduleeditnum", "schedealid", "paymenttype", "currency", "summaryid", "entrustpayid"), (QFilter[])this.getPayScheBillFilter().toArray(new QFilter[0]));
        List<DynamicObject> scheduleBillList = Arrays.stream(scheBillArr).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> entrustPayIdGroupMap = Arrays.stream(scheBillArr).filter(s -> EmptyUtil.isNoEmpty((Long)s.getLong("entrustpayid"))).collect(Collectors.groupingBy(s -> s.getLong("entrustpayid")));
        if (!CollectionUtils.isEmpty(entrustPayIdGroupMap)) {
            entrustPayIdGroupMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    scheduleBillList.removeIf(s -> EmptyUtil.isNoEmpty((Long)s.getLong("entrustpayid")) && k.longValue() == s.getLong("entrustpayid"));
                }
            });
            scheBillArr = scheduleBillList.toArray(new DynamicObject[0]);
        }
        if (scheBillArr.length == 0) {
            String err = !onTimeSche ? ResManager.loadKDString((String)"\u6392\u7a0b\u5f00\u59cb\u3001\u7ed3\u675f\u65e5\u671f\u5185, \u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheProcessorCreator_03", (String)"tmc-psd-business", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6392\u7a0b\u5468\u671f\u201c%s\u201d\u5185\uff0c\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheProcessorCreator_02", (String)"tmc-psd-business", (Object[])new Object[0]), ((DynamicObject)this.getScheInfo().getRight()).getString("name"));
            throw new KDBizException(err);
        }
        for (DynamicObject scheBill : scheBillArr) {
            scheBill.set("schedulstatus", (Object)ScheStatusEnum.SCHEDULING.getValue());
            scheBill.set("scheduleeditnum", (Object)processorBill.getString("billno"));
            scheBill.set("schedealid", (Object)processorId);
        }
        SaveServiceHelper.save((DynamicObject[])scheBillArr);
    }

    public PayScheProcessResult<Object> validateWithResult() {
        PayScheProcessResult<Object> result = new PayScheProcessResult<Object>();
        result.setErrMsgList(this.errMsgList);
        this.validate();
        return result;
    }

    protected abstract void validate();

    protected abstract Pair<DynamicObject, Object> getScheInfo();

    protected abstract List<QFilter> getPayScheBillFilter();
}

