/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheCombineSumData;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractSumScheService;
import kd.tmc.psd.common.enums.PsdCombineModeEnum;

public class CombineSumScheService
extends AbstractSumScheService<PayScheCombineSumData> {
    private List<String> combinePropList;
    private PsdCombineModeEnum combineMode;

    public CombineSumScheService(PsdCombineModeEnum combineMode, List<String> combinePropList) {
        this.combineMode = combineMode;
        this.combinePropList = combinePropList;
    }

    @Override
    public List<PayScheCombineSumData> loadSummaryData(List<PayScheCalcModel> payScheDataList) {
        Map<String, List<PayScheCalcModel>> groupedDataList;
        List<PayScheCalcModel> needCreateSummaryCardPaySches = payScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        ArrayList<PayScheCombineSumData> sumDataList = new ArrayList<PayScheCombineSumData>(10);
        if (this.combineMode == PsdCombineModeEnum.AUTO_COMBINE) {
            groupedDataList = needCreateSummaryCardPaySches.stream().collect(Collectors.groupingBy(o -> o.getGroupKey(this.combinePropList)));
        } else if (this.combineMode == PsdCombineModeEnum.VIEW_COMBINE) {
            groupedDataList = needCreateSummaryCardPaySches.stream().collect(Collectors.groupingBy(PayScheCalcModel::getBatchnumBak));
        } else {
            throw new IllegalArgumentException();
        }
        PayScheBaseDataProvider baseDataProvider = new PayScheBaseDataProvider(needCreateSummaryCardPaySches);
        DynamicObjectType calcEntryType = baseDataProvider.getCalcEntryProp();
        long sumId = 0L;
        for (Map.Entry<String, List<PayScheCalcModel>> entry : groupedDataList.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            HashMap<String, Integer> groupedCntMap = new HashMap<String, Integer>();
            int errCnt = 0;
            for (PayScheCalcModel model : entry.getValue()) {
                String combineNum = model.getBatchnum();
                if (EmptyUtil.isNotEmpty((CharSequence)combineNum)) {
                    Integer cnt = groupedCntMap.computeIfAbsent(combineNum, o -> 0);
                    cnt = cnt + 1;
                    groupedCntMap.put(combineNum, cnt);
                    continue;
                }
                ++errCnt;
            }
            PayScheCombineSumData sumData = new PayScheCombineSumData();
            sumData.setSummaryId(sumId);
            sumData.setGroupCnt(groupedCntMap.size());
            sumData.setGroupedCntMap(groupedCntMap);
            sumData.setErrCnt(errCnt);
            sumData.setTotalCnt(entry.getValue().size());
            PayScheCalcModel firstModel = entry.getValue().get(0);
            if (this.combineMode == PsdCombineModeEnum.AUTO_COMBINE) {
                sumData.setDimVal(firstModel.getGroupKey(this.combinePropList));
                StringBuilder propValSb = new StringBuilder();
                for (int i = 0; i < this.combinePropList.size(); ++i) {
                    String valStr;
                    String propName = this.combinePropList.get(i);
                    DynamicProperty prop = calcEntryType.getProperty(propName);
                    String entityType = null;
                    if (prop instanceof BasedataProp) {
                        entityType = prop instanceof ItemClassProp ? (String)firstModel.getCalcPropVal(((ItemClassProp)prop).getTypePropName()) : ((BasedataProp)prop).getBaseEntityId();
                    } else if (prop instanceof MulBasedataProp) {
                        entityType = ((MulBasedataProp)prop).getBaseEntityId();
                    }
                    String name = prop.getDisplayName().getLocaleValue();
                    Object val = firstModel.getCalcPropVal(propName);
                    if (val != null) {
                        if (entityType == null) {
                            valStr = val + "";
                        } else if (val instanceof List) {
                            List<DynamicObject> baseDataList = baseDataProvider.getMultiBaseData(entityType, (List)val);
                            valStr = baseDataList.stream().map(o -> o.getString("name")).collect(Collectors.joining(","));
                        } else {
                            DynamicObject baseData = baseDataProvider.getBaseData(entityType, val);
                            valStr = baseData.getString("name");
                        }
                    } else {
                        valStr = ResManager.loadKDString((String)"\u7a7a", (String)"CombineSumScheService_0", (String)"tmc-psd-business", (Object[])new Object[0]);
                    }
                    propValSb.append(String.format("\u201c%s\u201d = \u201c%s\u201d", name, valStr));
                    if (i >= this.combinePropList.size() - 1) continue;
                    propValSb.append(" and ");
                }
                sumData.setDimName(propValSb.toString());
            } else if (this.combineMode == PsdCombineModeEnum.VIEW_COMBINE) {
                sumData.setDimVal(entry.getKey());
                sumData.setDimName(sumData.getDimVal());
                sumData.setCombineNum(entry.getKey());
            }
            sumDataList.add(sumData);
            for (PayScheCalcModel calcModel : entry.getValue()) {
                calcModel.setSummaryId(sumId);
            }
            ++sumId;
        }
        sumDataList.sort(Comparator.comparing(SumScheData::getDimVal));
        return sumDataList;
    }

    @Override
    public List<PayScheCombineSumData> rebuildSummaryData(List<PayScheCalcModel> payScheDataList) {
        return this.loadSummaryData(payScheDataList);
    }

    @Override
    protected void handleSumInfo(PayScheCombineSumData sumData, PayScheCalcModel oldScheData, PayScheCalcModel newScheData, Map<Long, Integer> scaleMap) {
        if (newScheData == null) {
            sumData.setTotalCnt(sumData.getTotalCnt() - 1);
            sumData.setErrCnt(sumData.getErrCnt() - 1);
        } else {
            boolean oldNotCombine = EmptyUtil.isEmpty((String)oldScheData.getBatchnum());
            boolean newNotCombine = EmptyUtil.isEmpty((String)newScheData.getBatchnum());
            if (oldNotCombine && !newNotCombine) {
                sumData.setErrCnt(sumData.getErrCnt() - 1);
                int groutCnt = sumData.getGroupedCntMap().computeIfAbsent(newScheData.getBatchnum(), o -> 0);
                sumData.getGroupedCntMap().put(newScheData.getBatchnum(), ++groutCnt);
            } else if (!oldNotCombine && newNotCombine) {
                sumData.setErrCnt(sumData.getErrCnt() + 1);
                int groutCnt = sumData.getGroupedCntMap().computeIfAbsent(oldScheData.getBatchnum(), o -> 1);
                sumData.getGroupedCntMap().put(oldScheData.getBatchnum(), --groutCnt);
            }
        }
    }

    @Override
    protected void afterHandleSumInfo(PayScheCombineSumData sumData) {
        Set zeroNumGroupKey = sumData.getGroupedCntMap().entrySet().stream().filter(o -> (Integer)o.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (zeroNumGroupKey.size() > 0) {
            sumData.setGroupCnt(sumData.getGroupCnt() - zeroNumGroupKey.size());
            for (String key : zeroNumGroupKey) {
                sumData.getGroupedCntMap().remove(key);
            }
        }
        sumData.setGroupCnt(sumData.getGroupedCntMap().size());
    }
}

