/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.rpc.bean.PaySchePayInfo;
import kd.tmc.psd.business.service.paysche.service.IDiffSplitService;
import kd.tmc.psd.common.enums.BillTypeEnum;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheDiffSplitService
implements IDiffSplitService {
    private static final Log logger = LogFactory.getLog(PayScheDiffSplitService.class);

    @Override
    public PayScheProcessResult<PayScheCalcModel> dealDiffSplitOfScheProcess(List<PayScheCalcModel> scheDataList, PayScheProcessResult<PayScheCalcModel> result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DynamicObject> dealDiffSplitOfPaySche(List<DynamicObject> toBeDiffSplitEntities) {
        ArrayList<DynamicObject> saveOrUpdateEntities = new ArrayList<DynamicObject>(toBeDiffSplitEntities.size() * 2);
        Set<Long> ids = toBeDiffSplitEntities.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] originDataEntities = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        for (int i = 0; i < originDataEntities.length; ++i) {
            DynamicObject dataEntity = originDataEntities[i];
            DynamicObject diffSplitDataEntity = TmcDataServiceHelper.clone((DynamicObject)dataEntity);
            this.createDiffSplitDataOfDy(dataEntity, diffSplitDataEntity);
            saveOrUpdateEntities.add(diffSplitDataEntity);
            saveOrUpdateEntities.add(dataEntity);
        }
        return saveOrUpdateEntities;
    }

    private void createDiffSplitDataOfDy(DynamicObject originData, DynamicObject cloneData) {
        List paybillTypes;
        BigDecimal waitPayAmt = BigDecimal.ZERO;
        BigDecimal totalOriginCurrencyAmt = BigDecimal.ZERO;
        String scheStatus = originData.getString("schedulstatus");
        if ((ScheStatusEnum.PAYING.getValue().equals(scheStatus) || ScheStatusEnum.YETPAY.getValue().equals(scheStatus)) && originData.getBigDecimal("waitpayamt").compareTo(originData.getBigDecimal("applyamt")) != 0) {
            waitPayAmt = originData.getBigDecimal("waitpayamt");
            totalOriginCurrencyAmt = originData.getBigDecimal("applyamt").subtract(originData.getBigDecimal("waitpayamt"));
        } else {
            PaySchePayInfo originPayInfo = PayScheHelper.beanFromDynamicObject(originData);
            totalOriginCurrencyAmt = originPayInfo.getScheAmt().add(originPayInfo.getDraftBillAmt());
            waitPayAmt = originData.getBigDecimal("applyamt").subtract(totalOriginCurrencyAmt);
        }
        Long pkId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias());
        cloneData.set("id", (Object)pkId);
        cloneData.set("batchnum", null);
        cloneData.set("issplit", (Object)true);
        cloneData.set("expectpaydate", (Object)DateUtils.getCurrentDate());
        cloneData.set("expectdate", (Object)DateUtils.getCurrentDate());
        cloneData.set("applyamt", (Object)waitPayAmt);
        cloneData.set("waitpayamt", (Object)waitPayAmt);
        cloneData.set("balanceamt", (Object)originData.getBigDecimal("balanceamt"));
        cloneData.set("billno", null);
        cloneData.set("splitid", (Object)originData.getLong("id"));
        cloneData.set("schedulstatus", (Object)ScheStatusEnum.NOSCHEDULE.getValue());
        cloneData.set("amount", (Object)BigDecimal.ZERO);
        cloneData.set("draftamt", (Object)BigDecimal.ZERO);
        cloneData.set("paymentno", null);
        cloneData.set("paybillstatus", null);
        cloneData.set("nopayamt", (Object)BigDecimal.ZERO);
        cloneData.set("draftpayno", null);
        cloneData.set("draftpaystatus", null);
        cloneData.set("draftnopayamt", (Object)BigDecimal.ZERO);
        cloneData.set("iscasexitbill", (Object)"0");
        cloneData.set("backreason", null);
        cloneData.set("transferpost", (Object)originData.getString("transferpost"));
        cloneData.set("withdrawtotalamt", (Object)BigDecimal.ZERO);
        cloneData.set("withdrawamt", (Object)BigDecimal.ZERO);
        cloneData.set("checkdraftamt", (Object)BigDecimal.ZERO);
        cloneData.set("draftno", null);
        cloneData.set("limitbank", null);
        cloneData.set("checkamt", (Object)BigDecimal.ZERO);
        cloneData.set("acctbank", originData.get("acctbank"));
        cloneData.set("acctbanktype", originData.get("acctbanktype"));
        cloneData.set("checktotalamt", (Object)BigDecimal.ZERO);
        cloneData.set("scheduletotalamt", (Object)BigDecimal.ZERO);
        cloneData.set("settletype", originData.get("settletype"));
        cloneData.set("paymentchannel", (Object)PayChannelEnum.COUNTER.getValue());
        cloneData.set("draftpaymethod", (Object)DraftPayTypeEnum.DRAFTPAY.getValue());
        cloneData.set("draftsettletype", originData.get("draftsettletype"));
        cloneData.set("draftpaychannel", (Object)PayChannelEnum.COUNTER.getValue());
        cloneData.set("draftpaychannel", (Object)PayChannelEnum.COUNTER.getValue());
        cloneData.set("draftpayacct", originData.get("draftpayacct"));
        cloneData.set("schedealid", null);
        cloneData.set("payerrmsg", null);
        originData.set("applyamt", (Object)totalOriginCurrencyAmt);
        originData.set("balanceamt", (Object)BigDecimal.ZERO);
        if (ScheStatusEnum.PAYING.getValue().equals(scheStatus) || ScheStatusEnum.YETPAY.getValue().equals(scheStatus)) {
            originData.set("waitpayamt", (Object)BigDecimal.ZERO);
        } else {
            originData.set("waitpayamt", (Object)totalOriginCurrencyAmt);
        }
        if (ScheStatusEnum.PAYING.getValue().equals(scheStatus)) {
            DynamicObjectCollection originPayBillEntry = originData.getDynamicObjectCollection("entrys");
            paybillTypes = originPayBillEntry.stream().filter(Objects::nonNull).filter(item -> BillTypeEnum.SCHEBILL.getValue().equals(item.getString("e_billtype"))).collect(Collectors.toList());
            originPayBillEntry.removeAll(paybillTypes);
        }
        DynamicObjectCollection payBillEntry = cloneData.getDynamicObjectCollection("entrys");
        if (!ScheStatusEnum.YETSCHEDULE.getValue().equals(scheStatus)) {
            paybillTypes = payBillEntry.stream().filter(Objects::nonNull).filter(item -> BillTypeEnum.PAYBILL.getValue().equals(item.getString("e_billtype"))).collect(Collectors.toList());
            payBillEntry.removeAll(paybillTypes);
            cloneData.set("entrys", (Object)payBillEntry);
        } else {
            cloneData.set("entrys", (Object)payBillEntry);
        }
        DynamicObjectCollection draftinfoEntryCol = cloneData.getDynamicObjectCollection("draftinfoentry");
        draftinfoEntryCol.clear();
        logger.info("\u5dee\u989d\u62c6\u5206\u7684\u6e90\u5355\u4e3a\uff1a{}\uff0c\n\u5dee\u989d\u62c6\u5206\u7684\u6e90\u65b0\u5355\u4e3a\uff1a{}", originData.getPkValue(), cloneData.getPkValue());
    }
}

