/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractPayScheProcessorCreator;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class PayScheProcessorByStartEndDateCreator
extends AbstractPayScheProcessorCreator {
    private DynamicObject org;
    private Date startDate;
    private Date endDate;
    private List<DynamicObject> currCurrencys = new ArrayList<DynamicObject>();

    public PayScheProcessorByStartEndDateCreator(Long orgId, Date startDate, Date endDate, List<Long> currencyIds) {
        this.org = TmcDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        this.startDate = startDate;
        this.endDate = endDate;
        DynamicObject[] currencyArr = TmcDataServiceHelper.load((Object[])currencyIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
        this.currCurrencys.addAll(Arrays.asList(currencyArr));
        this.errMsgList = new ArrayList();
    }

    @Override
    protected void validate() {
        List<QFilter> billFilter = this.getPayScheBillFilter();
        boolean existScheBill = TmcDataServiceHelper.exists((String)"psd_schedulebill", (QFilter[])billFilter.toArray(new QFilter[0]));
        if (!existScheBill) {
            this.errMsgList.add(ResManager.loadKDString((String)"\u6392\u7a0b\u5f00\u59cb\u3001\u7ed3\u675f\u65e5\u671f\u8303\u56f4\u5185, \u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheProcessorByStartEndDateCreator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected List<QFilter> getPayScheBillFilter() {
        QFilter dateFilter = new QFilter("expectdate", "<=", (Object)DateUtils.getDataFormat((Date)this.endDate, (boolean)false)).and("expectdate", ">=", (Object)DateUtils.getDataFormat((Date)this.startDate, (boolean)true));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        statusFilter.and(new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.NOSCHEDULE.getValue()));
        QFilter orgFilter = new QFilter("company", "=", this.org.getPkValue());
        List currencyIds = this.currCurrencys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter currCurrencyFilter = new QFilter("currency", "in", currencyIds);
        QFilter currNullFilter = new QFilter("paycurrency", "!=", (Object)0L);
        return new ArrayList<QFilter>(Arrays.asList(dateFilter, statusFilter, orgFilter, currCurrencyFilter, currNullFilter));
    }

    @Override
    protected Pair<DynamicObject, Object> getScheInfo() {
        HashMap<String, Date> value = new HashMap<String, Date>();
        value.put("startdate", this.startDate);
        value.put("enddate", this.endDate);
        return Pair.of((Object)this.org, value);
    }
}

