/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractPayScheProcessorCreator;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class PayScheProcessorCreator
extends AbstractPayScheProcessorCreator {
    private DynamicObject org;
    private DynamicObject currPeriod;
    private List<DynamicObject> currCurrencys = new ArrayList<DynamicObject>();

    public PayScheProcessorCreator(Long orgId, Long periodId, List<Long> currencyIds) {
        this.org = TmcDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        this.currPeriod = TmcDataServiceHelper.loadSingle((Object)periodId, (String)"psd_schedule_period");
        DynamicObject[] currencyArr = TmcDataServiceHelper.load((Object[])currencyIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
        this.currCurrencys.addAll(Arrays.asList(currencyArr));
        this.errMsgList = new ArrayList();
    }

    @Override
    protected void validate() {
        QFilter scheOrgFilter = new QFilter("company", "=", this.org.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter schePeriodFilter = new QFilter("scheduleperiod", "is not null", null).and(new QFilter("scheduleperiod", "!=", (Object)0));
        boolean hasUnHandleBill = TmcDataServiceHelper.exists((String)"psd_schedealbill", (QFilter[])new QFilter[]{scheOrgFilter, billStatusFilter, schePeriodFilter});
        if (hasUnHandleBill) {
            this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6709\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u6392\u7a0b\u5904\u7406\u8bb0\u5f55\u3002\u8bf7\u5148\u901a\u8fc7\u5ba1\u6279\uff0c\u518d\u8fdb\u884c\u4e0b\u4e00\u6b21\u6392\u7a0b\u5904\u7406\u3002", (String)"PayScheProcessorCreator_01", (String)"tmc-psd-business", (Object[])new Object[0]), this.org.getString("name")));
            return;
        }
        List<QFilter> billFilter = this.getPayScheBillFilter();
        boolean existScheBill = TmcDataServiceHelper.exists((String)"psd_schedulebill", (QFilter[])billFilter.toArray(new QFilter[0]));
        if (!existScheBill) {
            this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u6392\u7a0b\u5468\u671f\u201c%s\u201d\u5185\uff0c\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheProcessorCreator_02", (String)"tmc-psd-business", (Object[])new Object[0]), this.currPeriod.getString("name")));
            return;
        }
    }

    @Override
    protected List<QFilter> getPayScheBillFilter() {
        Date startDate = this.currPeriod.getDate("startdate");
        Date endDate = this.currPeriod.getDate("enddate");
        QFilter dateFilter = new QFilter("expectdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)).and("expectdate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true));
        QFilter statusFilter = new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.NOSCHEDULE.getValue()).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter orgFilter = new QFilter("company", "=", this.org.getPkValue());
        List currencyIds = this.currCurrencys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter currCurrencyFilter = new QFilter("currency", "in", currencyIds);
        QFilter currNullFilter = new QFilter("paycurrency", "!=", (Object)0L);
        return new ArrayList<QFilter>(Arrays.asList(dateFilter, statusFilter, orgFilter, currCurrencyFilter, currNullFilter));
    }

    @Override
    protected Pair<DynamicObject, Object> getScheInfo() {
        return Pair.of((Object)this.org, (Object)this.currPeriod);
    }
}

