/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractPayScheProcessorCreator;
import org.apache.commons.lang3.tuple.Pair;

public class PayScheProcessorDirectByStartEndDateCreator
extends AbstractPayScheProcessorCreator {
    private DynamicObject org;
    private Date startDate;
    private Date endDate;
    private List<Long> scheBillIds = new ArrayList<Long>();

    private PayScheProcessorDirectByStartEndDateCreator() {
    }

    public PayScheProcessorDirectByStartEndDateCreator(List<Long> scheBillIds) {
        this();
        this.scheBillIds = scheBillIds;
        DynamicObject[] scheBills = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", "expectdate", "company"), (QFilter[])new QFilter("id", "in", this.scheBillIds).toArray());
        List sortedExpectDates = Arrays.stream(scheBills).map(d -> d.getDate("expectdate")).sorted().collect(Collectors.toList());
        this.startDate = (Date)sortedExpectDates.get(0);
        this.endDate = (Date)sortedExpectDates.get(sortedExpectDates.size() - 1);
        this.org = scheBills[0].getDynamicObject("company");
    }

    @Override
    protected void validate() {
    }

    @Override
    protected Pair<DynamicObject, Object> getScheInfo() {
        HashMap<String, Date> value = new HashMap<String, Date>();
        value.put("startdate", this.startDate);
        value.put("enddate", this.endDate);
        return Pair.of((Object)this.org, value);
    }

    @Override
    protected List<QFilter> getPayScheBillFilter() {
        return Collections.singletonList(new QFilter("id", "in", this.scheBillIds));
    }
}

