/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractPayScheProcessorCreator;
import kd.tmc.psd.business.service.period.PeriodHelper;
import org.apache.commons.lang3.tuple.Pair;

public class PayScheProcessorDirectCreator
extends AbstractPayScheProcessorCreator {
    private List<Long> shceBillIds = new ArrayList<Long>();

    private PayScheProcessorDirectCreator() {
    }

    public PayScheProcessorDirectCreator(List<Long> shceBillIds) {
        this();
        this.shceBillIds = shceBillIds;
    }

    @Override
    protected void validate() {
        DynamicObject org = (DynamicObject)this.getScheInfo().getLeft();
        QFilter scheOrgFilter = new QFilter("company", "=", org.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter schePeriodFilter = new QFilter("scheduleperiod", "is not null", null).and(new QFilter("scheduleperiod", "!=", (Object)0));
        boolean hasUnHandleBill = TmcDataServiceHelper.exists((String)"psd_schedealbill", (QFilter[])new QFilter[]{scheOrgFilter, billStatusFilter, schePeriodFilter});
        if (hasUnHandleBill) {
            this.errMsgList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6709\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u6392\u7a0b\u5904\u7406\u8bb0\u5f55\u3002\u8bf7\u5148\u901a\u8fc7\u5ba1\u6279\uff0c\u518d\u8fdb\u884c\u4e0b\u4e00\u6b21\u6392\u7a0b\u5904\u7406\u3002", (String)"PayScheProcessorCreator_01", (String)"tmc-psd-business", (Object[])new Object[0]), org.getString("name")));
            return;
        }
    }

    @Override
    protected Pair<DynamicObject, Object> getScheInfo() {
        DynamicObject shceBill = TmcDataServiceHelper.loadSingle((Object)this.shceBillIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        DynamicObject company = shceBill.getDynamicObject("company");
        Date expectDate = shceBill.getDate("expectdate");
        DynamicObject schePeriod = PeriodHelper.getPeriodByDate(company.getLong("id"), expectDate);
        return Pair.of((Object)company, (Object)schePeriod);
    }

    @Override
    protected List<QFilter> getPayScheBillFilter() {
        return Collections.singletonList(new QFilter("id", "in", this.shceBillIds));
    }
}

