/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSumData;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractSumScheService;
import kd.tmc.psd.business.service.paysche.sumsche.SumScheRepository;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.enums.SumDimTypeEnum;
import kd.tmc.psd.common.untils.StringUtils;

public class SumScheService
extends AbstractSumScheService<PayScheSumData> {
    private Long orgId;
    private Long periodTypeId;
    private Long processorId;
    private String dimType;
    private SumScheRepository sumRepo;

    public SumScheService(Long processorId, Long orgId, Long periodTypeId, String dimType) {
        this.orgId = orgId;
        this.periodTypeId = periodTypeId = Optional.ofNullable(periodTypeId).map(o -> o).orElseGet(() -> 0L);
        this.processorId = processorId;
        this.sumRepo = new SumScheRepository();
        this.dimType = dimType;
    }

    @Override
    public List<PayScheSumData> loadSummaryData(List<PayScheCalcModel> payScheDataList) {
        List<PayScheCalcModel> needCreateSummaryCardPaySches = payScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        ArrayList<PayScheSumData> sumDataList = new ArrayList<PayScheSumData>();
        DynamicObject processor = TmcDataServiceHelper.loadSingle((Object)this.processorId, (String)"psd_schedealbill");
        boolean isSumSche = this.sumRepo.isSumSche(this.orgId, this.periodTypeId);
        String dimType = processor.getString("sumdim");
        DynamicObject sumRule = null;
        if (isSumSche) {
            sumRule = this.sumRepo.getSumScheRule(this.orgId, this.periodTypeId);
        }
        if (StringUtils.isEmpty((String)dimType)) {
            dimType = sumRule != null ? sumRule.getString("dimension") : SumDimTypeEnum.PAYTYPE.getValue();
        }
        sumDataList.addAll(this.createFromPayScheSumData(dimType, needCreateSummaryCardPaySches));
        this.handleSumScheRule(sumDataList, dimType);
        for (PayScheSumData sumData : sumDataList) {
            sumData.resetAmt();
        }
        this.calculateSumInfo(sumDataList, Collections.emptyList(), needCreateSummaryCardPaySches, new ArrayList<PayScheCalcModel>());
        this.dimType = dimType;
        return sumDataList;
    }

    @Override
    public List<PayScheSumData> rebuildSummaryData(List<PayScheCalcModel> payScheDataList) {
        if (this.dimType == null) {
            throw new IllegalStateException(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u6c47\u603b\u4fe1\u606f\u3002", (String)"SumScheService_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        List<PayScheSumData> sumDataList = this.createFromPayScheSumData(this.dimType, payScheDataList);
        this.handleSumScheRule(sumDataList, this.dimType);
        for (PayScheSumData sumData : sumDataList) {
            sumData.resetAmt();
        }
        this.calculateSumInfo(sumDataList, Collections.emptyList(), payScheDataList, new ArrayList<PayScheCalcModel>());
        return sumDataList;
    }

    @Override
    protected void handleSumInfo(PayScheSumData sumData, PayScheCalcModel oldScheData, PayScheCalcModel newScheData, Map<Long, Integer> scaleMap) {
        super.handleSumInfo(sumData, oldScheData, newScheData, scaleMap);
        BigDecimal oldScheAmt = oldScheData != null ? oldScheData.getScheAmt() : BigDecimal.ZERO;
        BigDecimal oldDraftBillAmt = oldScheData != null ? oldScheData.getDraftBillAmt() : BigDecimal.ZERO;
        BigDecimal oldApplyAmt = oldScheData != null ? oldScheData.getActualApplyAmt(scaleMap.get(oldScheData.getCurrencyId())) : BigDecimal.ZERO;
        BigDecimal oldScheBalance = oldScheData != null ? oldScheData.getActualBalanceAmt() : BigDecimal.ZERO;
        BigDecimal scheAmtDiff = newScheData.getScheAmt().subtract(oldScheAmt);
        BigDecimal billAmtDiff = newScheData.getDraftBillAmt().subtract(oldDraftBillAmt);
        BigDecimal applyAmtDiff = newScheData.getActualApplyAmt(scaleMap.get(newScheData.getCurrencyId())).subtract(oldApplyAmt);
        sumData.setScheAmt(sumData.getScheAmt().add(scheAmtDiff));
        sumData.setDraftAmt(sumData.getDraftAmt().add(billAmtDiff));
        sumData.setApplyAmt(sumData.getApplyAmt().add(applyAmtDiff));
        boolean isPositive = newScheData.getActualApplyAmt(scaleMap.get(newScheData.getCurrencyId())).compareTo(BigDecimal.ZERO) >= 0;
        BigDecimal totalAmtDiff = scheAmtDiff.add(billAmtDiff);
        if (isPositive) {
            sumData.setPositiveTotalAmt(sumData.getPositiveTotalAmt().add(totalAmtDiff));
            sumData.setPositiveApplyAmt(sumData.getPositiveApplyAmt().add(applyAmtDiff));
        } else {
            sumData.setNegateTotalAmt(sumData.getNegateTotalAmt().add(totalAmtDiff));
            sumData.setNegateApplyAmt(sumData.getNegateApplyAmt().add(applyAmtDiff));
        }
        sumData.setScheBalance(sumData.getScheBalance().add(newScheData.getActualBalanceAmt()).subtract(oldScheBalance));
    }

    @Override
    protected void afterHandleSumInfo(PayScheSumData sumData) {
        super.afterHandleSumInfo(sumData);
        if (sumData.getApplyAmt().compareTo(BigDecimal.ZERO) == 0) {
            sumData.setPercent("0%");
        } else {
            sumData.setPercent(sumData.getScheAmt().add(sumData.getDraftAmt()).divide(sumData.getApplyAmt(), 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(0, RoundingMode.HALF_UP) + "%");
        }
        BigDecimal totalAmtAbs = sumData.getNegateTotalAmt().negate().add(sumData.getPositiveTotalAmt());
        BigDecimal totalApplyAmtAbs = sumData.getNegateApplyAmt().negate().add(sumData.getPositiveApplyAmt());
        BigDecimal percent = BigDecimal.ZERO;
        if (totalApplyAmtAbs.compareTo(BigDecimal.ZERO) != 0) {
            percent = totalAmtAbs.divide(totalApplyAmtAbs, 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(0, RoundingMode.HALF_UP);
        }
        if (percent.compareTo(new BigDecimal(100)) == 0 && totalAmtAbs.compareTo(totalApplyAmtAbs) != 0) {
            percent = new BigDecimal(99);
        }
        sumData.setPercent(percent + "%");
    }

    public boolean isSumSche() {
        return this.sumRepo.isSumSche(this.orgId, this.periodTypeId);
    }

    public void fixSumScheData(PayScheSumData sumData, List<PayScheCalcModel> scheDataList) {
        Set currencyIdSet = scheDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet());
        Map scaleMap = TmcAmountHelper.getScaleMap(currencyIdSet);
        BigDecimal positiveSumApplyAmt = scheDataList.stream().filter(o -> StringUtils.isEmpty((String)o.getBatchnum())).filter(o -> {
            Long applySettlementTypeId = o.getApplySettlementTypeId();
            if (applySettlementTypeId == null) {
                return true;
            }
            DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((Object)applySettlementTypeId, (String)"bd_settlementtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                String typeString = settleType.getString("settlementtype");
                return !SettleMentTypeEnum.DIGITALWALLET.getValue().equals(typeString);
            }
            return true;
        }).filter(o -> EmptyUtil.isEmpty((Long)o.getEntrustPayId())).filter(o -> ScheStatusEnum.SCHEDULING.getValue().equals(o.getScheStatus())).map(o -> o.getActualApplyAmt((Integer)scaleMap.get(o.getCurrencyId()))).filter(o -> o.compareTo(BigDecimal.ZERO) > 0).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        sumData.setApplyAmt(positiveSumApplyAmt);
    }

    public SumScheInfo getSumScheInfo(String dimType, String dimVal) {
        this.periodTypeId = Optional.ofNullable(this.periodTypeId).map(o -> o).orElseGet(() -> 0L);
        return this.sumRepo.getSumScheInfo(this.orgId, this.periodTypeId, dimType, dimVal);
    }

    public String getDimType() {
        return this.dimType;
    }

    public SumScheInfo updateSumScheInfo(String dimType, SumScheInfo sumScheInfo) {
        return this.sumRepo.updateSumScheInfo(this.orgId, this.periodTypeId, dimType, sumScheInfo);
    }

    private List<PayScheSumData> createFromPayScheSumData(String dimType, List<PayScheCalcModel> payScheDataList) {
        Map<String, List<PayScheCalcModel>> scheDataMapBySumInfo = payScheDataList.stream().collect(Collectors.groupingBy(o -> this.getDimVal((PayScheCalcModel)o, dimType)));
        Collection<List<PayScheCalcModel>> scheDataListColl = scheDataMapBySumInfo.values();
        ArrayList<List<PayScheCalcModel>> scheDataLists = new ArrayList<List<PayScheCalcModel>>(scheDataListColl);
        ArrayList<PayScheSumData> sumDataList = new ArrayList<PayScheSumData>(10);
        Map<Object, DynamicObject> dimValMap = this.getDimValMapByDimType(dimType, payScheDataList);
        for (int i = 0; i < scheDataLists.size(); ++i) {
            PayScheCalcModel firstPayScheData = (PayScheCalcModel)((List)scheDataLists.get(i)).get(0);
            PayScheSumData sumData = new PayScheSumData();
            sumData.setSummaryId(Long.valueOf(i));
            sumData.setCurrencyId(firstPayScheData.getCurrencyId());
            String dimName = this.getDefaultDimName(dimType, firstPayScheData, dimValMap);
            sumData.setDimName(dimName);
            sumData.setDimVal(this.getDimVal(firstPayScheData, dimType));
            for (PayScheCalcModel scheData : (List)scheDataLists.get(i)) {
                if (scheData.getSummaryId() != null && scheData.getSummaryId() == -1L) {
                    scheData.setSummaryId(-1L);
                    continue;
                }
                scheData.setSummaryId(sumData.getSummaryId());
            }
            sumDataList.add(sumData);
        }
        return sumDataList;
    }

    private void handleSumScheRule(List<PayScheSumData> sumDataList, String dimType) {
        ArrayList<PayScheSumData> tempSumScheDataList = new ArrayList<PayScheSumData>();
        boolean isSumSche = this.sumRepo.isSumSche(this.orgId, this.periodTypeId);
        DynamicObject sumRule = null;
        if (isSumSche) {
            sumRule = this.sumRepo.getSumScheRule(this.orgId, this.periodTypeId);
        }
        if (sumRule != null) {
            List<SumScheInfo> sumInfoList = this.sumRepo.getSumScheInfoList(sumRule, dimType);
            for (SumScheInfo sumScheInfo : sumInfoList) {
                sumDataList.stream().filter(sumScheInfo::isMatchSumData).findFirst().ifPresent(o -> {
                    tempSumScheDataList.add((PayScheSumData)o);
                    o.setDimName(sumScheInfo.getName());
                });
            }
            HashSet<PayScheSumData> sumDataSet = new HashSet<PayScheSumData>(sumDataList);
            sumDataSet.removeAll(tempSumScheDataList);
            tempSumScheDataList.addAll(sumDataSet);
            Set storedDimValSet = sumInfoList.stream().map(SumScheInfo::getSumDimVal).collect(Collectors.toSet());
            List<PayScheSumData> newSumList = sumDataList.stream().filter(o -> !storedDimValSet.contains(o.getDimVal())).collect(Collectors.toList());
            this.sumRepo.insertSumScheInfo(this.orgId, this.periodTypeId, dimType, newSumList);
        } else {
            tempSumScheDataList.addAll(sumDataList);
        }
        sumDataList.clear();
        sumDataList.addAll(tempSumScheDataList);
    }

    private Map<Object, DynamicObject> getDimValMapByDimType(String dimType, List<PayScheCalcModel> payScheDataList) {
        Object[] idArr;
        String entityName;
        if (SumDimTypeEnum.PAYTYPE.getValue().equals(dimType)) {
            entityName = "cas_paymentbilltype";
            idArr = payScheDataList.stream().map(PayScheCalcModel::getPaymenttypeId).filter(Objects::nonNull).distinct().toArray();
        } else if (SumDimTypeEnum.FUNDITEM.getValue().equals(dimType)) {
            entityName = "cas_fundflowitem";
            idArr = payScheDataList.stream().map(PayScheCalcModel::getFundUsageId).filter(Objects::nonNull).distinct().toArray();
        } else if (SumDimTypeEnum.PROJECT.getValue().equals(dimType)) {
            entityName = "bd_project";
            idArr = payScheDataList.stream().map(PayScheCalcModel::getProjectId).filter(Objects::nonNull).distinct().toArray();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"SumScheService_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        return this.batchLoadDataList(entityName, idArr);
    }

    private Map<Object, DynamicObject> batchLoadDataList(String entityName, Object[] idArr) {
        DynamicObject[] paymentTypeArr = TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        return Arrays.stream(paymentTypeArr).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
    }

    private String getDefaultDimName(String dimType, PayScheCalcModel payScheCalcModel, Map<Object, DynamicObject> dimValMap) {
        String dimName = null;
        if (SumDimTypeEnum.PAYTYPE.getValue().equals(dimType)) {
            DynamicObject payType = dimValMap.get(payScheCalcModel.getPaymenttypeId());
            dimName = payType != null ? payType.getString("name") : null;
        } else if (SumDimTypeEnum.PROJECT.getValue().equals(dimType)) {
            DynamicObject project = dimValMap.get(payScheCalcModel.getProjectId());
            dimName = project != null ? project.getString("name") : null;
        } else if (SumDimTypeEnum.FUNDITEM.getValue().equals(dimType)) {
            DynamicObject fundFlowItem = dimValMap.get(payScheCalcModel.getFundUsageId());
            String string = dimName = fundFlowItem != null ? fundFlowItem.getString("name") : null;
        }
        if (dimName == null) {
            dimName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SumScheService_2", (String)"tmc-psd-business", (Object[])new Object[0]);
        }
        return dimName;
    }

    private String getDimVal(PayScheCalcModel payScheCalcModel, String dimType) {
        StringBuilder dimValBuilder = new StringBuilder();
        dimValBuilder.append(payScheCalcModel.getCurrencyId());
        dimValBuilder.append(':');
        if (SumDimTypeEnum.PAYTYPE.getValue().equals(dimType)) {
            dimValBuilder.append(payScheCalcModel.getPaymenttypeId() != null ? payScheCalcModel.getPaymenttypeId().toString() : "");
        } else if (SumDimTypeEnum.PROJECT.getValue().equals(dimType)) {
            dimValBuilder.append(payScheCalcModel.getProjectId() != null ? payScheCalcModel.getProjectId().toString() : "");
        } else if (SumDimTypeEnum.FUNDITEM.getValue().equals(dimType)) {
            dimValBuilder.append(payScheCalcModel.getFundUsageId() != null ? payScheCalcModel.getFundUsageId().toString() : "");
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"SumScheService_3", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        return dimValBuilder.length() != 0 && !dimValBuilder.toString().equals("null") ? dimValBuilder.toString() : "_____NULL_DIM_VAL__";
    }
}

