/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.sumsche;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.sumsche.SumSchePrimeComparator;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumSchePrimeRule;

public class SumSchePrimeSorter {
    private List<SumSchePrimeRule> ruleList;

    public SumSchePrimeSorter(DynamicObject primeRule) {
        DynamicObjectCollection entry = primeRule.getDynamicObjectCollection("e_entry");
        this.ruleList = entry.stream().map(o -> {
            String dimType = o.getString("e_effectelement");
            String dimVal = o.getString("e_settingsave_TAG");
            return SumSchePrimeRule.createRuleFromJson(dimType, dimVal);
        }).collect(Collectors.toList());
    }

    public void sort(List<WaitScheData> autoScheDataList) {
        autoScheDataList.sort(new SumSchePrimeComparator(this.ruleList, autoScheDataList));
        for (int i = 0; i < autoScheDataList.size(); ++i) {
            autoScheDataList.get(i).getPayScheData().setPrimary(i + 1);
        }
    }
}

