/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.sumsche;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSumData;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;

public class SumScheRepository {
    public boolean isSumSche(Long orgId, Long periodTypeId) {
        boolean exists = true;
        exists = periodTypeId == null || Long.compare(periodTypeId, 0L) == 0 ? TmcDataServiceHelper.exists((String)"psd_sumscherule", (QFilter[])this.getSumScheRuleFilters(orgId)) : TmcDataServiceHelper.exists((String)"psd_sumscherule", (QFilter[])this.getSumScheRuleFilters(orgId, periodTypeId));
        return exists;
    }

    public List<SumScheInfo> getSumScheInfoList(long orgId, long periodTypeId, String dimType) {
        DynamicObject rule = this.getSumScheRule(orgId, periodTypeId);
        return this.getSumScheInfoList(rule, dimType);
    }

    public List<SumScheInfo> getSumScheInfoList(DynamicObject rule, String dimType) {
        String defaultDimType = rule.getString("dimension");
        if (dimType == null) {
            dimType = defaultDimType;
        }
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("entry");
        String finalDimType = dimType;
        List<SumScheInfo> sumScheInfoList = ruleEntry.stream().filter(o -> {
            String entryDimType = o.getString("edimension");
            return finalDimType.equals(entryDimType);
        }).map(this::fromDynamicObject).collect(Collectors.toList());
        return sumScheInfoList;
    }

    public SumScheInfo getSumScheInfo(long orgId, long periodTypeId, String dimType, String dimVal) {
        DynamicObject rule = this.getSumScheRule(orgId, periodTypeId);
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("entry");
        DynamicObject matchedEntry = ruleEntry.stream().filter(o -> {
            String entryDimType = o.getString("edimension");
            String entryDimVal = o.getString("condition_val");
            return entryDimType.equals(dimType) && entryDimVal.equals(dimVal);
        }).findFirst().orElseGet(() -> null);
        if (matchedEntry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6c47\u603b\u4fe1\u606f\u3002", (String)"SumScheRepository_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        SumScheInfo sumScheInfo = this.fromDynamicObject(matchedEntry);
        DynamicObject primeRule = matchedEntry.getDynamicObject("primerule");
        if (primeRule != null && EmptyUtil.isNoEmpty((DynamicObject)primeRule) && !primeRule.getBoolean("enable")) {
            sumScheInfo.setPrimaryRuleId(null);
        }
        return sumScheInfo;
    }

    public List<SumScheInfo> insertSumScheInfo(long orgId, long periodTypeId, String dimType, List<PayScheSumData> sumDataList) {
        DynamicObject rule = this.getSumScheRule(orgId, periodTypeId);
        DynamicObject preInsPrimeRule = this.getPreInsPrimeRule();
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("entry");
        Set oldDimValSet = ruleEntry.stream().map(o -> o.getString("condition_val")).collect(Collectors.toSet());
        List newSumDataList = sumDataList.stream().filter(o -> !oldDimValSet.contains(o.getDimVal())).collect(Collectors.toList());
        DynamicObjectType entryType = ruleEntry.getDynamicObjectType();
        List newEntryList = newSumDataList.stream().map(o -> {
            DynamicObject entry = new DynamicObject(entryType);
            entry.set("itemname", (Object)o.getDimName());
            entry.set("edimension", (Object)dimType);
            entry.set("condition_val", (Object)o.getDimVal());
            entry.set("payratio", (Object)BigDecimal.ONE);
            entry.set("primerule", (Object)preInsPrimeRule);
            return entry;
        }).collect(Collectors.toList());
        ruleEntry.addAll(newEntryList);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_sumscherule", (DynamicObject[])new DynamicObject[]{rule}, (OperateOption)OperateOption.create());
        List<SumScheInfo> sumScheInfoList = this.getSumScheInfoList(rule, dimType);
        List<SumScheInfo> newSumScheInfoList = sumScheInfoList.stream().filter(o -> o.getSumDimType().equals(dimType) && !oldDimValSet.contains(o.getSumDimVal())).collect(Collectors.toList());
        return newSumScheInfoList;
    }

    public SumScheInfo updateSumScheInfo(long orgId, long periodTypeId, String dimType, SumScheInfo sumScheInfo) {
        DynamicObject rule = this.getSumScheRule(orgId, periodTypeId);
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("entry");
        ruleEntry.stream().filter(o -> o.getString("edimension").equals(dimType) && o.getString("condition_val").equals(sumScheInfo.getSumDimVal())).findFirst().ifPresent(o -> {
            o.set("itemname", (Object)sumScheInfo.getName());
            o.set("payratio", (Object)sumScheInfo.getFundScale());
            o.set("draftratio", (Object)sumScheInfo.getBillScale());
            Long ruleId = sumScheInfo.getPrimaryRuleId();
            if (ruleId != null && ruleId != 0L) {
                DynamicObject primeRule = TmcDataServiceHelper.loadSingle((Object)ruleId, (String)"psd_prime_rule");
                o.set("primerule", (Object)primeRule);
            } else {
                o.set("primerule", null);
            }
        });
        TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_sumscherule", (DynamicObject[])new DynamicObject[]{rule}, (OperateOption)OperateOption.create());
        return sumScheInfo;
    }

    private SumScheInfo fromDynamicObject(DynamicObject obj) {
        SumScheInfo info = new SumScheInfo();
        info.setName(obj.getString("itemname"));
        info.setSumDimType(obj.getString("edimension"));
        info.setSumDimVal(obj.getString("condition_val"));
        info.setBillScale(obj.getBigDecimal("draftratio"));
        info.setFundScale(obj.getBigDecimal("payratio"));
        DynamicObject rule = obj.getDynamicObject("primerule");
        if (rule != null) {
            info.setPrimaryRuleId((Long)rule.getPkValue());
        }
        return info;
    }

    public DynamicObject getSumScheRule(long orgId, long periodTypeId) {
        QFilter[] filters = Long.compare(periodTypeId, 0L) == 0 ? this.getSumScheRuleFilters(orgId) : this.getSumScheRuleFilters(orgId, periodTypeId);
        DynamicObject[] ruleArr = TmcDataServiceHelper.load((String)"psd_sumscherule", (String)"id", (QFilter[])filters);
        if (ruleArr == null || ruleArr.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u67e5\u8be2\u5230\u6c47\u603b\u6392\u7a0b\u89c4\u5219\u3002", (String)"SumScheRepository_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        DynamicObject rule = TmcDataServiceHelper.loadSingle((Object)ruleArr[0].getPkValue(), (String)"psd_sumscherule");
        return rule;
    }

    private QFilter[] getSumScheRuleFilters(long orgId, long periodTypeId) {
        return new QFilter[]{new QFilter("company", "=", (Object)orgId), new QFilter("enable", "=", (Object)"1"), new QFilter("effecttime", "<=", (Object)DateUtils.getCurrentDate()), new QFilter("periodtype", "=", (Object)periodTypeId)};
    }

    private QFilter[] getSumScheRuleFilters(long orgId) {
        return new QFilter[]{new QFilter("company", "=", (Object)orgId), new QFilter("enable", "=", (Object)"1"), new QFilter("effecttime", "<=", (Object)DateUtils.getCurrentDate())};
    }

    private DynamicObject getPreInsPrimeRule() {
        QFilter preInsFilter = new QFilter("predata", "=", (Object)"1");
        DynamicObject[] preInsDataArr = TmcDataServiceHelper.load((String)"psd_prime_rule", (String)"id", (QFilter[])new QFilter[]{preInsFilter});
        if (preInsDataArr.length > 0) {
            return preInsDataArr[0];
        }
        return null;
    }
}

