/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.sumsche.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.psd.business.service.paysche.sumsche.data.PrimeRuleVal;
import kd.tmc.psd.common.enums.PsdEffectEleEnum;

public class SumSchePrimeRule<T> {
    public static final int DIM_CATE_NULL = 0;
    public static final int DIM_CATE_CONST = 1;
    public static final int DIM_CATE_GRP = 2;
    public static final int DIM_CATE_BTP = 3;
    private String dimType;
    private List<T> sortedValList;

    public static SumSchePrimeRule<?> createRuleFromJson(String dimType, String valJson) {
        int cate = SumSchePrimeRule.getDimCate(dimType);
        if (1 == cate) {
            return SumSchePrimeRule.createTypeRuleFromJson(dimType, valJson);
        }
        if (2 == cate || 3 == cate) {
            return SumSchePrimeRule.createGrpRuleFromJson(dimType, valJson);
        }
        SumSchePrimeRule rule = new SumSchePrimeRule();
        rule.setDimType(dimType);
        return rule;
    }

    public static SumSchePrimeRule<List<PrimeRuleVal>> createGrpRuleFromJson(String dimType, String valJson) {
        SumSchePrimeRule<List<PrimeRuleVal>> rule = new SumSchePrimeRule<List<PrimeRuleVal>>();
        rule.setDimType(dimType);
        List sortedValList = (List)JSON.parseObject((String)valJson, (TypeReference)new TypeReference<List<List<PrimeRuleVal>>>(){}, (Feature[])new Feature[0]);
        rule.setSortedValList(sortedValList);
        return rule;
    }

    public static SumSchePrimeRule<PrimeRuleVal> createTypeRuleFromJson(String dimType, String valJson) {
        SumSchePrimeRule<PrimeRuleVal> rule = new SumSchePrimeRule<PrimeRuleVal>();
        rule.setDimType(dimType);
        List sortedValList = JSON.parseArray((String)valJson, PrimeRuleVal.class);
        rule.setSortedValList(sortedValList);
        return rule;
    }

    public static int getDimCate(String dimType) {
        if (PsdEffectEleEnum.APPLYDATE.getValue().equals(dimType) || PsdEffectEleEnum.EXPECTPAYDATE.getValue().equals(dimType)) {
            return 0;
        }
        if (PsdEffectEleEnum.PROJECTSORT.getValue().equals(dimType) || PsdEffectEleEnum.SUPPLIERSORT.getValue().equals(dimType)) {
            return 1;
        }
        if (PsdEffectEleEnum.SUPPLIERGROUP.getValue().equals(dimType) || PsdEffectEleEnum.PROJECTGROUP.getValue().equals(dimType)) {
            return 2;
        }
        if (PsdEffectEleEnum.PAYBILLTYPE.getValue().equals(dimType)) {
            return 3;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"SumSchePrimeRule_1", (String)"tmc-psd-business", (Object[])new Object[0]));
    }

    public String valToJson() {
        return JSON.toJSONString(this.getSortedValList());
    }

    public String printVal() {
        StringBuilder sb = new StringBuilder();
        List<T> sortedList = this.sortedValList;
        int cate = SumSchePrimeRule.getDimCate(this.dimType);
        for (T t : sortedList) {
            if (1 == cate) {
                PrimeRuleVal val = (PrimeRuleVal)t;
                sb.append(val.getName()).append(',');
                continue;
            }
            if (2 != cate && 3 != cate) break;
            List valList = ((List)t).stream().map(PrimeRuleVal::getName).collect(Collectors.toList());
            String str = String.join((CharSequence)",", valList);
            sb.append(str).append(';');
        }
        if (sb.length() > 0) {
            return sb.toString().length() < 1024 ? sb.substring(0, sb.length() - 1) : sb.substring(0, 1024);
        }
        return null;
    }

    public String getDimType() {
        return this.dimType;
    }

    public void setDimType(String dimType) {
        this.dimType = dimType;
    }

    public List<T> getSortedValList() {
        return this.sortedValList;
    }

    public void setSortedValList(List<T> sortedValList) {
        this.sortedValList = sortedValList;
    }

    public String toString() {
        return "SumSchePrimeRule{dimType='" + this.dimType + '\'' + ", sortedValList=" + this.sortedValList + '}';
    }
}

