/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.common.helper.PayScheHelper;

public class PeriodHelper {
    public static DynamicObject getCurrPeriod(Long orgId) {
        if (null == orgId) {
            return null;
        }
        Date currentDate = DateUtils.getCurrentDate();
        return PeriodHelper.getPeriodByDate(orgId, currentDate);
    }

    public static DynamicObject getPeriodByDate(Long orgId, Date date) {
        DynamicObject[] schePeriods = PeriodHelper.getPeriodByDates(orgId, date, date);
        return schePeriods != null && schePeriods.length > 0 ? schePeriods[0] : null;
    }

    public static DynamicObject[] getPeriodByDates(Object orgId, Date startDate, Date endDate) {
        DynamicObject[] result = null;
        startDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
        endDate = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        ArrayList<QFilter> conditions = new ArrayList<QFilter>(10);
        conditions.add(new QFilter("orgentryentity.org.id", "=", orgId));
        conditions.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        conditions.add(PayScheHelper.buildAutoRuleEffDateFilter());
        DynamicObject autoScheRule = TmcDataServiceHelper.loadSingle((String)"psd_autoschedule_rule", (String)"scheduleperiod", (QFilter[])conditions.toArray(new QFilter[0]));
        if (null == autoScheRule) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\uff0c\u8bf7\u5148\u8bbe\u7f6e\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"PeriodHelper_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        DynamicObject periodType = autoScheRule.getDynamicObject("scheduleperiod");
        if (null == periodType) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u6ca1\u6709\u542f\u7528\u7684\u5468\u671f\u7c7b\u578b\uff0c\u8bf7\u5148\u8bbe\u7f6e\u81ea\u52a8\u6392\u7a0b\u89c4\u5219(%s)\u7684\u5468\u671f\u7c7b\u578b\u3002", (String)"PeriodHelper_1", (String)"tmc-psd-business", (Object[])new Object[0]), autoScheRule.getString("name")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("schetype", "=", periodType.getPkValue()));
        qFilters.add(new QFilter("startdate", "<=", (Object)endDate));
        qFilters.add(new QFilter("enddate", ">=", (Object)startDate));
        DynamicObject[] schePeriods = TmcDataServiceHelper.load((String)"psd_schedule_period", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        result = PeriodHelper.loadAllProps(schePeriods);
        return result;
    }

    public static DynamicObject getNextPeriod(Long orgId) {
        DynamicObject currPeriod = PeriodHelper.getCurrPeriod(orgId);
        if (null != currPeriod) {
            return PeriodHelper.getNextPeriod(currPeriod.getPkValue());
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Object periodId) {
        DynamicObject currPeriod = TmcDataServiceHelper.loadSingle((Object)periodId, (String)"psd_schedule_period");
        if (null != currPeriod) {
            int periodYear = currPeriod.getInt("periodyear");
            int periodNum = currPeriod.getInt("periodnum");
            DynamicObject scheType = currPeriod.getDynamicObject("schetype");
            QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodYear), new QFilter("schetype", "=", scheType.getPkValue())};
            int periodSum = TmcDataServiceHelper.count((String)"psd_schedule_period", (QFilter[])filters);
            if (periodNum >= periodSum) {
                ++periodYear;
                periodNum = 1;
            } else {
                ++periodNum;
            }
            return PeriodHelper.getPeriodByYearAndNum(periodYear, periodNum, scheType.getPkValue());
        }
        return null;
    }

    public static DynamicObject getPeriodByYearAndNum(int periodYear, int periodNum, Object periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodYear), new QFilter("periodnum", "=", (Object)periodNum), new QFilter("schetype", "=", periodTypeId)};
        DynamicObject schePeriod = TmcDataServiceHelper.loadSingle((String)"psd_schedule_period", (String)"id", (QFilter[])filters);
        schePeriod = PeriodHelper.loadAllProps(schePeriod);
        return schePeriod;
    }

    private static DynamicObject loadAllProps(DynamicObject schePeriod) {
        if (null == schePeriod) {
            return null;
        }
        schePeriod = TmcDataServiceHelper.loadSingle((Object)schePeriod.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedule_period"));
        return schePeriod;
    }

    private static DynamicObject[] loadAllProps(DynamicObject[] schePeriods) {
        if (null == schePeriods || schePeriods.length == 0) {
            return schePeriods;
        }
        List schePeriodIds = Arrays.stream(schePeriods).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        schePeriods = TmcDataServiceHelper.load((Object[])schePeriodIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedule_period"));
        return schePeriods;
    }
}

